/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionLook
extends GameAction<CardIndex> {
    private CardIndex cardIndex;
    private Zone.ZonePosition zonePosition = Zone.ZonePosition.TOP;

    public ActionLook(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    public ActionLook(Zone.ZonePosition zonePosition) {
        this.zonePosition = zonePosition;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.getDataTable().add(null);
                this.setAsCompleted();
            }
            return;
        }
        this.setLogEvent(new LogEventMove(new EventMove(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.LOOKED), TargetFilter.TargetHint.LOOK));
        this.getDataTable().add(this.cardIndex);
        if (this.cardIndex.getLocation() == GameConst.CardLocation.LIFE_CLOTH) {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.cardIndex.getCurrentOwnerSafe()).moveNext(this.cardIndex.getImageSet(), false, this.getLogEvent());
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            if (this.cardIndex.getIndexedInstance() != null) {
                if (!Game.getCurrentGame().isNeutralPerspectiveGame()) {
                    if (!CardIndex.isOwnCard(this.cardIndex)) {
                        this.cardIndex.getSourceCard3D().clearCardIndex();
                    }
                } else if (this.cardIndex.getOldLocation() != GameConst.CardLocation.DECK_MAIN) {
                    boolean wasMainDeckCard = Card3D.isMainDeckCard(this.cardIndex.getSourceCard3D());
                    this.cardIndex.clearImageSet();
                    this.cardIndex.getSourceCard3D().updateImageSet();
                    this.cardIndex.getSourceCard3D().showAsPrivate(wasMainDeckCard);
                }
            }
            this.setAsCompleted();
        });
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe()).getLookZone());
        aniMove.setAnimationTracker(tracker);
        aniMove.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (this.cardIndex != null) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.cardIndex.getSourceCard3D());
        } else {
            CardIndex.getCardFromPacketData(pp.getDataArgument(1), this.zonePosition).ifPresent(card3D -> {
                this.cardIndex = card3D.getCardIndex();
            });
        }
    }
}

