/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.StringJoiner;
import open.batoru.Log;
import open.batoru.catalog.SearchFilter;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.GameAction;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCardCatalog;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;

public class ActionManualChoiceCatalog
extends GameAction<String> {
    private final int minPicks;
    private final SearchFilter.LockedFiltersAction handlerFilters;

    public ActionManualChoiceCatalog(int minPicks, SearchFilter.LockedFiltersAction handlerFilters) {
        this.minPicks = minPicks;
        this.handlerFilters = handlerFilters;
    }

    @Override
    protected void dispatch() {
        OverlayWindowCardCatalog window = new OverlayWindowCardCatalog(null, LanguageParser.getString("UI_GAME_WINDOW_CATALOG_DESC"), this.minPicks);
        window.setSearchFilter(new SearchFilter(window));
        if (this.handlerFilters != null) {
            window.getSearchFilter().applyFiltersInLockedState(this.handlerFilters);
        } else {
            window.resetSortingList();
        }
        this.addWindowActions(window);
    }

    final void addWindowActions(OverlayWindowCardCatalog window) {
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
            window.setLock(true);
            StringJoiner packetData = new StringJoiner("|");
            for (String imageSet : window.getPickedCards()) {
                packetData.add(imageSet);
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("PLCH", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                    for (String imageSet : window.getPickedCards()) {
                        this.getDataTable().add(imageSet);
                    }
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

