/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowChoiceCost;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;

public class ActionManualChoiceCost
extends GameAction<Integer> {
    private final String title;
    protected final List<AbilityCostList> dataCostLists;
    private final boolean isMandatory;
    protected boolean shouldDisableSkip;

    public ActionManualChoiceCost(List<AbilityCostList> dataCostLists) {
        this(dataCostLists, false);
    }

    public ActionManualChoiceCost(List<AbilityCostList> dataCostLists, boolean isMandatory) {
        this(LanguageParser.getString("UI_GAME_WINDOW_COST_TITLE"), dataCostLists, isMandatory);
    }

    protected ActionManualChoiceCost(String title, List<AbilityCostList> dataCostLists, boolean isMandatory) {
        this.title = title;
        this.dataCostLists = dataCostLists;
        this.isMandatory = isMandatory;
    }

    public final ActionManualChoiceCost forceDisableSkip(boolean shouldDisableSkip) {
        this.shouldDisableSkip = shouldDisableSkip;
        return this;
    }

    @Override
    protected void dispatch() {
        OverlayWindowChoiceCost window = new OverlayWindowChoiceCost(this.title, this.dataCostLists, this.isMandatory);
        if (this.shouldDisableSkip && !window.getDataPayableCostLists().isEmpty()) {
            window.hideConfirmButton();
        }
        if (!this.isMandatory && window.getDataPayableCostLists().isEmpty()) {
            this.setAsCompleted();
            return;
        }
        window.setOnCostChosen(costId -> {
            if (Game.getCurrentGame().getFakeReceiver() != null && !this.isMandatory && costId == -1) {
                OverlayWindow.removeFromFieldOverlay(window);
                this.setAsCompleted();
                return;
            }
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
            window.setLock(true);
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("PLCH", this, String.valueOf(costId));
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.getDataTable().add(costId);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        this.addWindow(window);
    }

    void addWindow(OverlayWindowChoiceCost window) {
        if ((!this.isMandatory || window.getDataPayableCostLists().isEmpty()) && window.getDataPayableCostLists().size() < 2 && Game.getCurrentGame().getFakeReceiver() == null) {
            window.getOnCostChosenHandler().handle(window.getDataPayableCostLists().size() == 1 ? window.getDataPayableCostLists().getFirst() : -1);
        } else {
            OverlayWindow.addToFieldOverlay(window);
        }
    }
}

