/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import open.batoru.Log;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.DataTable;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCardList;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;

public class ActionManualChoiceEventSource
extends GameAction<CardIndex> {
    private final DataTable<CardIndex> data;

    public ActionManualChoiceEventSource(DataTable<CardIndex> data) {
        this.data = data;
    }

    @Override
    protected void dispatch() {
        OverlayWindowCardList window = new OverlayWindowCardList(LanguageParser.getString("UI_GAME_WINDOW_EVENTSOURCE_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_EVENTSOURCE_DESC"), this.data.stream().map(CardIndex::getSourceCard3D).toList(), null, null, 1, 1);
        window.setAutoConfirm(true);
        window.getConfirmButton().setOnAction(e -> {
            window.setLock(true);
            window.getConfirmButton().setDisable(true);
            CardIndex cardIndex = window.getPickedList().getFirst().getCardIndex();
            String packetData = String.valueOf(cardIndex.getId());
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELC", this, packetData);
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    this.getDataTable().add(cardIndex);
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

