/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ModalAbility;
import open.batoru.data.ability.ModalChoiceRepeatTracker;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowChoiceMode;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;

public class ActionManualChoiceMode
extends GameAction<Integer> {
    private final int minPicks;
    private final int maxPicks;
    private int bitsDisabled;
    private final Ability sourceAbility;
    private final ModalChoiceRepeatTracker repeatChoiceTracker;

    public ActionManualChoiceMode(int minPicks, int maxPicks, Ability sourceAbility, int bitsDisabled, ModalChoiceRepeatTracker repeatChoiceTracker) {
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        this.bitsDisabled = bitsDisabled;
        this.sourceAbility = sourceAbility;
        this.repeatChoiceTracker = repeatChoiceTracker;
    }

    public ActionManualChoiceMode(ModalAbility sourceAbility) {
        this.minPicks = sourceAbility.getModeChoiceMinPicks().getValue();
        this.maxPicks = sourceAbility.getModeChoiceMaxPicks().getValue();
        this.sourceAbility = sourceAbility;
        this.repeatChoiceTracker = sourceAbility.getModalChoiceRepeatTracker();
    }

    @Override
    protected void dispatch() {
        OverlayWindowChoiceMode window = new OverlayWindowChoiceMode(this.minPicks, this.maxPicks, this.sourceAbility, this.bitsDisabled, this.repeatChoiceTracker);
        window.getConfirmButton().setOnAction(e -> {
            Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
            window.setLock(true);
            Object packetData = String.valueOf(window.getPickedModes());
            if (this.repeatChoiceTracker != null) {
                packetData = (String)packetData + this.repeatChoiceTracker.exportChoiceRepeatsData();
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("PLCH", this, (String)packetData);
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                    this.getDataTable().add(window.getPickedModes());
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

