/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEnerCharge;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.PlayerHand;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualEnerCharge
extends GameAction<CardIndex> {
    @Override
    protected void dispatch() {
        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        PlayerHand hand = field.getHand();
        for (Card3D card3D2 : hand.getZoneCardList()) {
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(card3D2, TargetFilter.TargetHint.ENER);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        }
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!FieldZone.isOccupied(zoneSIGNI)) continue;
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(zoneSIGNI, TargetFilter.TargetHint.ENER);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        }
        if (listAniBorder.isEmpty()) {
            this.setAsCompleted();
            return;
        }
        OverlayWindowCard window = new OverlayWindowCard(TargetFilter.TargetHint.ENER.getActionDescription(), LanguageParser.getString("UI_GAME_WINDOW_ENER_DESC"), 0, 1);
        window.setAutoConfirm(true);
        CardPicker picker = new CardPicker(0, hand.getTotalCards());
        picker.setOnPickValidate(card3D -> hand.isCardInHand((Card3D)card3D) || GameConst.CardLocation.isSIGNI(card3D.getCardIndex().getLocation()) && card3D.getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE && CardIndex.isOwnCard(card3D.getCardIndex()) && card3D.getOwnerZone().getTopCard() == card3D);
        picker.setOnPickHandled((card3D, wasAdded) -> {
            window.updatePickedCount(picker.getPickedCount());
            if (hand.isCardInHand((Card3D)card3D)) {
                hand.getHandHoverAnimation((Card3D)card3D).setLock(wasAdded);
            }
        });
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            Card3D card3D = null;
            String packetData = String.valueOf(0);
            if (picker.getPickedCount() > 0) {
                card3D = (Card3D)picker.getPickedList().getFirst();
                packetData = String.valueOf(card3D.getCardIndex().getId());
            }
            Card3D refCard3D = card3D;
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELC", this, packetData);
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    AnimationBorderIcon.stopAll(listAniBorder);
                    if (refCard3D != null) {
                        refCard3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                        ActionEnerCharge actionEner = new ActionEnerCharge(refCard3D.getCardIndex());
                        actionEner.dispatchAsChild(this);
                    } else {
                        this.setAsCompleted();
                    }
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

