/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import open.batoru.Log;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionExceed;
import open.batoru.data.ability.AbilityConst;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneLRIG;
import open.batoru.game._3d.Card3D;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCardList;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualExceed
extends GameAction<CardIndex> {
    private final boolean isEffect;
    private final int numToExceed;

    public ActionManualExceed(boolean isEffect, int numToExceed) {
        this.isEffect = isEffect;
        this.numToExceed = numToExceed;
    }

    @Override
    protected void dispatch() {
        ArrayList<Card3D> listCards = new ArrayList<Card3D>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        this.addExceedableCards(listCards, field.getLRIGZone());
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
            this.addExceedableCards(listCards, field.getLRIGAssistZoneLeft());
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
            this.addExceedableCards(listCards, field.getLRIGAssistZoneRight());
        }
        if (listCards.size() < this.numToExceed) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        OverlayWindowCardList window = new OverlayWindowCardList(LanguageParser.getString("UI_GAME_WINDOW_EXCEED_TITLE"), null, listCards, null, null, null, !this.isEffect ? this.numToExceed : 0, this.numToExceed, AbilityConst.ChoiceLogic.BOOLEAN);
        window.getConfirmButton().setOnAction(e -> {
            window.setLock(true);
            window.getConfirmButton().setDisable(true);
            StringJoiner packetData = new StringJoiner("|");
            packetData.setEmptyValue(String.valueOf(0));
            for (int i = 0; i < window.getPickedCount(); ++i) {
                packetData.add(String.valueOf(window.getPickedList().get(i).getCardIndex().getId()));
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("EXCEED", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    if (window.getPickedCount() > 0) {
                        CardIndex[] listCardIndexes = new CardIndex[window.getPickedCount()];
                        for (int i = 0; i < window.getPickedCount(); ++i) {
                            Card3D card3D = window.getPickedList().get(i);
                            listCardIndexes[i] = card3D.getCardIndex();
                        }
                        ActionExceed actionExceed = new ActionExceed(listCardIndexes);
                        actionExceed.dispatchAsChild(this);
                    } else {
                        this.getDataTable().add(null);
                        this.setAsCompleted();
                    }
                    OverlayWindow.removeFromFieldOverlay(window);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }

    private void addExceedableCards(List<Card3D> listCards, ZoneLRIG zoneLRIG) {
        for (int i = 0; i < zoneLRIG.getTotalCards() - 1; ++i) {
            Card3D card3D = zoneLRIG.getZoneCardList().get(i);
            if (card3D.getCardIndex().getUnderType() != GameConst.CardUnderType.UNDER_GENERIC) continue;
            listCards.add(card3D);
        }
    }
}

