/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.core.gameplay.actions.ActionGrow;
import open.batoru.core.gameplay.pickers.EnerColorPicker;
import open.batoru.core.gameplay.rulechecks.DataTableRuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.data.Cost;
import open.batoru.data.DataTable;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.game.FieldZoneEnerGroup;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneEner;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game._3d.EnerColor;
import open.batoru.game.animations.AnimationCardMoveInsertEnerSubstitute;
import open.batoru.game.animations.AnimationCardMoveRemoveEnerSubstitute;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowGrow;
import open.batoru.game.overlay.window.OverlayWindowWarnConfirmation;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualGrow
extends GameAction<CardIndex> {
    private final CardIndex cardIndexCurrentLRIG;
    private final CardIndex cardIndexNextLRIG;
    private final boolean shouldSendCurrentLRIGData;
    private OverlayWindowGrow window;
    private final List<FieldZoneEnerGroup> listEnerGroups = new ArrayList<FieldZoneEnerGroup>();
    private final Map<String, AbilityCost> mapCostStrings = new HashMap<String, AbilityCost>();
    private String currentCostString;
    private List<Card3DSubstitute> listEnerSubstitutes;

    public ActionManualGrow(CardIndex cardIndexCurrentLRIG, CardIndex cardIndexNextLRIG) {
        this(cardIndexCurrentLRIG, cardIndexNextLRIG, false);
    }

    public ActionManualGrow(CardIndex cardIndexCurrentLRIG, CardIndex cardIndexNextLRIG, boolean shouldSendCurrentLRIGData) {
        this.cardIndexCurrentLRIG = cardIndexCurrentLRIG;
        this.cardIndexNextLRIG = cardIndexNextLRIG;
        this.shouldSendCurrentLRIGData = shouldSendCurrentLRIGData;
    }

    @Override
    protected void dispatch() {
        DataTableRuleCheck ruleCheckDataEnerSubstitute;
        DataTable cardsEnerSubstitute;
        DataTable<String> dataCostStrings = this.getDataCostStrings();
        if (!dataCostStrings.get().isEmpty() && !(cardsEnerSubstitute = (DataTable)(ruleCheckDataEnerSubstitute = (DataTableRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.DATA_CARDS_ENER_SUBSTITUTE)).check(Game.getCurrentGame().getPlayerRole(), this, new Object[0])).isEmpty()) {
            this.listEnerSubstitutes = new ArrayList<Card3DSubstitute>();
            AnimationTracker tracker = new AnimationTracker(cardsEnerSubstitute.size());
            tracker.setOnTrackerAllFinished(() -> this.dispatchGrow(dataCostStrings));
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
            for (int i = 0; i < cardsEnerSubstitute.size(); ++i) {
                Card3D card3D = ((CardIndex)cardsEnerSubstitute.get(i)).getSourceCard3D();
                Card3DSubstitute card3DSubstitute = new Card3DSubstitute(card3D);
                this.listEnerSubstitutes.add(card3DSubstitute);
                AnimationCardMoveInsertEnerSubstitute aniInsert = new AnimationCardMoveInsertEnerSubstitute(card3DSubstitute, UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getEnerZone());
                aniInsert.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniInsert);
            }
            seqAni.play();
            return;
        }
        this.dispatchGrow(dataCostStrings);
    }

    private void dispatchGrow(DataTable<String> dataCostStrings) {
        if (!dataCostStrings.get().isEmpty()) {
            this.resetEnerGroups(dataCostStrings.get());
        }
        this.window = new OverlayWindowGrow(LanguageParser.getString("UI_GAME_WINDOW_GROW_TITLE"), !dataCostStrings.get().isEmpty() ? LanguageParser.getString("UI_GAME_WINDOW_GROW_DESC") : null, this.listEnerGroups, dataCostStrings, this.cardIndexCurrentLRIG, this.cardIndexNextLRIG);
        this.window.setAlias("grow");
        if (this.cardIndexNextLRIG == null) {
            this.window.hideConfirmButton();
        } else {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndexNextLRIG);
        }
        EnerColorPicker picker = new EnerColorPicker(dataCostStrings.get(), this.listEnerGroups);
        if (dataCostStrings.size() > 1) {
            this.window.setOnPayCostChanged(costString -> {
                picker.setCostString(costString);
                this.resetEnerGroups(costString);
                this.window.updateEnerGroups();
            });
        }
        picker.setOnPickHandled((enerColor, wasAdded) -> this.window.updatePickedCount(picker.getPickedCount(), enerColor.getColor(), picker));
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        this.window.getSkipButton().setOnAction(e -> {
            if (Game.getCurrentGame().getFakeReceiver() == null && this.cardIndexNextLRIG != null && this.cardIndexNextLRIG.getCardReference().getType() == CardConst.CardType.LRIG && this.currentCostString != null && this.mapCostStrings.get(this.currentCostString).canBePaid()) {
                OverlayWindowWarnConfirmation windowWarn = new OverlayWindowWarnConfirmation(LanguageParser.getString("UI_GAME_WINDOW_GROW_DESC_WARN"));
                windowWarn.setAlias("warn");
                windowWarn.setOnConfirm(isConfirmed -> {
                    OverlayWindow.removeFromFieldOverlay(windowWarn);
                    if (isConfirmed) {
                        this.sendAttempt("!1");
                    } else {
                        OverlayWindow.showWindow(this.window);
                    }
                });
                OverlayWindow.hideWindow(this.window);
                OverlayWindow.addToFieldOverlay(windowWarn);
            } else {
                this.sendAttempt("!1");
            }
        });
        this.window.getConfirmButton().setOnAction(e -> {
            StringBuilder packetData = new StringBuilder();
            if (picker.getPickedCount() > 0) {
                for (EnerColor enerColor : picker.getPickedList()) {
                    packetData.append(enerColor.getSourceEnerGroup().getSourceCard3D().getCardIndex().getId()).append("|").append(enerColor.getColor().getShortLabel()).append("|");
                }
                if (!this.shouldSendCurrentLRIGData) {
                    this.sendAttempt(packetData.substring(0, packetData.length() - 1));
                } else {
                    this.sendAttempt(packetData.append(this.cardIndexCurrentLRIG.getId()).toString());
                }
            } else {
                packetData.append("!2");
                if (this.shouldSendCurrentLRIGData) {
                    packetData.append("|").append(this.cardIndexCurrentLRIG.getId());
                }
                this.sendAttempt(packetData.toString());
            }
        });
        if (Game.getCurrentGame().getFakeReceiver() != null || this.existsHigherLevelGrowCandidate(this.cardIndexCurrentLRIG)) {
            OverlayWindow.addToFieldOverlay(this.window);
        } else {
            this.window.getSkipButton().fire();
        }
    }

    private void sendAttempt(String packetData) {
        Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
        this.window.getSkipButton().setDisable(true);
        this.window.getConfirmButton().setDisable(true);
        try {
            GameSendActionAttempt attempt = new GameSendActionAttempt("PAY", this, packetData);
            Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                if (!packetData.equals("!1")) {
                    ArrayList<ActionEnerPay.PaidEnerData> listPaidEnerData = new ArrayList<ActionEnerPay.PaidEnerData>();
                    for (int i = 0; i < this.listEnerGroups.size(); ++i) {
                        FieldZoneEnerGroup enerGroup = this.listEnerGroups.get(i);
                        enerGroup.getSourceCard3D().getChildren().remove((Object)enerGroup);
                        if (enerGroup.getSelectedEnerColor() == null) {
                            this.listEnerGroups.remove(i--);
                            continue;
                        }
                        listPaidEnerData.add(new ActionEnerPay.PaidEnerData(new CardIndexSnapshot(enerGroup.getSourceCard3D().getCardIndex()), enerGroup.getSelectedEnerColor().getColor()));
                    }
                    ActionGrow actionGrow = new ActionGrow(this.cardIndexNextLRIG, listPaidEnerData);
                    if (this.shouldSendCurrentLRIGData) {
                        actionGrow.setCard3DCurrentLRIG(this.cardIndexCurrentLRIG.getSourceCard3D());
                    }
                    actionGrow.dispatchAsChild(this);
                } else {
                    for (FieldZoneEnerGroup enerGroup : this.listEnerGroups) {
                        if (enerGroup.getSelectedEnerColor() != null) {
                            enerGroup.toggleSelect(enerGroup.getSelectedEnerColor());
                        }
                        enerGroup.getSourceCard3D().getChildren().remove((Object)enerGroup);
                    }
                    this.listEnerGroups.clear();
                    if (this.listEnerSubstitutes == null || this.listEnerSubstitutes.isEmpty()) {
                        this.setAsCompleted();
                    } else {
                        AnimationTracker tracker = new AnimationTracker(this.listEnerSubstitutes.size());
                        tracker.setOnTrackerAllFinished(this::setAsCompleted);
                        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
                        for (Card3DSubstitute card3DSubstitute : this.listEnerSubstitutes) {
                            AnimationCardMoveRemoveEnerSubstitute aniMove = new AnimationCardMoveRemoveEnerSubstitute(card3DSubstitute, UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getEnerZone());
                            aniMove.setAnimationTracker(tracker);
                            seqAni.getAnimationList().add(aniMove);
                        }
                        seqAni.play();
                    }
                }
                Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                OverlayWindow.removeFromFieldOverlay(this.window);
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            Log.printMessage(ex);
        }
    }

    private DataTable<String> getDataCostStrings() {
        DataTable<String> dataCostStrings = new DataTable<String>();
        if (this.cardIndexNextLRIG != null) {
            List<AbilityCostList> dataCostLists = this.cardIndexNextLRIG.getIndexedInstance().getCost();
            for (AbilityCostList costList : dataCostLists) {
                EnerCost cost = (EnerCost)costList.getDataArray().getFirst();
                dataCostStrings.add(cost.getCostString().getValue());
                this.mapCostStrings.put(cost.getCostString().getValue(), cost);
            }
        }
        if (dataCostStrings.isEmpty()) {
            dataCostStrings.add("");
        }
        return dataCostStrings;
    }

    private void resetEnerGroups(String costString) {
        if (!this.listEnerGroups.isEmpty()) {
            for (FieldZoneEnerGroup enerGroup : this.listEnerGroups) {
                if (enerGroup.getSelectedEnerColor() != null) {
                    enerGroup.toggleSelect(enerGroup.getSelectedEnerColor());
                }
                enerGroup.getSourceCard3D().getChildren().remove((Object)enerGroup);
            }
            this.listEnerGroups.clear();
        }
        this.currentCostString = costString;
        String costStringUnique = Cost.getUniqueCostString(costString);
        ZoneEner zoneEner = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getEnerZone();
        for (Card3D card3D : zoneEner.getZoneCardList()) {
            CardIndex cardIndex = card3D.getCardIndex();
            FieldZoneEnerGroup enerGroup = new FieldZoneEnerGroup(card3D);
            for (int i = costStringUnique.length() - 1; i >= 0; --i) {
                CardConst.CardColor color = CardConst.CardColor.getColorByShortLabel(costStringUnique.charAt(i));
                if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_PAY_COLOR).check(cardIndex, this, new Object[]{color}) != RuleCheck.RuleCheckState.OK) continue;
                enerGroup.addEnerColor(color);
            }
            if (enerGroup.getEnerColorsList().isEmpty()) continue;
            this.listEnerGroups.addFirst(enerGroup);
            card3D.getChildren().addFirst((Object)enerGroup);
        }
    }

    private boolean existsHigherLevelGrowCandidate(CardIndex cardIndexCurrentLRIG) {
        int level = cardIndexCurrentLRIG.getIndexedInstance().getLevel().getValue();
        if (level < 3) {
            return true;
        }
        if (level == 5) {
            return false;
        }
        if (UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(cardIndexCurrentLRIG.getCurrentOwnerSafe()).getDeckZone(Deck.DeckType.LRIG).getTotalCards() == 0) {
            return false;
        }
        return CardLoader.getDataCardObjects().stream().anyMatch(c -> c.getType() == CardConst.CardType.LRIG && c.getLevel() == level + 1 && c.getLRIGType().matches(cardIndexCurrentLRIG.getCardReference().getLRIGType()) && c.getDoubleFacedCardPairObject() == null && !c.getImageSets().getPrimaryImageSet().endsWith("B") && c.isAllowedInPlayFormat(Game.getCurrentGame().getRoom().getPlayFormat()));
    }

    public static CardIndex getNextGrowCandidateLRIG() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        CardIndex cardIndexCurrentLRIG = field.getLRIGZone().getTopCard().getCardIndex();
        for (Card3D card3D : field.getDeckZone(Deck.DeckType.LRIG).getZoneCardList()) {
            CardIndex cardIndex = card3D.getCardIndex();
            if (cardIndex.getCardReference().getType() != CardConst.CardType.LRIG || !ActionGrow.canGrowInto(cardIndexCurrentLRIG, cardIndex)) continue;
            return cardIndex;
        }
        return null;
    }
}

