/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javafx.scene.paint.Color;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventTarget;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.CardViewUnderCardsButton;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.game.overlay.log.events.LogEventTarget;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualTargetCard
extends GameAction<CardIndex> {
    private final List<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
    private OverlayWindowCard window;
    private CardPicker picker;
    private final List<CardIndex> cacheForcedTargets = new ArrayList<CardIndex>();
    private int pickedForcedTargets;
    private final int minPicks;
    private final int maxPicks;
    private final TargetFilter filter;
    private final ConditionHandler<CardIndex> condition;
    private final AbilityConst.ChoiceLogic choiceLogic;
    private final boolean isPrivateLocation;

    public ActionManualTargetCard(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<CardIndex> condition, AbilityConst.ChoiceLogic choiceLogic) {
        this.filter = filter;
        if (condition == null && filter.hasRequiredFilters()) {
            condition = filter::matchRequiredFilters;
        }
        this.condition = condition;
        this.choiceLogic = choiceLogic;
        this.isPrivateLocation = filter.getHintLocationsData().size() == 1 && (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.HAND) || filter.getHintLocationsData().contains((Object)GameConst.CardLocation.LOOKED)) && filter.getHintTargetType() != TargetFilter.TargetHint.TOP && filter.getHintTargetType() != TargetFilter.TargetHint.BOTTOM;
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
    }

    @Override
    protected void dispatch() {
        if (this.minPicks == 0 && this.maxPicks == 0) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        int countValid = this.filter.getValidTargetsCount();
        if (!this.isPrivateLocation && (countValid == 0 || countValid < this.minPicks || this.choiceLogic == AbilityConst.ChoiceLogic.BOOLEAN && countValid < this.maxPicks) || this.isPrivateLocation && this.filter.getTotalTargetsCount() == 0) {
            if (this.filter.isTargeted()) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_TARGETS"), Color.RED, 600);
            }
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        if (this.getSourceCost() != null && this.filter.getHintTargetType() == TargetFilter.TargetHint.GENERIC) {
            this.filter.setTargetHint(this.getSourceCost().getDefaultTargetHintType());
        }
        this.window = new OverlayWindowCard(this.filter.getHintTargetType().getActionDescription(), LanguageParser.getString("UI_GAME_WINDOW_TARGET_DESC"), this.minPicks, this.maxPicks != 100 ? this.maxPicks : countValid, this.choiceLogic);
        if (this.minPicks == 1 && this.maxPicks == 1 && this.filter.getTargetScope() == TargetFilter.TargetScope.CARD) {
            this.window.setAutoConfirm(true);
        }
        this.picker = new CardPicker(this.minPicks, this.maxPicks != 100 ? this.maxPicks : countValid, this.listAniBorder);
        this.picker.setValidateCondition(this.condition);
        this.picker.setOnPickValidate(this::isTargetValid);
        this.picker.setOnPickHandled((card3D, wasAdded) -> {
            if (!this.cacheForcedTargets.isEmpty()) {
                if (this.cacheForcedTargets.contains(card3D.getCardIndex())) {
                    this.pickedForcedTargets += wasAdded ? 1 : -1;
                }
                if (this.pickedForcedTargets < this.cacheForcedTargets.size()) {
                    this.refreshAniBorders();
                }
            }
            this.window.updatePickedCount(this.picker.getPickedCount(), this.picker);
        });
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(this.picker);
        Game.GamePlayerRole rolePlayer = this.filter.getSourceTargetRole();
        if ((this.filter.getHintOwnerFlags() & 1) != 0) {
            this.collectForcedTargetsData(rolePlayer);
        }
        if ((this.filter.getHintOwnerFlags() & 2) != 0) {
            this.collectForcedTargetsData(Game.GamePlayerRole.getOpponentRole(rolePlayer));
        }
        if ((this.filter.getHintOwnerFlags() & 1) != 0) {
            this.showAniBorders(rolePlayer);
        }
        if ((this.filter.getHintOwnerFlags() & 2) != 0) {
            this.showAniBorders(Game.GamePlayerRole.getOpponentRole(rolePlayer));
        }
        this.window.getConfirmButton().setOnAction(e -> {
            if (Game.getCurrentGame().getFakeReceiver() == null && !this.cacheForcedTargets.isEmpty() && this.pickedForcedTargets == 0 && !this.picker.getPickedCardIndexList().isEmpty()) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_TARGETS_FORCED"), Color.RED);
                return;
            }
            this.window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            StringJoiner packetData = new StringJoiner("|");
            if (this.picker.getPickedCount() > 0) {
                for (Card3D card3D : this.picker.getPickedList()) {
                    if (Game.getCurrentGame().getFakeReceiver() == null && GameConst.CardLocation.isPlayerPrivate(card3D.getCardIndex().getLocation())) {
                        card3D.getOwnerZone().markCardAsChosen(card3D);
                        card3D.getOwnerZone().swapWithKnownAlternativeIfAvailable(card3D);
                    }
                    packetData.add(String.valueOf(card3D.getCardIndex().getId()));
                }
            } else {
                packetData.setEmptyValue(String.valueOf(0));
                this.getDataTable().add(null);
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELC", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    AnimationBorderIcon.stopAll(this.listAniBorder);
                    CardViewUnderCardsButton.clearAllowedUnderTargetsList();
                    for (Card3D card3D : this.picker.getPickedList()) {
                        card3D.getVisibleMesh().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                        this.getDataTable().add(card3D.getCardIndex());
                        card3D.getOwnerZone().markCardAsChosen(card3D);
                    }
                    if (this.getDataTable().get() != null && this.filter.isTargeted()) {
                        for (int i = 0; i < this.getDataTable().size(); ++i) {
                            UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenTarget(this.getSourceAbility(), this.filter.getSourceTargetRole(), (CardIndex)this.getDataTable().get(i));
                            EventTarget event = new EventTarget((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.filter.getSourceTargetRole());
                            event.setAtOnce(i, this.getDataTable().size());
                            if (this.getSourceCost() == null) {
                                this.setLogEvent(new LogEventTarget(event));
                            }
                            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(event);
                        }
                        Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
                    }
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(this.window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if (this.minPicks > 1 || this.maxPicks > this.minPicks || this.filter.getTargetScope() == TargetFilter.TargetScope.ZONE || Game.getCurrentGame().getFakeReceiver() != null || !Settings.INSTANCE.shouldAutoConfirmChosenCards()) {
            OverlayWindow.addToFieldOverlay(this.window);
        }
        if (Game.getCurrentGame().getFakeReceiver() == null) {
            if (this.minPicks == 1 && this.maxPicks == 1 && this.filter.getTargetScope() == TargetFilter.TargetScope.CARD && this.listAniBorder.size() == 1 && this.listAniBorder.getFirst().getSourceCard3D() != null && this.listAniBorder.getFirst().getSourceCard3D().getCardIndex().getLocation() == GameConst.CardLocation.LRIG) {
                this.picker.pick(this.listAniBorder.getFirst().getSourceCard3D());
                this.window.getConfirmButton().fire();
            } else if (this.getSourceCost() != null && this.getSourceCost().hasDynamicCost() && this.getSourceCost().getCostMinCount() == this.listAniBorder.size()) {
                for (AnimationBorderIcon icon : this.listAniBorder) {
                    this.picker.pick(icon.getSourceCard3D());
                }
                this.window.getConfirmButton().fire();
            }
        }
    }

    private void collectForcedTargetsData(Game.GamePlayerRole rolePlayer) {
        if (this.filter.getTargetScope() == TargetFilter.TargetScope.CARD) {
            for (GameConst.CardLocation location : this.filter.getHintLocationsData()) {
                FieldZone zoneField;
                Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
                if (zone == null || zone.getZoneCardList().isEmpty() || !GameConst.CardLocation.isSIGNI(location) && !GameConst.CardLocation.isLRIG(location) || !FieldZone.isOccupied(zoneField = (FieldZone)zone) || !this.filter.isPickValid(zoneField.getTopCard()) || zoneField.getTopCard().getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_TARGETED).check(zoneField.getTopCard().getCardIndex(), this, new Object[]{Game.getCurrentGame().getPlayerRole()}) == RuleCheck.RuleCheckState.BLOCK || zoneField.getTopCard().getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.MUST_BE_TARGETED).check(zoneField.getTopCard().getCardIndex(), this, new Object[]{Game.getCurrentGame().getPlayerRole()}) == RuleCheck.RuleCheckState.BLOCK) continue;
                this.cacheForcedTargets.add(zoneField.getTopCard().getCardIndex());
            }
        }
    }

    private void showAniBorders(Game.GamePlayerRole rolePlayer) {
        for (GameConst.CardLocation location : this.filter.getHintLocationsData()) {
            AnimationBorderIcon aniBorder;
            Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
            if (zone == null || zone.getZoneCardList().isEmpty()) continue;
            if (GameConst.CardLocation.isSIGNI(location) || GameConst.CardLocation.isLRIG(location) || location == GameConst.CardLocation.CHECK_ZONE) {
                FieldZone zoneField = (FieldZone)zone;
                if (this.filter.getTargetScope() == TargetFilter.TargetScope.CARD) {
                    if (!FieldZone.isOccupied(zoneField) || !this.isTargetValid(zoneField.getTopCard())) {
                        continue;
                    }
                } else {
                    ArrayList<Card3D> listZoneUnderCards = new ArrayList<Card3D>(zone.getZoneCardList().stream().filter(this::isTargetValid).toList());
                    if (location != GameConst.CardLocation.CHECK_ZONE && listZoneUnderCards.isEmpty()) continue;
                    if (location != GameConst.CardLocation.CHECK_ZONE && FieldZone.isOccupied(zoneField) || listZoneUnderCards.size() > 1) {
                        zone.getTopCard().getViewUnderCardsButton().setSourcePicker(this.window, this.picker);
                        CardViewUnderCardsButton.addToAllowedUnderTargetsList(zoneField.getTopCard());
                    }
                }
                aniBorder = new AnimationBorderIcon(zone, this.filter.getHintTargetType());
                aniBorder.play();
                this.listAniBorder.add(aniBorder);
                continue;
            }
            for (Card3D card3D : zone.getZoneCardList()) {
                if (!this.isTargetValid(card3D)) continue;
                aniBorder = new AnimationBorderIcon(card3D, this.filter.getHintTargetType());
                aniBorder.play();
                this.listAniBorder.add(aniBorder);
            }
        }
    }

    private void refreshAniBorders() {
        AnimationBorderIcon.stopAll(this.listAniBorder);
        if ((this.filter.getHintOwnerFlags() & 1) != 0) {
            this.showAniBorders(this.filter.getSourceCardIndex().getIndexedInstance().getCurrentOwner());
        }
        if ((this.filter.getHintOwnerFlags() & 2) != 0) {
            this.showAniBorders(Game.GamePlayerRole.getOpponentRole(this.filter.getSourceCardIndex().getIndexedInstance().getCurrentOwner()));
        }
    }

    private boolean isTargetValid(Card3D card3D) {
        return this.filter.getHintLocationsData().contains((Object)card3D.getCardIndex().getLocation()) && this.filter.isPickValid(card3D) && (this.cacheForcedTargets.isEmpty() || this.pickedForcedTargets >= this.cacheForcedTargets.size() || this.cacheForcedTargets.contains(card3D.getCardIndex()) || this.picker.getPickedCardIndexList().contains(card3D.getCardIndex()));
    }
}

