/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javafx.scene.paint.Color;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.ZonePicker;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneCrossIndicatorGuides;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;

public class ActionManualTargetZone
extends GameAction<FieldZone> {
    private final List<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
    private OverlayWindowCard window;
    private final TargetFilter filter;
    private final ConditionHandler<FieldZone> condition;
    private final int minPicks;
    private int maxPicks;

    public ActionManualTargetZone(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<FieldZone> condition) {
        this.filter = filter;
        this.condition = condition;
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        filter.setTargetContext(TargetFilter.TargetContext.ZONE);
    }

    @Override
    protected void dispatch() {
        FieldZoneCrossIndicatorGuides crossIndicatorGuides;
        if (this.minPicks == 0 && this.maxPicks == 0) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        int countValid = this.filter.getValidTargetsCount();
        if (countValid == 0 || countValid < this.minPicks) {
            if (this.filter.isTargeted()) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_TARGETS"), Color.RED, 600);
            }
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        if (this.maxPicks == 100) {
            this.maxPicks = countValid;
        }
        if ((this.filter.getHintOwnerFlags() & 1) != 0) {
            this.showAniBorders(this.filter.getSourceTargetRole());
        }
        if ((this.filter.getHintOwnerFlags() & 2) != 0) {
            this.showAniBorders(Game.GamePlayerRole.getOpponentRole(this.filter.getSourceTargetRole()));
        }
        if (this.filter.getContextCardIndex() != null && this.filter.getContextCardIndex().getIndexedInstance() != null && this.filter.getHintFilterFlags() == 1 && this.filter.getHintTargetType() == TargetFilter.TargetHint.FIELD && (CardIndex.isOwnCard(this.filter.getContextCardIndex()) || Game.getCurrentGame().isNeutralPerspectiveGame())) {
            crossIndicatorGuides = new FieldZoneCrossIndicatorGuides();
            this.listAniBorder.forEach(aniBorder -> {
                Zone patt0$temp = aniBorder.getSourceZone();
                if (patt0$temp instanceof ZoneSIGNI) {
                    ZoneSIGNI zoneSIGNI = (ZoneSIGNI)patt0$temp;
                    crossIndicatorGuides.apply(this.filter.getContextCardIndex(), zoneSIGNI);
                }
            });
        } else {
            crossIndicatorGuides = null;
        }
        this.window = new OverlayWindowCard(null, LanguageParser.getString("UI_GAME_WINDOW_ZONE_DESC"), this.minPicks, this.maxPicks);
        if (this.minPicks == 1 && this.maxPicks == 1) {
            this.window.setAutoConfirm(true);
        }
        ZonePicker picker = new ZonePicker(this.minPicks, this.maxPicks, this.condition);
        picker.setOnPickValidate(this::isTargetValid);
        picker.setOnPickHandled((fieldZone, wasAdded) -> this.window.updatePickedCount(picker.getPickedCount()));
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        this.window.getConfirmButton().setOnAction(e -> {
            this.window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            StringJoiner packetData = new StringJoiner("|");
            if (picker.getPickedCount() > 0) {
                for (FieldZone fieldZone : picker.getPickedList()) {
                    packetData.add(fieldZone.getZoneLocation().getShortLabel());
                }
            } else {
                packetData.setEmptyValue("!1");
                this.getDataTable().add(null);
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELZ", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    AnimationBorderIcon.stopAll(this.listAniBorder);
                    if (crossIndicatorGuides != null) {
                        crossIndicatorGuides.clear();
                    }
                    for (FieldZone fieldZone : picker.getPickedList()) {
                        fieldZone.getZoneMesh().getMaterial().setDiffuseColor(fieldZone.getDefaultColor());
                        this.getDataTable().add(fieldZone);
                    }
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(this.window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if (this.minPicks > 1 || this.maxPicks > this.minPicks || Game.getCurrentGame().getFakeReceiver() != null || !Settings.INSTANCE.shouldAutoConfirmChosenCards()) {
            OverlayWindow.addToFieldOverlay(this.window);
        }
    }

    private void showAniBorders(Game.GamePlayerRole rolePlayer) {
        for (GameConst.CardLocation location : this.filter.getHintLocationsData()) {
            Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
            if (!(zone instanceof FieldZone) || !this.filter.getZoneValidator().isPickValid((FieldZone)zone)) continue;
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(zone, this.filter.getHintTargetType());
            aniBorder.play();
            this.listAniBorder.add(aniBorder);
        }
    }

    private boolean isTargetValid(FieldZone fieldZone) {
        return this.filter.getHintLocationsData().contains((Object)fieldZone.getZoneLocation()) && this.filter.getZoneValidator().isPickValid(fieldZone);
    }
}

