/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanPlaceSIGNIOnZone;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventPlace;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game.animations.AnimationZoneExchange;
import open.batoru.game.animations.tracker.AnimationTracker;

public class ActionMoveToSIGNIZone
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private final GameConst.CardLocation location;
    private final boolean isSilent;

    public ActionMoveToSIGNIZone(CardIndex cardIndex, GameConst.CardLocation location, Boolean isSilent) {
        this.cardIndex = cardIndex;
        this.location = location;
        this.isSilent = isSilent;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.location == null || !GameConst.CardLocation.isSIGNI(this.location) || this.cardIndex.getLocation() == this.location || this.getSourceAbility() != null && this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.cardIndex, this, new Object[]{this.location}) == RuleCheck.RuleCheckState.BLOCK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.cardIndex.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD).check(this.cardIndex.getIndexedInstance().getCurrentOwner(), this.cardIndex, this.getSourceAbility(), new Object[]{GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.location)}) == RuleCheck.RuleCheckState.BLOCK || !RuleCheckCanPlaceSIGNIOnZone.matchesResult((RuleCheckCanPlaceSIGNIOnZone)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.cardIndex.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PLACE_SIGNI_ON_ZONE), this.cardIndex.getIndexedInstance().getCurrentOwner(), GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.location))) {
            this.setAsCompleted();
            return;
        }
        Zone zone = FieldData.getZoneByLocation(this.cardIndex.getIndexedInstance().getCurrentOwner(), this.location);
        if (!(zone instanceof FieldZone) || FieldZone.isOccupied((FieldZone)zone)) {
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndex);
        if (!this.isSilent) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventMove(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.location));
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            if (!this.isSilent) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventPlace(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility()));
            }
            this.setAsCompleted();
        });
        AnimationZoneExchange aniExchange = new AnimationZoneExchange((ZoneSIGNI)this.cardIndex.getZoneByLocation(), (ZoneSIGNI)zone);
        aniExchange.setAnimationTracker(tracker);
        aniExchange.play();
    }
}

