/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.game.GameField;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionOpenHand
extends GameAction<Void> {
    @Override
    protected void dispatch() {
        if (!this.isDataReceived()) {
            this.requestData();
            return;
        }
        AnimationTracker tracker = new AnimationTracker(10);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        GameField field = UI.getTabGame().getFieldScene().getGameField();
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, 2);
        for (int i = 0; i < 5; ++i) {
            Card3D card3DTop = field.getTopPlayerField().getDeckZone(Deck.DeckType.MAIN).getTopCard(i);
            AnimationCardMove aniTop = new AnimationCardMove(card3DTop, field.getTopPlayerField().getHand());
            aniTop.setAnimationTracker(tracker);
            seqAni.getAnimationList(0).add(aniTop);
            Card3D card3DBottom = field.getBottomPlayerField().getDeckZone(Deck.DeckType.MAIN).getTopCard(i);
            AnimationCardMove aniBottom = new AnimationCardMove(card3DBottom, field.getBottomPlayerField().getHand());
            aniBottom.setAnimationTracker(tracker);
            seqAni.getAnimationList(1).add(aniBottom);
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        for (int i = 1; i < pp.getDataArgsNum(); ++i) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(i), UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getDeckZone(Deck.DeckType.MAIN).getTopCard(i - 1));
        }
    }
}

