/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringJoiner;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionGainCoins;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.GameField;
import open.batoru.game.PlayerField;
import open.batoru.game.PlayerHand;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.animations.AnimationCardFlip;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionOpenMulligan
extends GameAction<Void> {
    @Override
    protected void dispatch() {
        PlayerHand hand = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getHand();
        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        for (Card3D card3D2 : hand.getZoneCardList()) {
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(card3D2, TargetFilter.TargetHint.GENERIC);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        }
        OverlayWindowCard window = new OverlayWindowCard(LanguageParser.getString("UI_GAME_WINDOW_MULLIGAN_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_MULLIGAN_DESC"), 0, hand.getTotalCards());
        window.setShowPickedCount(false);
        Text textTurnPlayer = OverlayWindow.createText(Color.KHAKI, 14, LanguageParser.getString(Game.getCurrentGame().getGameRules().isOwnTurn() ? "UI_GAME_WINDOW_MULLIGAN_DESC_TURN_FIRST" : "UI_GAME_WINDOW_MULLIGAN_DESC_TURN_SECOND"));
        window.addTextToButtonsContainer(textTurnPlayer);
        CardPicker picker = new CardPicker(0, hand.getTotalCards(), listAniBorder);
        picker.setOnPickValidate(hand::isCardInHand);
        picker.setOnPickHandled((card3D, wasAdded) -> {
            window.updatePickedCount(picker.getPickedCount());
            hand.getHandHoverAnimation((Card3D)card3D).setLock(wasAdded);
        });
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            StringJoiner packetData = new StringJoiner("|");
            for (Card3D card3D : picker.getPickedList()) {
                card3D.getCardIndex().setLocation(GameConst.CardLocation.DECK_MAIN);
                packetData.add(String.valueOf(card3D.getCardIndex().getId()));
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELC", this.getOrderId(), packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, pp -> pp.getDataArgsNum() >= 4 && pp.getDataArgument(0).equals(String.valueOf(this.getOrderId())), pp -> {
                    if (pp.getDataArgument(2).contains("~")) {
                        int numTopHandRedrawnCards = Integer.parseInt(pp.getDataArgument(1));
                        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getTopPlayerField();
                        CardIndex.assignCardFromShortPacketData(pp.getDataArgument(2), field.getLRIGZone().getTopCard());
                        int handDataStartArgId = 3;
                        if (field.getLRIGAssistZoneLeft().getTopCard() != null) {
                            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(handDataStartArgId++), field.getLRIGAssistZoneLeft().getTopCard());
                        }
                        if (field.getLRIGAssistZoneRight().getTopCard() != null) {
                            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(handDataStartArgId++), field.getLRIGAssistZoneRight().getTopCard());
                        }
                        if (!picker.getPickedList().isEmpty()) {
                            for (int i = handDataStartArgId; i < pp.getDataArgsNum(); ++i) {
                                Card3D card3D = (Card3D)picker.getPickedList().get(i - handDataStartArgId);
                                card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                                hand.getHandHoverAnimation(card3D).setLock(false);
                                CardIndex.assignCardFromShortPacketData(pp.getDataArgument(i), card3D);
                                card3D.getCardIndex().setLocation(GameConst.CardLocation.HAND);
                            }
                        }
                    } else {
                        int numOwnHandRedrawnCards = Integer.parseInt(pp.getDataArgument(1));
                        int numOPHandRedrawnCards = Integer.parseInt(pp.getDataArgument(2));
                        PlayerField fieldHost = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Game.GamePlayerRole.HOST);
                        PlayerField fieldGuest = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Game.GamePlayerRole.GUEST);
                        CardIndex.assignCardFromShortPacketData(pp.getDataArgument(3), fieldHost.getLRIGZone().getTopCard());
                        int nextDataArgId = 4;
                        if (fieldHost.getLRIGAssistZoneLeft().getTopCard() != null) {
                            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(nextDataArgId++), fieldHost.getLRIGAssistZoneLeft().getTopCard());
                        }
                        if (fieldHost.getLRIGAssistZoneRight().getTopCard() != null) {
                            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(nextDataArgId++), fieldHost.getLRIGAssistZoneRight().getTopCard());
                        }
                        CardIndex.assignCardFromShortPacketData(pp.getDataArgument(nextDataArgId++), fieldGuest.getLRIGZone().getTopCard());
                        if (fieldGuest.getLRIGAssistZoneLeft().getTopCard() != null) {
                            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(nextDataArgId++), fieldGuest.getLRIGAssistZoneLeft().getTopCard());
                        }
                        if (fieldGuest.getLRIGAssistZoneRight().getTopCard() != null) {
                            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(nextDataArgId), fieldGuest.getLRIGAssistZoneRight().getTopCard());
                        }
                    }
                    AnimationBorderIcon.stopAll(listAniBorder);
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.dispatchOpenField();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }

    private void dispatchOpenField() {
        GameField field = UI.getTabGame().getFieldScene().getGameField();
        AnimationTracker tracker = new AnimationTracker(14);
        tracker.setOnTrackerAllFinished(() -> {
            Card3D cardLRIGSecond;
            Card3D cardLRIGFirst;
            int i;
            Card3D[] card3DTopLRIGLevel0 = new Card3D[]{field.getTopPlayerField().getLRIGZone().getTopCard(), field.getTopPlayerField().getLRIGAssistZoneLeft().getTopCard(), field.getTopPlayerField().getLRIGAssistZoneRight().getTopCard()};
            Card3D[] card3DBottomLRIGLevel0 = new Card3D[]{field.getBottomPlayerField().getLRIGZone().getTopCard(), field.getBottomPlayerField().getLRIGAssistZoneLeft().getTopCard(), field.getBottomPlayerField().getLRIGAssistZoneRight().getTopCard()};
            for (i = 0; i < 3; ++i) {
                if (card3DTopLRIGLevel0[i] == null) continue;
                AnimationCardFlip aniTop = new AnimationCardFlip(card3DTopLRIGLevel0[i]);
                aniTop.play();
            }
            field.getTopPlayerField().getFieldBackground().playAnimation(600, null, card3DTopLRIGLevel0[0].getCardIndex().getIndexedInstance().getColor().getPrimaryValue());
            for (i = 0; i < 3; ++i) {
                if (card3DBottomLRIGLevel0[i] == null) continue;
                AnimationCardFlip aniBottom = new AnimationCardFlip(card3DBottomLRIGLevel0[i]);
                aniBottom.play();
            }
            field.getBottomPlayerField().getFieldBackground().playAnimation(600, null, card3DBottomLRIGLevel0[0].getCardIndex().getIndexedInstance().getColor().getPrimaryValue());
            Game.GamePlayerRole rolePlayerFirst = Game.getCurrentGame().getGameRules().getTurnPlayer();
            Card3D card3D = cardLRIGFirst = rolePlayerFirst == Game.getCurrentGame().getPlayerRole() ? card3DBottomLRIGLevel0[0] : card3DTopLRIGLevel0[0];
            if (cardLRIGFirst.getCardIndex().getCardReference().getCoins() > 0) {
                ActionGainCoins action = new ActionGainCoins(rolePlayerFirst, cardLRIGFirst.getCardIndex().getCardReference().getCoins());
                action.setSourceCardIndex(cardLRIGFirst.getCardIndex());
                Game.getCurrentGame().getActionQueue().addAction(action);
            }
            Card3D card3D2 = cardLRIGSecond = rolePlayerFirst == Game.getCurrentGame().getPlayerRole() ? card3DTopLRIGLevel0[0] : card3DBottomLRIGLevel0[0];
            if (cardLRIGSecond.getCardIndex().getCardReference().getCoins() > 0) {
                ActionGainCoins action = new ActionGainCoins(Game.GamePlayerRole.getOpponentRole(rolePlayerFirst), cardLRIGSecond.getCardIndex().getCardReference().getCoins());
                action.setSourceCardIndex(cardLRIGSecond.getCardIndex());
                Game.getCurrentGame().getActionQueue().addAction(action);
            }
            Game.getCurrentGame().setGameState(Game.GameState.IN_PROGRESS);
            Game.getCurrentGame().getGameRules().initFirstTurn();
            UI.getTabGame().getFieldSceneOverlay().getGameControls().startGameDurationTimer();
            this.setAsCompleted();
        });
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, 2);
        for (int i = 0; i < 7; ++i) {
            Card3D card3DTop = field.getTopPlayerField().getDeckZone(Deck.DeckType.MAIN).getTopCard(i);
            Card3D card3DBottom = field.getBottomPlayerField().getDeckZone(Deck.DeckType.MAIN).getTopCard(i);
            AnimationCardMove aniLCTop = new AnimationCardMove(card3DTop, (Zone)field.getTopPlayerField().getDeckZone(Deck.DeckType.MAIN), field.getTopPlayerField().getLifeClothZone());
            aniLCTop.setAnimationTracker(tracker);
            seqAni.getAnimationList(0).add(aniLCTop);
            AnimationCardMove aniLCBottom = new AnimationCardMove(card3DBottom, (Zone)field.getBottomPlayerField().getDeckZone(Deck.DeckType.MAIN), field.getBottomPlayerField().getLifeClothZone());
            aniLCBottom.setAnimationTracker(tracker);
            seqAni.getAnimationList(1).add(aniLCBottom);
        }
        seqAni.play();
    }
}

