/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.callback.CallbackGameAction;
import open.batoru.core.gameplay.callback.CostCallbackThread;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;

public class ActionPayCost
extends CallbackGameAction {
    public static final int COST_PAYMENT_SKIPPED = -1;
    private static final Object BUSY_LOCK = new Object();
    private final AbilityCostList costList;

    public ActionPayCost(AbilityCostList costList) {
        this.costList = costList;
    }

    @Override
    protected void dispatch() {
        this.treatAsMidEffAction();
        this.haltCurrentCallbackAction(this.getCallbackAction());
        Game.getCurrentGame().getIdleStateCoordinator().markAsBusy(BUSY_LOCK);
        AbilityCost.setCallbackAction(this);
        this.startCallbackThread(new CostCallbackThread(this, this.costList, null));
        this.setAsCompleted();
    }

    public static void resetIsPayingCostsState() {
        Game.getCurrentGame().getIdleStateCoordinator().markAsIdle(BUSY_LOCK);
    }

    public static boolean isCostActionSuccessful(GameAction<Integer> action) {
        return action.isSuccessful() && action.getDataTable().get() != -1;
    }
}

