/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionPlayerChoice;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.networking.PacketParser;

public class ActionPlayerChoiceZone
extends ActionPlayerChoice<FieldZone> {
    public ActionPlayerChoiceZone(TargetFilter filter) {
        super(filter);
        if (filter != null) {
            this.getFilter().setTargetContext(TargetFilter.TargetContext.ZONE);
        }
    }

    @Override
    protected void dispatchOnSuccess() {
        AnimationTracker tracker = new AnimationTracker(this.getDataTable().size());
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        for (int i = 0; i < this.getDataTable().size(); ++i) {
            FieldZone zone = (FieldZone)this.getDataTable().get(i);
            if (zone == null) continue;
            AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(zone.getZoneMesh(), zone.getDefaultColor(), zone.isFlipped() ? Color.GREEN : Color.RED, true);
            aniFlash.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniFlash);
        }
        if (!seqAni.getAnimationList().isEmpty()) {
            seqAni.play();
        } else {
            this.setAsCompleted();
        }
    }

    @Override
    protected void processReceivedData(PacketParser pp) {
        if (!pp.getDataArgument(1).equals("!1")) {
            Game.GamePlayerRole rolePlayer;
            int i = 1;
            if (this.getFilter() == null || this.getFilter().getHintOwnerFlags() == 3) {
                rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(pp.getDataArgument(1)));
                i = 2;
            } else {
                rolePlayer = this.getFilter().getSourceTargetRole();
                if (this.getFilter().getHintOwnerFlags() == 2) {
                    rolePlayer = Game.GamePlayerRole.getOpponentRole(rolePlayer);
                }
            }
            while (i < pp.getDataArgsNum()) {
                this.getDataTable().add((FieldZone)FieldData.getZoneByLocation(rolePlayer, GameConst.CardLocation.getLocationByShortLabel(pp.getDataArgument(i))));
                ++i;
            }
        }
    }
}

