/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionManualChoiceCost;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.data.CardConst;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.events.EventEnter;
import open.batoru.data.ability.modifiers.CostModifier;
import open.batoru.game.PlayerField;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationFlashKey;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionPutOnFieldKey
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private final CostModifier costModifier;

    protected ActionPutOnFieldKey(CardIndex cardIndex, CostModifier costModifier) {
        this.cardIndex = cardIndex;
        this.costModifier = costModifier;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null || this.cardIndex.getCardReference().getType() != CardConst.CardType.KEY) {
            this.setAsCompleted();
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe());
        CardIndex cardIndexLRIG = field.getLRIGZone().getTopCard().getCardIndex();
        if (this.cardIndex.getIndexedInstance().getLRIGType().getPrimaryValue() != CardConst.CardLRIGType.NO_LRIG_LIMIT && !this.cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexLRIG.getIndexedInstance().getLRIGType())) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LRIG"), Color.RED, 600);
            this.setAsCompleted();
            return;
        }
        if (this.costModifier != null) {
            this.costModifier.modify(this.cardIndex.getIndexedInstance().getCost(), this.cardIndex, null);
        }
        if (!AbilityCostList.canPayDataCostLists(this.cardIndex.getIndexedInstance().getCost())) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SPELL_COST"), Color.RED, 600);
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndex);
        GameAction action = PlayerControl.isChoosingPlayer(this.cardIndex.getCurrentOwnerSafe()) ? new ActionManualChoiceCost(this.cardIndex.getIndexedInstance().getCost()) : new ActionPlayerChoiceInteger();
        action.setOnActionCompleted(() -> {
            if (action.isSuccessful()) {
                AbilityCostList costListChosen = this.cardIndex.getIndexedInstance().getCost().get((Integer)action.getDataTable().get());
                costListChosen.setOnCostHandledAll(() -> {
                    if (this.costModifier != null) {
                        this.costModifier.restore(this.cardIndex.getIndexedInstance().getCost());
                    }
                    this.dispatchActivate();
                });
                ActionPayCost actionPayCost = new ActionPayCost(costListChosen);
                if (Game.getCurrentGame().getFakeReceiver() != null) {
                    Game.getCurrentGame().getFakeReceiver().setLockNextDataRequests(true);
                }
                Game.getCurrentGame().getActionQueue().addAction(actionPayCost);
            }
        });
        action.treatAsMidEffAction();
        Game.getCurrentGame().getActionQueue().addAction(action);
        this.setAsCompleted();
    }

    private void dispatchActivate() {
        if (!CardIndex.isOwnCard(this.cardIndex)) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndex);
        }
        AnimationTracker tracker = new AnimationTracker(2);
        Game.getCurrentGame().getIdleStateCoordinator().markAsBusy(tracker);
        tracker.setOnTrackerAllFinished(() -> {
            Game.getCurrentGame().getIdleStateCoordinator().markAsIdle(tracker);
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
            ModifiableVariable.ModifiableValueReference<Integer> valueFlag = this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(1024);
            Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
                this.cardIndex.getIndexedInstance().getCardStateFlags().removeValue(valueFlag);
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventEnter(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility()));
            });
            Game.getCurrentGame().getGameRules().getRuleProcessor().process();
            if (Game.getCurrentGame().getFakeReceiver() != null) {
                Game.getCurrentGame().getFakeReceiver().setLockNextDataRequests(false);
                Game.getCurrentGame().getFakeReceiver().processIdle(Game.getCurrentGame().getActionQueue().getLastProcessedOrder() + 1);
            }
        });
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, 2);
        AnimationFlashKey aniFlash = new AnimationFlashKey(this.cardIndex, true);
        aniFlash.setAnimationTracker(tracker);
        seqAni.getAnimationList(0).add(aniFlash);
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe()).getKeyZone());
        aniMove.setAnimationTracker(tracker);
        seqAni.getAnimationList(1).add(aniMove);
        seqAni.play();
    }
}

