/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.Optional;
import javafx.scene.paint.Color;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionManualPutOnFieldResona;
import open.batoru.core.gameplay.actions.ActionManualTargetZone;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceZone;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSIGNI;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventDiscard;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventTrash;
import open.batoru.game.FieldConst;
import open.batoru.game.FieldZone;
import open.batoru.game.GameField;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.GizmoResona;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationCardMoveZoneDrop;
import open.batoru.game.animations.AnimationGizmoResonaCircleMove;
import open.batoru.game.animations.AnimationGizmoResonaCircleRotate;
import open.batoru.game.animations.AnimationGizmoResonaCircleRotateStop;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.game.animations.AnimationWait;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.FakeGameReceiver;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionPutOnFieldResona
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private Card3D[] listCards;
    private Group3D nodeZoneGizmo;
    private GizmoResona gizmoResona;
    private AnimationGizmoResonaCircleRotate aniCircleRotate;

    public ActionPutOnFieldResona(CardIndex cardIndex) {
        this(cardIndex, null);
    }

    public ActionPutOnFieldResona(CardIndex cardIndex, Card3D[] listCards) {
        this.cardIndex = cardIndex;
        this.listCards = listCards;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null) {
            this.setAsCompleted();
            return;
        }
        if (this.listCards != null) {
            this.dispatchPlayCondition();
            return;
        }
        if (!CardIndex.isOwnCard(this.cardIndex)) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndex);
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(this::dispatchPlayCondition);
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getIndexedInstance().getCurrentOwner()).getCheckZone());
        aniMove.setAnimationTracker(tracker);
        aniMove.play();
    }

    private void dispatchPlayCondition() {
        int i;
        if (this.listCards == null) {
            if (!this.isDataReceived()) {
                FakeGameReceiver fakeGameReceiver;
                if (CardIndex.isOwnCard(this.cardIndex) && !Game.getCurrentGame().isNeutralPerspectiveGame() && (fakeGameReceiver = Game.getCurrentGame().getFakeReceiver()) instanceof FakeGameReceiver) {
                    FakeGameReceiver fakeGameReceiver2 = fakeGameReceiver;
                    if (this.isChildAction() && this.getParentAction().getOrderId() == fakeGameReceiver2.getFinalOrder()) {
                        ActionManualPutOnFieldResona action = new ActionManualPutOnFieldResona(this.cardIndex);
                        action.dispatchAsChild(this);
                        return;
                    }
                }
                this.requestData(3);
            } else {
                this.setAsCompleted();
            }
            return;
        }
        UI.getTabGame().getFieldScene().getGameField().getTopPlayerField().setZoneColor(FieldConst.FIELD_COLOR_DARK);
        UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().setZoneColor(FieldConst.FIELD_COLOR_DARK);
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe());
        this.gizmoResona = new GizmoResona(this.listCards.length);
        this.nodeZoneGizmo = new Group3D();
        this.nodeZoneGizmo.setTranslate(field.getRevealZone().getNode());
        field.getChildren().add((Object)this.nodeZoneGizmo);
        this.nodeZoneGizmo.getChildren().add((Object)this.gizmoResona);
        this.aniCircleRotate = new AnimationGizmoResonaCircleRotate(this.gizmoResona);
        this.aniCircleRotate.setOnFinished(e -> this.aniCircleRotate.play());
        this.aniCircleRotate.play();
        AnimationTracker tracker = new AnimationTracker(this.listCards.length * 2 + this.gizmoResona.getCirclesCount());
        tracker.setOnTrackerAllFinished(() -> this.dispatchAnimationStop(field));
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        ArrayList<CardIndex> listDiscardedCards = new ArrayList<CardIndex>();
        for (i = 0; i < this.listCards.length; ++i) {
            LogEventMove logEventMove;
            AnimationCardMove aniMoveReveal = new AnimationCardMove(this.listCards[i], field.getRevealZone());
            aniMoveReveal.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMoveReveal);
            if (this.gizmoResona.getCircle(i) != null) {
                AnimationGizmoResonaCircleMove aniCircleMove = new AnimationGizmoResonaCircleMove(this.gizmoResona.getCircle(i), true);
                aniCircleMove.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniCircleMove);
            }
            AnimationCardMove aniMoveTrash = new AnimationCardMove(this.listCards[i], field.getTrashZone(Deck.DeckType.MAIN));
            aniMoveTrash.setDelay(500.0);
            aniMoveTrash.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMoveTrash);
            EventMove eventMove = new EventMove(this.listCards[i].getCardIndex(), this.cardIndex, null, null, GameConst.CardLocation.TRASH);
            eventMove.setAtOnce(i, this.listCards.length);
            EventTrash eventTrash = new EventTrash(this.listCards[i].getCardIndex(), this.cardIndex, null, null);
            eventTrash.setAtOnce(i, this.listCards.length);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventMove, eventTrash);
            if (this.listCards[i].getCardIndex().getLocation() == GameConst.CardLocation.HAND) {
                listDiscardedCards.add(this.listCards[i].getCardIndex());
                logEventMove = new LogEventMove(eventMove, AbilityConst.ActionHint.DISCARD);
            } else {
                logEventMove = new LogEventMove(eventMove, AbilityConst.ActionHint.TRASH);
            }
            UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventMove, false);
        }
        if (!listDiscardedCards.isEmpty()) {
            for (i = 0; i < listDiscardedCards.size(); ++i) {
                CardIndex cardIndexDiscarded = (CardIndex)listDiscardedCards.get(i);
                EventDiscard eventDiscard = new EventDiscard(cardIndexDiscarded, this.cardIndex, null, null);
                eventDiscard.setAtOnce(i, listDiscardedCards.size());
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventDiscard);
            }
        }
        seqAni.play();
    }

    private void dispatchAnimationStop(PlayerField field) {
        AnimationTracker tracker = new AnimationTracker(this.gizmoResona.getCirclesCount() * 2 + 1);
        tracker.setOnTrackerAllFinished(() -> {
            field.getChildren().remove((Object)this.nodeZoneGizmo);
            GameField.highlightPlayerField(null);
            this.dispatchPutOnField();
        });
        AnimationWait aniWait = new AnimationWait(250);
        aniWait.setOnFinished(e -> this.aniCircleRotate.setOnFinished(e2 -> {
            int i;
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, this.gizmoResona.getCirclesCount());
            for (int i2 = 1; i2 < this.gizmoResona.getCirclesCount(); ++i2) {
                seqAni.setParallelStreamDelay(i2, this.gizmoResona.getCirclesCount() + 1);
            }
            AnimationGizmoResonaCircleRotateStop aniCircleRotateStop = this.getAnimationGizmoResonaCircleRotateStop(field, tracker);
            seqAni.getAnimationList().add(aniCircleRotateStop);
            for (i = 0; i < this.gizmoResona.getCirclesCount(); ++i) {
                AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(this.gizmoResona.getCircle(i).getMesh(), Color.WHITE, CardConst.CardColor.utilCardColorToJavaFXColor(this.cardIndex.getCardReference().getColor().getPrimaryValue(), 0.35, 1.0), false);
                if (i > 0) {
                    aniFlash.setDelay(i * 25);
                }
                aniFlash.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniFlash);
            }
            for (i = 0; i < this.gizmoResona.getCirclesCount(); ++i) {
                AnimationGizmoResonaCircleMove aniCircleMove = new AnimationGizmoResonaCircleMove(this.gizmoResona.getCircle(i), false);
                if (i > 0) {
                    aniCircleMove.setDelay(i * 150);
                }
                aniCircleMove.setAnimationTracker(tracker);
                seqAni.getAnimationList(i).add(aniCircleMove);
            }
            seqAni.play();
        }));
        aniWait.play();
    }

    private AnimationGizmoResonaCircleRotateStop getAnimationGizmoResonaCircleRotateStop(PlayerField field, AnimationTracker tracker) {
        AnimationGizmoResonaCircleRotateStop aniCircleRotateStop = new AnimationGizmoResonaCircleRotateStop(this.gizmoResona);
        aniCircleRotateStop.setOnAnimationStarted(() -> {
            AnimationCardMoveZoneDrop aniMoveZoneDrop = new AnimationCardMoveZoneDrop(this.cardIndex.getSourceCard3D(), field.getRevealZone());
            aniMoveZoneDrop.setDelay(250.0);
            aniMoveZoneDrop.play();
        });
        aniCircleRotateStop.setAnimationTracker(tracker);
        return aniCircleRotateStop;
    }

    private void dispatchPutOnField() {
        TargetFilter filter = new TargetFilter(TargetFilter.TargetHint.FIELD).own().SIGNI().playable();
        filter.setTargetRole(this.cardIndex.getIndexedInstance().getCurrentOwner());
        GameAction actionTargetZone = PlayerControl.isChoosingPlayer(this.cardIndex.getCurrentOwnerSafe()) ? new ActionManualTargetZone(1, 1, filter, null) : new ActionPlayerChoiceZone(filter);
        actionTargetZone.setOnActionCompleted(() -> {
            if (actionTargetZone.isSuccessful()) {
                ActionPutOnFieldSIGNI actionPutOnField = new ActionPutOnFieldSIGNI(this.cardIndex, ((FieldZone)actionTargetZone.getDataTable().get()).getZoneLocation(), 0);
                Game.getCurrentGame().getActionQueue().addAction(actionPutOnField);
            } else {
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            }
        });
        Game.getCurrentGame().getActionQueue().addAction(actionTargetZone);
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        Optional<Card3D> card3D;
        this.listCards = new Card3D[pp.getDataArgsNum() - 2];
        for (int i = 2; i < pp.getDataArgsNum() && !(card3D = CardIndex.getCardFromPacketData(pp.getDataArgument(i))).isEmpty(); ++i) {
            this.listCards[i - 2] = card3D.get();
        }
    }
}

