/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.control.UtilCardPlayableControl;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.RuleCheckCanPlaceSIGNIOnZone;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.EnterAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventAttack;
import open.batoru.data.ability.events.EventEnter;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventPlace;
import open.batoru.data.ability.events.EventRise;
import open.batoru.game.FieldData;
import open.batoru.game.FieldStackZone;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationCardRotate;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionPutOnFieldSIGNI
extends TransientCardGameAction {
    private final GameConst.CardLocation newLocation;
    private final int flagsEnter;
    private DataTable<CardIndex> dataRisePickedCards;
    private List<CardIndex> listRiseRelocatedCards;

    public ActionPutOnFieldSIGNI(CardIndex cardIndex, GameConst.CardLocation newLocation, int flagsEnter) {
        super(cardIndex);
        this.newLocation = newLocation;
        this.flagsEnter = flagsEnter;
    }

    public ActionPutOnFieldSIGNI(CardIndex cardIndex, DataTable<CardIndex> dataRisePickedCards, int flagsEnter) {
        this(cardIndex, dataRisePickedCards, dataRisePickedCards.get() != null ? dataRisePickedCards.get(dataRisePickedCards.size() - 1).getLocation() : null, flagsEnter);
    }

    public ActionPutOnFieldSIGNI(CardIndex cardIndex, DataTable<CardIndex> dataRisePickedCards, GameConst.CardLocation newLocation, int flagsEnter) {
        super(cardIndex);
        this.dataRisePickedCards = dataRisePickedCards;
        this.newLocation = newLocation;
        this.flagsEnter = flagsEnter;
    }

    @Override
    protected void dispatch() {
        CardIndex cardIndex;
        if (this.newLocation == null || !GameConst.CardLocation.isSIGNI(this.newLocation)) {
            if (this.getCardIndex() != null) {
                this.abortAction();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        if (this.getCardIndex() == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        ZoneSIGNI zoneSIGNI = (ZoneSIGNI)FieldData.getZoneByLocation(this.getCardIndex().getIndexedInstance().getCurrentOwner(), this.newLocation);
        if (zoneSIGNI == null || !zoneSIGNI.getNode().isVisible() || this.getCardIndex().getIndexedInstance().getSIGNIClass().getPrimaryValue() == null) {
            this.abortAction();
            return;
        }
        Game.GamePlayerRole rolePlayer = this.getCardIndex().getIndexedInstance().getCurrentOwner();
        UtilCardPlayableControl.PlayableResult resultPlayable = UtilCardPlayableControl.isPlayable(rolePlayer, this.getCardIndex(), this.getSourceAbility(), this.newLocation);
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.NOT_ALLOWED) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_ALLOWED"), Color.RED, 600);
            this.abortAction();
            return;
        }
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.LRIG_TYPE_MISMATCH) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LRIG"), Color.RED, 600);
            this.abortAction();
            return;
        }
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.LRIG_EXCEED_LEVEL) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LEVEL"), Color.RED, 600);
            this.abortAction();
            return;
        }
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.ZONE_NO_AVAILABLE) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_ZONE"), Color.RED, 600);
            this.abortAction();
            return;
        }
        if (resultPlayable == UtilCardPlayableControl.PlayableResult.LRIG_EXCEED_LIMIT) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LIMIT"), Color.RED, 600);
            this.abortAction();
            return;
        }
        if (this.getCardIndex().getIndexedInstance().getUseCondition() != GameConst.UseCondition.RISE || this.getCardIndex().getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
            if (FieldZone.isOccupied(zoneSIGNI) || !RuleCheckCanPlaceSIGNIOnZone.matchesResult((RuleCheckCanPlaceSIGNIOnZone)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PLACE_SIGNI_ON_ZONE), rolePlayer, GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(zoneSIGNI.getZoneLocation()))) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_PLACE"), Color.RED, 600);
                this.abortAction();
                return;
            }
        } else {
            if (!FieldZone.isOccupied(zoneSIGNI) || !RuleCheckCanPlaceSIGNIOnZone.matchesResult((RuleCheckCanPlaceSIGNIOnZone)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PLACE_SIGNI_ON_ZONE), rolePlayer, GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.dataRisePickedCards.get(this.dataRisePickedCards.size() - 1).getLocation()))) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_RISE_ZONE"), Color.RED, 600);
                this.abortAction();
                return;
            }
            if (resultPlayable == UtilCardPlayableControl.PlayableResult.USE_CONDITION_FAIL || this.dataRisePickedCards == null || this.dataRisePickedCards.size() < this.getCardIndex().getIndexedInstance().getUseConditionNumPicks()) {
                OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_RISE"), Color.RED, 600);
                this.abortAction();
                return;
            }
        }
        if (this.dataRisePickedCards != null) {
            this.listRiseRelocatedCards = new ArrayList<CardIndex>();
            zoneSIGNI.setZoneUpdateLock(true);
            for (int i = 0; i < this.dataRisePickedCards.size(); ++i) {
                CardIndex cardIndexPicked = this.dataRisePickedCards.get(i);
                Zone zone = cardIndexPicked.getZoneByLocation();
                EventRise eventRise = new EventRise(cardIndexPicked, this.getCardIndex());
                eventRise.setAtOnce(i, this.dataRisePickedCards.size());
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventRise);
                if (!this.getCardIndex().getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                    for (int ii = zone.getTotalCards() - 1; ii >= 0; --ii) {
                        CardIndex cardIndexUnder = zone.getZoneCardList().get(ii).getCardIndex();
                        GameConst.CardUnderCategory underCategory = cardIndexUnder.getUnderType().getUnderCategory();
                        if (underCategory == GameConst.CardUnderCategory.ZONE) continue;
                        if (underCategory == GameConst.CardUnderCategory.ATTACHED) {
                            cardIndexUnder.getIndexedInstance().getCardStateFlags().addValue(256);
                            continue;
                        }
                        if (zone == zoneSIGNI) continue;
                        this.listRiseRelocatedCards.add(cardIndexUnder);
                    }
                    continue;
                }
                this.listRiseRelocatedCards.add(cardIndexPicked);
            }
        }
        this.addCardIndexData();
        EventMove eventMove = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.newLocation);
        eventMove.setAtOnce(this);
        this.setLogEvent(new LogEventMove(eventMove, AbilityConst.ActionHint.FIELD));
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventMove);
        AnimationTracker tracker = new AnimationTracker(1 + (this.dataRisePickedCards == null ? 0 : this.listRiseRelocatedCards.size()));
        tracker.setOnTrackerAllFinished(() -> {
            if (this.getNumAtOnce() > 1) {
                if (!this.isLastAtOnce()) {
                    this.getCardIndex().getIndexedInstance().getCardStateFlags().addValue(1024);
                } else {
                    GameAction prevAction = this;
                    while ((prevAction = prevAction.getPrevAtOnceAction()) != null) {
                        if (!prevAction.isSuccessful() || !((CardIndex)prevAction.getDataTable().get()).getIndexedInstance().isState(1024)) continue;
                        ((CardIndex)prevAction.getDataTable().get()).getIndexedInstance().getCardStateFlags().removeValue(1024);
                    }
                }
            }
            if (this.dataRisePickedCards != null) {
                zoneSIGNI.setZoneUpdateLock(false);
                for (int i = 0; i < this.dataRisePickedCards.size(); ++i) {
                    CardIndex cardIndexPicked = this.dataRisePickedCards.get(i);
                    cardIndexPicked.setUnderType(GameConst.CardUnderType.UNDER_RISE);
                    ((FieldStackZone)this.getCardIndex().getZoneByLocation()).getZoneUnderCardsIndicators().addUnderType(GameConst.CardUnderType.UNDER_RISE);
                }
            }
            if ((this.flagsEnter & 2) != 0) {
                this.getCardIndex().getIndexedInstance().getCardStateFlags().addValue(16384);
            }
            if ((this.flagsEnter & 1) != 0) {
                for (Ability ability : this.getCardIndex().getIndexedInstance().getAbilityList()) {
                    if (!(ability instanceof EnterAbility)) continue;
                    ability.transientMute();
                }
            } else if ((this.flagsEnter & 4) != 0) {
                for (Ability ability : this.getCardIndex().getIndexedInstance().getAbilityList()) {
                    ability.transientDisable();
                }
                this.getCardIndex().getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.DISABLED));
            }
            if ((this.flagsEnter & 8) != 0) {
                Game.getCurrentGame().getGameLog().exportTurnRecords().stream().filter(EventAttack.class::isInstance).map(EventAttack.class::cast).findFirst().ifPresent(e -> e.setActiveAttacker(this.getCardIndex()));
            }
            EventEnter eventEnter = new EventEnter(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility());
            eventEnter.setAtOnce(this);
            EventPlace eventPlace = new EventPlace(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility());
            eventPlace.setAtOnce(this);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventEnter, eventPlace);
            List<AbilityCostList> listCostToPlaceSIGNIOnZone = ((AbilityCost)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_PLACE_SIGNI_ON_ZONE).check(new PlayerRuleCheckData(rolePlayer, this.getSourceCardIndex(), this.getSourceAbility(), new Object[]{this.getCardIndex(), GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.getCardIndex().getLocation())}))).getSourceCostList().getSourceDataCostLists();
            Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
                if (listCostToPlaceSIGNIOnZone.isEmpty()) {
                    if (this.isLastAtOnce()) {
                        Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
                        Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
                    }
                } else {
                    ((AbilityCostList)listCostToPlaceSIGNIOnZone.getFirst()).setSourceCardIndex(this.getCardIndex());
                    if (this.isLastAtOnce()) {
                        ((AbilityCostList)listCostToPlaceSIGNIOnZone.getFirst()).setOnCostHandledAll(() -> {
                            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
                            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
                            if (Game.getCurrentGame().getFakeReceiver() != null) {
                                Game.getCurrentGame().getFakeReceiver().processIdle(Game.getCurrentGame().getActionQueue().getLastProcessedOrder() + 1);
                            }
                        });
                    }
                    ActionPayCost actionPayCost = new ActionPayCost((AbilityCostList)listCostToPlaceSIGNIOnZone.getFirst());
                    Game.getCurrentGame().getActionQueue().addAction(actionPayCost);
                }
            });
            this.setAsCompleted();
        });
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, this.dataRisePickedCards == null ? 1 : 2);
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), zoneSIGNI);
        aniMove.setAnimationTracker(tracker);
        if ((this.flagsEnter & 2) != 0) {
            aniMove.setDownedRotationOffset();
        }
        if (this.listRiseRelocatedCards != null) {
            for (int i = this.listRiseRelocatedCards.size() - 1; i >= 0; --i) {
                CardIndex cardIndexPicked = this.listRiseRelocatedCards.get(i);
                AnimationCardMove aniMoveUnder = new AnimationCardMove(cardIndexPicked.getSourceCard3D(), (Zone)zoneSIGNI, Zone.ZonePosition.BOTTOM);
                aniMoveUnder.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniMoveUnder);
            }
        }
        if (this.dataRisePickedCards != null && (cardIndex = this.dataRisePickedCards.get(this.dataRisePickedCards.size() - 1)).getIndexedInstance().isState(16384)) {
            AnimationCardRotate aniUp = new AnimationCardRotate(cardIndex.getSourceCard3D(), true);
            aniUp.setAnimationTracker(tracker);
            tracker.setMaxCount(tracker.getMaxCount() + 1);
            seqAni.getAnimationList(1).add(aniUp);
        }
        seqAni.getAnimationList(0).add(aniMove);
        seqAni.play();
    }

    private void abortAction() {
        if (this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED || this.getCardIndex().getOldLocation() != GameConst.CardLocation.LOOKED) {
            this.setAsCompleted();
        } else {
            AnimationTracker tracker = new AnimationTracker(1);
            tracker.setOnTrackerAllFinished(() -> {
                if (Game.getCurrentGame().isNeutralPerspectiveGame()) {
                    this.getCardIndex().clearImageSet();
                    this.getCardIndex().getSourceCard3D().updateImageSet();
                    this.getCardIndex().getSourceCard3D().showAsPrivate(true);
                }
                this.setAsCompleted();
            });
            AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getIndexedInstance().getCurrentOwner()).getLookZone());
            aniMove.setAnimationTracker(tracker);
            aniMove.play();
        }
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
    }
}

