/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.Optional;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.SpellAbility;
import open.batoru.data.ability.events.EventUseSpell;
import open.batoru.data.ability.modifiers.CostModifier;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.networking.PacketParser;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionPutOnFieldSpell
extends GameAction<CardIndex> {
    private CardIndex cardIndex;
    private Game.GamePlayerRole rolePlayerUser;
    private CostModifier costModifier;

    public ActionPutOnFieldSpell(CardIndex cardIndex) {
        this(cardIndex, cardIndex.getCurrentOwnerSafe(), null);
    }

    public ActionPutOnFieldSpell(CardIndex cardIndex, Game.GamePlayerRole rolePlayerUser) {
        this(cardIndex, rolePlayerUser, null);
    }

    public ActionPutOnFieldSpell(CardIndex cardIndex, Game.GamePlayerRole rolePlayerUser, CostModifier costModifier) {
        this.cardIndex = cardIndex;
        this.rolePlayerUser = rolePlayerUser;
        this.costModifier = costModifier;
    }

    public ActionPutOnFieldSpell(PacketParser pp) {
        this.setReceivedPacketData(pp);
    }

    @Override
    protected void dispatch() {
        boolean isStolen;
        if (!(this.isDataReceived() || this.cardIndex != null && this.cardIndex.getIndexedInstance() != null)) {
            this.requestData();
            return;
        }
        if (this.cardIndex.getCardReference().getType() != CardConst.CardType.SPELL) {
            this.setAsCompleted();
            return;
        }
        Optional<SpellAbility> abilitySpell = SpellAbility.findSpellAbility(this.cardIndex);
        if (abilitySpell.isEmpty()) {
            this.setAsCompleted();
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayerUser);
        CardIndex cardIndexLRIG = field.getLRIGZone().getTopCard().getCardIndex();
        if (this.cardIndex.getIndexedInstance().getLRIGType().getPrimaryValue() != CardConst.CardLRIGType.NO_LRIG_LIMIT && !this.cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexLRIG.getIndexedInstance().getLRIGType())) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LRIG"), Color.RED, 600);
            this.setAsCompleted();
            return;
        }
        if (abilitySpell.get().getConditionState(this.cardIndex) == AbilityCondition.ConditionState.BAD || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayerUser).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_SPELL).check(this.rolePlayerUser, this.cardIndex, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SPELL_USE"), Color.RED, 600);
            this.setAsCompleted();
            return;
        }
        if (this.costModifier != null) {
            this.costModifier.modify(this.cardIndex.getIndexedInstance().getCost(), this.cardIndex, null);
        }
        boolean bl = isStolen = this.rolePlayerUser != CardIndex.getOriginalOwner(this.cardIndex.getId());
        if (isStolen) {
            this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(512);
            abilitySpell.get().getCostLists().forEach(costList -> costList.setPayerRole(this.rolePlayerUser));
        }
        if (this.costModifier != null || isStolen) {
            abilitySpell.get().setOnAbilityEnd(wasResolved -> {
                if (this.costModifier != null) {
                    this.costModifier.restore(this.cardIndex.getIndexedInstance().getCost());
                }
                if (isStolen) {
                    ((SpellAbility)abilitySpell.get()).getCostLists().forEach(costList -> costList.setPayerRole(CardIndex.getOriginalOwner(this.cardIndex.getId())));
                }
            });
        }
        Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        if (!abilitySpell.get().canPayCost()) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SPELL_COST"), Color.RED, 600);
            if (isStolen) {
                this.cardIndex.getIndexedInstance().getCardStateFlags().removeValue(512);
            }
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndex);
        if (this.cardIndex.getLocation() != GameConst.CardLocation.CHECK_ZONE) {
            AnimationTracker tracker = new AnimationTracker(1);
            tracker.setOnTrackerAllFinished(this::dispatchUseSpell);
            AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), field.getCheckZone());
            if (isStolen) {
                aniMove.setRotationOffset(new Vector3D(0.0, 0.0, 180.0));
            }
            aniMove.setAnimationTracker(tracker);
            aniMove.play();
        } else {
            this.dispatchUseSpell();
        }
    }

    private void dispatchUseSpell() {
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventUseSpell(this.cardIndex, this.getSourceAbility()));
        if (this.isLastAtOnce()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        }
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> {
            this.cardIndex = card3D.getCardIndex();
        });
        if (this.rolePlayerUser == null && this.cardIndex != null) {
            this.rolePlayerUser = pp.getDataArgsNum() == 2 ? this.cardIndex.getCurrentOwnerSafe() : Game.GamePlayerRole.getRoleById(Integer.parseInt(pp.getDataArgument(2)));
        }
    }
}

