/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.Optional;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.game._3d.Card3D;
import open.batoru.networking.PacketParser;

public class ActionRetire
extends GameAction<CardIndex> {
    private CardIndex[] listCardIndexes;
    private ActionTrash prevAction;

    public ActionRetire(CardIndex[] listCardIndexes) {
        this.listCardIndexes = listCardIndexes;
    }

    public ActionRetire(PacketParser pp) {
        this.setReceivedPacketData(pp);
    }

    @Override
    protected void dispatch() {
        Game.getCurrentGame().getGameRules().setRetireAsUsed();
        if (this.listCardIndexes == null || this.listCardIndexes.length == 0) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        this.addTrashAction(0);
        this.treatAsMidEffAction();
        this.setAsCompleted();
    }

    private void addTrashAction(int arrayId) {
        ActionTrash action = new ActionTrash(this.listCardIndexes[arrayId]);
        action.setAtOnce(this.prevAction, arrayId, this.listCardIndexes.length);
        this.prevAction = action;
        if (arrayId < this.listCardIndexes.length - 1) {
            action.treatAsMidEffAction();
            GameAction.GameActionHandler handlerAddNext = () -> this.addTrashAction(arrayId + 1);
            action.setOnActionCompleted(handlerAddNext);
            action.setOnActionOverridden(handlerAddNext);
        }
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        Optional<Card3D> card3D;
        this.listCardIndexes = new CardIndex[pp.getDataArgsNum() - 1];
        for (int i = 1; i < pp.getDataArgsNum() && !(card3D = CardIndex.getCardFromPacketData(pp.getDataArgument(i))).isEmpty(); ++i) {
            this.listCardIndexes[i - 1] = card3D.get().getCardIndex();
        }
    }
}

