/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.events.EventReveal;
import open.batoru.game.Zone;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationWait;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionReveal
extends GameAction<CardIndex> {
    private CardIndex cardIndex;
    private Zone.ZonePosition zonePosition = Zone.ZonePosition.TOP;
    private final boolean isSilent;

    public ActionReveal(CardIndex cardIndex, boolean isSilent) {
        this.cardIndex = cardIndex;
        this.isSilent = isSilent;
    }

    public ActionReveal(Zone.ZonePosition zonePosition, boolean isSilent) {
        this.zonePosition = zonePosition;
        this.isSilent = isSilent;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.getDataTable().add(null);
                this.setAsCompleted();
            }
            return;
        }
        this.getDataTable().add(this.cardIndex);
        if (this.cardIndex.getLocation() == GameConst.CardLocation.LIFE_CLOTH) {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.cardIndex.getCurrentOwnerSafe()).moveNext(this.cardIndex.getImageSet(), false, this.getLogEvent());
        }
        EventReveal eventReveal = new EventReveal(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility());
        eventReveal.setAtOnce(this);
        this.setLogEvent(new LogEventMove(eventReveal, GameConst.CardLocation.REVEALED, TargetFilter.TargetHint.REVEAL));
        if (!this.isSilent) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(eventReveal);
        }
        AnimationTracker tracker = new AnimationTracker(this.isLastAtOnce() ? 2 : 1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe()).getRevealZone());
        aniMove.setAnimationTracker(tracker);
        if (this.isLastAtOnce()) {
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
            seqAni.getAnimationList().add(aniMove);
            AnimationWait aniWait = new AnimationWait(300);
            aniWait.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniWait);
            seqAni.play();
        } else {
            aniMove.play();
        }
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (this.cardIndex != null) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.cardIndex.getSourceCard3D());
        } else {
            CardIndex.getCardFromPacketData(pp.getDataArgument(1), this.zonePosition).ifPresent(card3D -> {
                this.cardIndex = card3D.getCardIndex();
            });
        }
    }
}

