/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.events.EventDrive;
import open.batoru.game.animations.AnimationZoneTracer;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class ActionRide
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;

    public ActionRide(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null) {
            this.setAsCompleted();
            return;
        }
        CardIndex cardIndexLRIG = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe()).getLRIGZone().getTopCard().getCardIndex();
        this.getDataTable().add(this.cardIndex);
        if (!this.cardIndex.getIndexedInstance().isState(0x200000)) {
            this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(0x200000);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventDrive(this.cardIndex));
            if (this.isLastAtOnce()) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            }
            AnimationZoneTracer aniTracer = new AnimationZoneTracer(cardIndexLRIG.getZoneByLocation(), this.cardIndex.getZoneByLocation(), Color.RED, "tracer_ride");
            aniTracer.play();
            ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(this.cardIndex, ChronoDuration.turnEnd());
            record.setAlias("ride");
            record.setAsProtected(true);
            record.setOnChronoRecordExpired(() -> {
                FX.run(aniTracer::stop);
                this.cardIndex.getIndexedInstance().getCardStateFlags().removeValue(0x200000);
                if (new TargetFilter(TargetFilter.TargetHint.GENERIC, this.cardIndex.getCurrentOwnerSafe()).own().SIGNI().drive().getValidTargetsCount(true) == 0) {
                    CardIndex cardIndexCurrentLRIG = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getCurrentOwnerSafe()).getLRIGZone().getTopCard().getCardIndex();
                    cardIndexCurrentLRIG.getIndexedInstance().getCardStateFlags().removeValue(0x200000);
                }
            });
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
        if (!cardIndexLRIG.getIndexedInstance().isState(0x200000)) {
            cardIndexLRIG.getIndexedInstance().getCardStateFlags().addValue(0x200000);
        }
        this.setAsCompleted();
    }
}

