/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ModifiableDouble;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.events.EventPowerChanged;

public class ActionSetBasePower
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private final double newValue;
    private final ChronoDuration chronoDuration;

    public ActionSetBasePower(CardIndex cardIndex, double newValue, ChronoDuration chronoDuration) {
        this.cardIndex = cardIndex;
        this.newValue = newValue;
        this.chronoDuration = chronoDuration;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null || !GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation()) || this.getSourceAbility() != null && (this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_POWER_BE_CHANGED).check(this.cardIndex, this, this.newValue) == RuleCheck.RuleCheckState.BLOCK)) {
            this.setAsCompleted();
            return;
        }
        ModifiableDouble power = this.cardIndex.getIndexedInstance().getPower();
        power.setSourceAbility(this.getSourceAbility());
        ModifiableVariable.ModifiableValueReference<Double> valueReference = power.setBaseValue(this.newValue);
        EventPowerChanged event = new EventPowerChanged(this.cardIndex, this.getSourceAbility(), this.getSourceCost(), power.getValue(), 0.0);
        event.setAtOnce(this);
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(event);
        if (this.chronoDuration != ChronoDuration.permanent()) {
            ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(this.cardIndex, this.chronoDuration);
            record.setOnChronoRecordExpired(() -> power.removeBaseValue(valueReference));
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
        this.setAsCompleted();
    }
}

