/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ModifiableVariable;
import open.batoru.ui.UI;

public class ActionSetBaseValue<T, V, M extends ModifiableVariable<T, V, M>>
extends GameAction<T> {
    private final CardIndex cardIndex;
    private final ModifiableVariable<T, V, M> mod;
    private final V newValue;
    private final ChronoRecordScheduler.ChronoRecord record;

    public ActionSetBaseValue(CardIndex cardIndex, ModifiableVariable<T, V, M> mod, V newValue, ChronoRecordScheduler.ChronoRecord record) {
        this.cardIndex = cardIndex;
        this.mod = mod;
        this.newValue = newValue;
        this.record = record;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null || this.getSourceAbility() != null && this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.setAsCompleted();
            return;
        }
        this.mod.setSourceAbility(this.getSourceAbility());
        ModifiableVariable.ModifiableValueReference<V> valueReference = this.mod.setBaseValue(this.newValue);
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndex);
        this.record.setOnChronoRecordExpired(() -> this.mod.removeBaseValue(valueReference));
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(this.record);
        this.setAsCompleted();
    }
}

