/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventDiscard;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventTrash;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationFlashKey;
import open.batoru.game.animations.AnimationMagicBox;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionTrash
extends TransientCardGameAction {
    public ActionTrash(CardIndex cardIndex) {
        super(cardIndex);
    }

    public ActionTrash() {
    }

    @Override
    protected void dispatch() {
        boolean isMainDeckCard;
        block17: {
            block16: {
                if (this.getCardIndex() == null || this.getCardIndex().getIndexedInstance() == null) {
                    if (!this.isDataReceived()) {
                        this.requestData();
                    } else {
                        this.getDataTable().add(null);
                        this.setAsCompleted();
                    }
                    return;
                }
                isMainDeckCard = Card3D.isMainDeckCard(this.getCardIndex().getSourceCard3D());
                if (this.getCardIndex().getLocation() == GameConst.CardLocation.TRASH || this.getCardIndex().getLocation() == GameConst.CardLocation.TRASH_LRIG) break block16;
                if (this.getSourceAbility() == null) break block17;
                if (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) break block16;
                Object[] objectArray = new Object[1];
                Object object = objectArray[0] = isMainDeckCard ? GameConst.CardLocation.TRASH : GameConst.CardLocation.TRASH_LRIG;
                if (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, objectArray) != RuleCheck.RuleCheckState.BLOCK) break block17;
            }
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        boolean isPseudoDiscard = this.getCardIndex().getLocation() == GameConst.CardLocation.HAND;
        EventMove eventMove = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), isMainDeckCard ? GameConst.CardLocation.TRASH : GameConst.CardLocation.TRASH_LRIG);
        this.setLogEvent(new LogEventMove(eventMove, !isPseudoDiscard ? AbilityConst.ActionHint.TRASH : AbilityConst.ActionHint.DISCARD), this.getSourceCardIndex() == null);
        if (!this.getCardIndex().getIndexedInstance().isState(256)) {
            GameEvent[] listEvents = new GameEvent[!isPseudoDiscard ? 2 : 3];
            listEvents[0] = new EventTrash(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
            listEvents[1] = eventMove;
            if (isPseudoDiscard) {
                listEvents[2] = new EventDiscard(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
            }
            for (GameEvent event : listEvents) {
                event.setAtOnce(this);
            }
            if (!isPseudoDiscard && (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), listEvents) || ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this))) {
                return;
            }
            if (this.getCardIndex().getLocation() == GameConst.CardLocation.LIFE_CLOTH) {
                UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.getCardIndex().getCurrentOwnerSafe()).moveNext(this.getCardIndex().getImageSet(), false, this.getLogEvent());
            }
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents);
            if (this.isLastAtOnce()) {
                this.setOnActionCompleted(() -> Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects()));
            }
        }
        this.addCardIndexData();
        AnimationTracker tracker = new AnimationTracker(this.getCardIndex().getLocation() != GameConst.CardLocation.LRIG && this.getCardIndex().getLocation() != GameConst.CardLocation.HAND || !isMainDeckCard ? 1 : 2);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        if (tracker.getMaxCount() > 1) {
            AnimationCardMove aniReveal = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe()).getRevealZone());
            aniReveal.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniReveal);
        }
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(CardIndex.getOriginalOwner(this.getCardIndex().getId())).getTrashZone(isMainDeckCard ? Deck.DeckType.MAIN : Deck.DeckType.LRIG));
        if (this.getCardIndex().getUnderType() == GameConst.CardUnderType.ZONE_MAGIC_BOX && this.getSourceCardIndex() != null && this.getCardIndex().getCurrentOwnerSafe() == this.getSourceCardIndex().getCurrentOwnerSafe()) {
            aniMove.setOnAnimationStarted(() -> AnimationMagicBox.playAnimations(this.getCardIndex(), this.getCardIndex().getZoneByLocation(), false));
        }
        if (tracker.getMaxCount() > 1 || this.getSourceAbility() != null && ((this.getCardIndex().getOldLocation() == GameConst.CardLocation.TRASH || this.getCardIndex().getOldLocation() == GameConst.CardLocation.TRASH_LRIG) && this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED || this.getCardIndex().getLocation() == GameConst.CardLocation.CHECK_ZONE && this.getCardIndex().getOldLocation() == GameConst.CardLocation.DECK_MAIN)) {
            aniMove.setDelay(300.0);
        }
        aniMove.setAnimationTracker(tracker);
        seqAni.getAnimationList().add(aniMove);
        if (this.getCardIndex().getCardReference().getType() == CardConst.CardType.KEY) {
            AnimationFlashKey aniFlash = new AnimationFlashKey(this.getCardIndex(), false);
            aniFlash.play();
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (this.getCardIndex() != null) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.getCardIndex().getSourceCard3D());
        } else {
            CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
        }
    }
}

