/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionPutOnFieldARTS;
import open.batoru.core.gameplay.actions.ActionPutOnFieldKeyPre;
import open.batoru.core.gameplay.actions.ActionPutOnFieldPiece;
import open.batoru.core.gameplay.actions.ActionPutOnFieldResona;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSpell;
import open.batoru.networking.PacketParser;

public class ActionUseCardFromLRIGDeck
extends GameAction<CardIndex> {
    private CardIndex cardIndex;

    public ActionUseCardFromLRIGDeck(PacketParser pp) {
        this.setReceivedPacketData(pp);
    }

    @Override
    protected void dispatch() {
        GameAction action;
        if (this.cardIndex == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        switch (this.cardIndex.getCardReference().getType()) {
            case SPELL: {
                GameAction gameAction = new ActionPutOnFieldSpell(this.cardIndex);
                break;
            }
            case ARTS: {
                GameAction gameAction = new ActionPutOnFieldARTS(this.cardIndex);
                break;
            }
            case KEY: {
                GameAction gameAction = new ActionPutOnFieldKeyPre(this.cardIndex);
                break;
            }
            case PIECE: {
                GameAction gameAction = new ActionPutOnFieldPiece(this.cardIndex);
                break;
            }
            case RESONA: {
                GameAction gameAction = new ActionPutOnFieldResona(this.cardIndex);
                break;
            }
            default: {
                GameAction gameAction = action = null;
            }
        }
        if (action != null) {
            action.dispatchAsChild(this);
        } else {
            this.setAsCompleted();
        }
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> {
            this.cardIndex = card3D.getCardIndex();
        });
    }
}

