/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldStackZone;

public class ActionZoneRemoveObject
extends GameAction<Boolean> {
    private final FieldStackZone fieldZone;
    private final GameConst.CardUnderType underType;

    public ActionZoneRemoveObject(FieldStackZone fieldZone, GameConst.CardUnderType underType) {
        this.fieldZone = fieldZone;
        this.underType = underType;
    }

    @Override
    public void dispatch() {
        if (!this.fieldZone.getZoneUnderCardsIndicators().hasUnderType(this.underType)) {
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(true);
        if (this.getSourceCost() != null) {
            this.getSourceCost().addPaidData(new AbilityCost.EmptyPayable());
        }
        this.fieldZone.getZoneUnderCardsIndicators().removeUnderType(this.underType);
        this.setAsCompleted();
    }
}

