/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions.override;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionDiscard;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.core.gameplay.actions.ActionManualChoice;
import open.batoru.core.gameplay.actions.ActionManualDiscard;
import open.batoru.core.gameplay.actions.ActionManualEnerPay;
import open.batoru.core.gameplay.actions.ActionManualSearchDeck;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.FieldData;
import open.batoru.game.GameField;
import open.batoru.game.Zone;
import open.batoru.game.animations.AnimationBorderIcon;

public class OverrideActionList {
    private final OverrideResult sourceOverrideResult;
    private final int overrideFlags;
    private final Ability sourceAbilityRC;
    private final List<GameAction<?>> listActions = new ArrayList();

    public OverrideActionList(OverrideResult sourceOverrideResult, Ability sourceAbilityRC, int overrideFlags) {
        this.sourceOverrideResult = sourceOverrideResult;
        this.sourceAbilityRC = sourceAbilityRC;
        this.overrideFlags = overrideFlags;
    }

    public GameEvent getSourceEvent() {
        return this.sourceOverrideResult.getCurrentOverrideAction().getSourceEvent();
    }

    public void addAction(GameAction<?> action) {
        action.setSourceOverrideResult(this.sourceOverrideResult);
        action.setAsNonOverridableAction();
        this.listActions.add(action);
    }

    public GameAction<?> getAction(int arrayId) {
        return this.getAction(arrayId, (this.overrideFlags & 1) != 0 ? 1 : 0);
    }

    public GameAction<?> getAction(int arrayId, int offset) {
        return arrayId + offset >= offset && arrayId + offset < this.listActions.size() ? this.listActions.get(arrayId + offset) : null;
    }

    public int getTotalAddedActions() {
        return this.getTotalActions() - ((this.overrideFlags & 1) != 0 ? 1 : 0);
    }

    public int getTotalActions() {
        return this.listActions.size();
    }

    public int getOverrideFlags() {
        return this.overrideFlags;
    }

    public boolean shouldPreserveSources() {
        return (this.overrideFlags & 4) != 0;
    }

    public final void addNonMandatoryAction(GameAction<?> action) {
        action.treatAsNonMandatoryAction();
        this.addAction(action);
    }

    public final GameAction<CardIndex> addTargetAction(TargetFilter filter) {
        return this.addTargetAction(this.sourceAbilityRC.getAbilityOwner(), filter);
    }

    public final GameAction<CardIndex> addTargetAction(Game.GamePlayerRole rolePlayer, TargetFilter filter) {
        return this.addTargetAction(rolePlayer, 1, 1, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final GameAction<CardIndex> addTargetAction(int minPicks, TargetFilter filter) {
        return this.addTargetAction(this.sourceAbilityRC.getAbilityOwner(), minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final GameAction<CardIndex> addTargetAction(int minPicks, int maxPicks, TargetFilter filter) {
        return this.addTargetAction(this.sourceAbilityRC.getAbilityOwner(), minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT, filter, null);
    }

    public final GameAction<CardIndex> addTargetAction(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        GameAction action;
        filter.setSourceAbility(this.sourceAbilityRC);
        filter.setTargetRole(rolePlayer);
        GameField.highlightPlayerField(rolePlayer);
        if (PlayerControl.isChoosingPlayer(rolePlayer)) {
            if (!(filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH) || filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH_LRIG) || filter.getHintLocationsData().contains((Object)GameConst.CardLocation.DECK_LRIG))) {
                action = new ActionManualTargetCard(minPicks, maxPicks, filter, null, AbilityConst.ChoiceLogic.DEFAULT);
            } else {
                GameConst.CardLocation location;
                if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                    location = GameConst.CardLocation.TRASH;
                } else if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH_LRIG)) {
                    location = GameConst.CardLocation.TRASH_LRIG;
                } else if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.DECK_LRIG)) {
                    location = GameConst.CardLocation.DECK_LRIG;
                } else {
                    throw new IllegalArgumentException();
                }
                action = new ActionManualSearchDeck(minPicks, maxPicks, filter, null, rolePlayer, location);
            }
        } else {
            action = new ActionPlayerChoiceCard(filter);
        }
        action.setOnActionCompleted(() -> GameField.highlightPlayerField(null));
        action.treatAsMidEffAction();
        this.addAction(action);
        return action;
    }

    public final GameAction<CardIndex> addDiscardAction(int minPicks) {
        return this.addDiscardAction(this.sourceAbilityRC.getAbilityOwner(), minPicks, minPicks, AbilityConst.ChoiceLogic.DEFAULT, null, null);
    }

    public final GameAction<CardIndex> addDiscardAction(Game.GamePlayerRole rolePlayer, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        if (filter != null) {
            filter.setSourceAbility(this.sourceAbilityRC);
            filter = filter.fromHand();
            filter.setTargetHint(TargetFilter.TargetHint.DISCARD);
        }
        GameField.highlightPlayerField(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualDiscard(minPicks, maxPicks, choiceLogic, filter, condition) : new ActionDiscard();
        action.setOnActionCompleted(() -> GameField.highlightPlayerField(null));
        action.treatAsMidEffAction();
        this.addAction(action);
        return action;
    }

    public final GameAction<ActionEnerPay.PaidEnerData> addEnerPayAction(String costString) {
        return this.addEnerPayAction(this.sourceAbilityRC.getAbilityOwner(), costString);
    }

    public final GameAction<ActionEnerPay.PaidEnerData> addEnerPayAction(Game.GamePlayerRole rolePlayer, String costString) {
        GameField.highlightPlayerField(rolePlayer);
        EnerCost cost = new EnerCost(costString);
        cost.treatAsEffect();
        cost.setSourceAbility(this.sourceAbilityRC);
        cost.setPayerRole(rolePlayer);
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualEnerPay(rolePlayer == this.sourceAbilityRC.getAbilityOwner()) : new ActionEnerPay();
        action.setSourceAbility(this.sourceAbilityRC);
        action.setSourceCost(cost);
        action.setOnActionCompleted(() -> GameField.highlightPlayerField(null));
        action.treatAsMidEffAction();
        this.addAction(action);
        return action;
    }

    void addNonMandatoryChoiceAction() {
        Game.GamePlayerRole rolePlayer = this.sourceAbilityRC.getAbilityOwner();
        ArrayList listAniBorder = new ArrayList();
        GameAction action = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualChoice(this.sourceAbilityRC) : new ActionPlayerChoiceInteger();
        action.setOnActionDispatched(() -> {
            Zone zone;
            GameField.highlightPlayerField(rolePlayer);
            if (PlayerControl.isChoosingPlayer(rolePlayer) && this.sourceOverrideResult.getCurrentOverrideAction().getOverrideScope() == OverrideAction.OverrideScope.CALLER && this.getSourceEvent().getCallerCardIndex() != this.sourceAbilityRC.getSourceCardIndex()) {
                AnimationBorderIcon aniBorder = new AnimationBorderIcon(this.getSourceEvent().getCallerCardIndex().getSourceCard3D().getOwnerZone(), TargetFilter.TargetHint.GUARD);
                aniBorder.colorize(Color.LIMEGREEN);
                aniBorder.play();
                listAniBorder.add(aniBorder);
            }
            if ((zone = this.sourceAbilityRC.getSourceCardIndex().getZoneByLocation()) == null) {
                zone = FieldData.getZoneByLocation(this.sourceAbilityRC.getAbilityOwner(), GameConst.CardLocation.LIFE_CLOTH);
            }
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(zone, TargetFilter.TargetHint.ACTIVATE);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        });
        action.setOnActionCompleted(() -> {
            GameField.highlightPlayerField(null);
            AnimationBorderIcon.stopAll(listAniBorder);
            listAniBorder.clear();
            if ((Integer)action.getDataTable().get() != 1) {
                action.getDataTable().clear();
            }
        });
        action.treatAsMidEffAction();
        this.addAction(action);
    }

    public static class OverrideFlag {
        public static final int MANDATORY = 0;
        public static final int NON_MANDATORY = 1;
        public static final int DONT_BLOCK = 2;
        public static final int PRESERVE_SOURCES = 4;
        public static final int PRE_OVERRIDE = 8;
    }
}

