/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions.override;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEmpty;
import open.batoru.core.gameplay.actions.ActionManualChoiceAbility;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideActionList;
import open.batoru.core.gameplay.callback.CallbackGameAction;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.FieldData;
import open.batoru.game.GameField;
import open.batoru.game.Zone;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.ui.UI;

public class OverrideResult {
    private final List<OverrideAction> overrideActions = new ArrayList<OverrideAction>();
    private OverrideAction currentOverrideAction;
    private OverrideResult previousBlockedOverrideResult;
    public GameAction<?> blockedOverrideFallbackAction;
    private final Game.GamePlayerRole roleOwner;
    private final GameAction<?> sourceAction;

    public OverrideResult(Game.GamePlayerRole roleOwner, GameAction<?> sourceAction) {
        this.roleOwner = roleOwner;
        this.sourceAction = sourceAction;
    }

    public void addOverrideAction(OverrideAction action, GameEvent sourceEvent) {
        action.setSourceEvent(sourceEvent);
        this.overrideActions.add(action);
    }

    public List<OverrideAction> getOverrideActions() {
        return Collections.unmodifiableList(this.overrideActions);
    }

    @Deprecated
    public void setCurrentOverrideAction(OverrideAction overrideAction) {
        this.currentOverrideAction = overrideAction;
    }

    public OverrideAction getCurrentOverrideAction() {
        return this.currentOverrideAction;
    }

    public GameAction<?> getSourceOriginalAction() {
        return this.sourceAction;
    }

    private GameAction<Integer> prepareOverrideActionChoice() {
        ArrayList listAniBorder;
        HashSet sourceLocations;
        boolean allowSkip = false;
        if (this.overrideActions.size() > 1) {
            if (this.overrideActions.stream().anyMatch(action -> (action.getOverrideFlags() & 1) == 0)) {
                this.overrideActions.forEach(action -> action.setOverrideFlags(action.getOverrideFlags() & 0xFFFFFFFE));
            } else {
                allowSkip = true;
            }
            sourceLocations = new HashSet();
            listAniBorder = new ArrayList();
            this.overrideActions.forEach(action -> sourceLocations.add(action.getSourceAbilityRC().getSourceCardIndex().getLocation()));
        } else {
            sourceLocations = null;
            listAniBorder = null;
        }
        GameAction action2 = PlayerControl.isChoosingPlayer(this.roleOwner) ? new ActionManualChoiceAbility(this.overrideActions.stream().map(OverrideAction::getSourceAbilityRC).toList(), allowSkip) : new ActionPlayerChoiceInteger();
        action2.setOnActionDispatched(() -> {
            GameField.highlightPlayerField(this.roleOwner);
            if (sourceLocations != null) {
                for (GameConst.CardLocation location : sourceLocations) {
                    Zone zone = FieldData.getZoneByLocation(this.roleOwner, location);
                    if (zone == null) continue;
                    AnimationBorderIcon aniBorder = new AnimationBorderIcon(zone, TargetFilter.TargetHint.ACTIVATE);
                    aniBorder.play();
                    listAniBorder.add(aniBorder);
                }
            }
        });
        action2.setOnActionCompleted(() -> {
            GameField.highlightPlayerField(null);
            if (listAniBorder != null) {
                AnimationBorderIcon.stopAll(listAniBorder);
            }
        });
        action2.treatAsMidEffAction();
        return action2;
    }

    @Deprecated
    private OverrideAction switchToFallbackAction() {
        if (this.overrideActions.size() <= 1) {
            return null;
        }
        this.currentOverrideAction = this.overrideActions.get((this.overrideActions.indexOf(this.currentOverrideAction) + 1) % this.overrideActions.size());
        return this.currentOverrideAction;
    }

    public boolean isEmpty() {
        return this.overrideActions.isEmpty();
    }

    public boolean execThreadedActionOverride(CallbackGameAction callbackAction) {
        if (this.overrideActions.size() == 1) {
            this.currentOverrideAction = this.overrideActions.getFirst();
        } else {
            GameAction<Integer> actionChoice = this.prepareOverrideActionChoice();
            actionChoice.setCallbackAction(callbackAction);
            Game.getCurrentGame().getActionQueue().addAction(actionChoice);
            int arrayId = actionChoice.getDataTable().get();
            if (arrayId != -1) {
                this.currentOverrideAction = this.overrideActions.get(arrayId);
            } else {
                if (this.overrideActions.getFirst().getActionEvent() != GameConst.GameEventId.ABILITY) {
                    this.sourceAction.reset();
                    Game.getCurrentGame().getActionQueue().addAction(this.sourceAction);
                }
                return false;
            }
        }
        OverrideActionList list = this.currentOverrideAction.prepareOverrideActionList(this);
        OverrideExecResult execResult = this.execThreadedOverrideActionList(list, callbackAction);
        if (execResult != OverrideExecResult.SUCCESS) {
            if (execResult == OverrideExecResult.DONT_BLOCK) {
                if (this.currentOverrideAction.getActionEvent() != GameConst.GameEventId.ABILITY) {
                    this.sourceAction.reset();
                    Game.getCurrentGame().getActionQueue().addAction(this.sourceAction);
                }
            } else {
                if (execResult == OverrideExecResult.INTERRUPTED_BLOCKED) {
                    for (int i = 0; i < 2; ++i) {
                        ActionEmpty filler = new ActionEmpty();
                        filler.setCallbackAction(callbackAction);
                        Game.getCurrentGame().getActionQueue().addAction(filler);
                    }
                    GameAction<?> action = this.previousBlockedOverrideResult.blockedOverrideFallbackAction;
                    action.setAsNonOverridableAction();
                    action.setCallbackAction(callbackAction);
                    Game.getCurrentGame().getActionQueue().addAction(action);
                    this.sourceAction.getDataTable().add((CardIndex)action.getDataTable().get());
                    return true;
                }
                if (this.switchToFallbackAction() != null) {
                    list = this.currentOverrideAction.prepareOverrideActionList(this);
                    this.execThreadedOverrideActionList(list, callbackAction);
                } else if (this.currentOverrideAction.getActionEvent() != GameConst.GameEventId.ABILITY) {
                    this.sourceAction.reset();
                    Game.getCurrentGame().getActionQueue().addAction(this.sourceAction);
                }
            }
            return false;
        }
        if (this.currentOverrideAction.getSourceEvent().getId() == GameConst.GameEventId.DAMAGE || this.currentOverrideAction.getSourceEvent().getId() == GameConst.GameEventId.CRUSH) {
            Platform.runLater(() -> UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.roleOwner).getLifeClothZone().flashZoneMesh(Color.GREEN));
        }
        Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
            this.sourceAction.callOnActionOverridden();
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        });
        return true;
    }

    private OverrideExecResult execThreadedOverrideActionList(OverrideActionList list, CallbackGameAction callbackAction) {
        Object obj;
        for (int i = 0; i < list.getTotalActions(); ++i) {
            GameAction<?> action = list.getAction(i, 0);
            action.setSourceAbility(list.shouldPreserveSources() ? list.getSourceEvent().getSourceAbility() : this.currentOverrideAction.getSourceAbilityRC());
            action.setSourceCardIndex(list.shouldPreserveSources() ? list.getSourceEvent().getSourceCardIndex() : this.currentOverrideAction.getSourceAbilityRC().getSourceCardIndex());
            action.setSourceCost(list.getSourceEvent().getSourceCost());
            action.setCallbackAction(callbackAction);
            Game.getCurrentGame().getActionQueue().addAction(action);
            if (action.isBlocked()) {
                this.previousBlockedOverrideResult = action.getSourceOverrideResult();
                if (this.previousBlockedOverrideResult.blockedOverrideFallbackAction != null) {
                    return OverrideExecResult.INTERRUPTED_BLOCKED;
                }
            }
            if (action.isNonMandatoryAction() || action.isSuccessful()) continue;
            return OverrideExecResult.INTERRUPTED;
        }
        if (list.shouldPreserveSources() && list.getAction(0) != null && (obj = list.getAction(0).getDataTable().get()) instanceof CardIndex) {
            CardIndex cardIndex = (CardIndex)obj;
            this.sourceAction.getDataTable().add(cardIndex);
        }
        return (this.currentOverrideAction.getOverrideFlags() & 2) == 0 ? OverrideExecResult.SUCCESS : OverrideExecResult.DONT_BLOCK;
    }

    public static enum OverrideExecResult {
        SUCCESS,
        INTERRUPTED,
        INTERRUPTED_BLOCKED,
        DONT_BLOCK;

    }
}

