/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.callback;

import javafx.application.Platform;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEffectActivateResolve;
import open.batoru.core.gameplay.actions.ActionManualChoice;
import open.batoru.core.gameplay.actions.ActionManualChoiceMode;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceMode;
import open.batoru.core.gameplay.callback.CallbackThread;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.data.ability.ARTSAbility;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.ModalAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.modifiers.CostModifier;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class CostCallbackThread
extends CallbackThread {
    private final AbilityCostList costList;
    private final GameEvent sourceEvent;

    public CostCallbackThread(ActionPayCost sourceAction, AbilityCostList costList, GameEvent sourceEvent) {
        super(sourceAction);
        this.costList = costList;
        this.sourceEvent = sourceEvent;
    }

    @Override
    public void run() {
        Ability ability = this.getSourceAction().getSourceAbility();
        if (this.sourceEvent != null) {
            if (ability instanceof CheckZoneAbility) {
                CheckZoneAbility checkZoneAbility = (CheckZoneAbility)ability;
                this.payReductionCost(checkZoneAbility);
                this.payBetCost(checkZoneAbility);
                this.payAdditionalCost(checkZoneAbility);
            }
            if (ability instanceof ARTSAbility) {
                ARTSAbility artsAbility = (ARTSAbility)ability;
                this.payEncoreCost(artsAbility);
            }
            if (ability instanceof ModalAbility) {
                ModalAbility modalAbility = (ModalAbility)ability;
                this.chooseEffectModes(modalAbility);
            }
        }
        if (this.costList != null && !this.costList.getDataArray().isEmpty()) {
            this.costList.payAll();
        }
        AbilityCost.setCallbackAction(null);
        if (this.sourceEvent != null) {
            ability.setLastCostCallbackAction(null);
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectActivateResolve(ability, this.sourceEvent));
        }
        ActionPayCost.resetIsPayingCostsState();
        this.getSourceAction().resumeHaltedCallback();
    }

    private void payReductionCost(CheckZoneAbility ability) {
        boolean mustPayReductionCost;
        AbilityCostList reductionPayCostList = ability.getReductionPayCostList();
        if (reductionPayCostList == null) {
            return;
        }
        if (ability.getReductionForcedPaymentMinCount() == 0) {
            GameAction action;
            if (PlayerControl.isChoosingPlayer(ability.getSourceCardIndex().getCurrentOwnerSafe())) {
                action = new ActionManualChoice((Ability)ability, LanguageParser.getString(!ability.isBetReductionCost() ? "UI_GAME_WINDOW_PAY_TITLE_REDUCTION" : "UI_GAME_WINDOW_TITLE_BET"));
                if (!reductionPayCostList.canBePaid()) {
                    ((ActionManualChoice)action).setLocked(true);
                }
            } else {
                action = new ActionPlayerChoiceInteger();
            }
            action.treatAsMidEffAction();
            action.setCallbackAction(this.getSourceAction());
            Game.getCurrentGame().getActionQueue().addAction(action);
            mustPayReductionCost = (Integer)action.getDataTable().get() == 1;
        } else {
            mustPayReductionCost = true;
        }
        if (mustPayReductionCost) {
            int numPaid;
            Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(ability, LanguageParser.getString(!ability.isBetReductionCost() ? "UI_GAME_SIDEBAR_CHOICE_COST_REDUCTION" : "UI_GAME_SIDEBAR_CHOICE_COST_BET")));
            reductionPayCostList.payAll();
            if (ability.isBetReductionCost()) {
                ability.setHasUsedBet();
            }
            if ((numPaid = reductionPayCostList.getDataArray().getFirst().getPaidNumWithResult()) > 0) {
                String reducedEnerCostString = ability.getReductionEnerCostString().repeat(ability.getReductionCostModifierMode() == CostModifier.ModifierMode.REDUCE ? numPaid : 1);
                CostModifier costModifier = new CostModifier(() -> new EnerCost(reducedEnerCostString), ability.getReductionCostModifierMode());
                ability.setReductionCostModifier(costModifier);
            }
        }
    }

    private void payAdditionalCost(CheckZoneAbility ability) {
        if (ability.getAdditionalCostLists().isEmpty()) {
            return;
        }
        AbilityCostList costListAdditional = ability.getAdditionalCostLists().getFirst();
        if (!costListAdditional.canBePaid()) {
            return;
        }
        GameAction action = PlayerControl.isChoosingPlayer(ability.getSourceCardIndex().getCurrentOwnerSafe()) ? new ActionManualChoice((Ability)ability, LanguageParser.getString("UI_GAME_WINDOW_PAY_TITLE_ADDITIONAL")) : new ActionPlayerChoiceInteger();
        action.treatAsMidEffAction();
        action.setCallbackAction(this.getSourceAction());
        Game.getCurrentGame().getActionQueue().addAction(action);
        if ((Integer)action.getDataTable().get() == 1) {
            Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(ability, LanguageParser.getString("UI_GAME_SIDEBAR_CHOICE_COST_ADDITIONAL")));
            costListAdditional.payAll();
            ability.setHasPaidAdditionalCost();
        }
    }

    private void payBetCost(CheckZoneAbility ability) {
        if (ability.isBetReductionCost() || ability.getBetCostLists().isEmpty()) {
            return;
        }
        AbilityCostList costListBet = ability.getBetCostLists().getFirst();
        if (!costListBet.canBePaid()) {
            return;
        }
        GameAction action = PlayerControl.isChoosingPlayer(ability.getSourceCardIndex().getCurrentOwnerSafe()) ? new ActionManualChoice((Ability)ability, LanguageParser.getString("UI_GAME_WINDOW_PAY_TITLE_BET")) : new ActionPlayerChoiceInteger();
        action.treatAsMidEffAction();
        action.setCallbackAction(this.getSourceAction());
        Game.getCurrentGame().getActionQueue().addAction(action);
        if ((Integer)action.getDataTable().get() == 1) {
            Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(ability, LanguageParser.getString("UI_GAME_SIDEBAR_CHOICE_COST_BET")));
            costListBet.payAll();
            ability.setHasUsedBet();
            ability.updateDynamicCost();
        }
    }

    private void payEncoreCost(ARTSAbility ability) {
        if (ability.getEncoreCostLists().isEmpty()) {
            return;
        }
        AbilityCostList costListEncore = ability.getEncoreCostLists().getFirst();
        if (!costListEncore.canBePaid()) {
            return;
        }
        GameAction action = PlayerControl.isChoosingPlayer(ability.getSourceCardIndex().getCurrentOwnerSafe()) ? new ActionManualChoice((Ability)ability, LanguageParser.getString("UI_GAME_WINDOW_PAY_TITLE_ENCORE")) : new ActionPlayerChoiceInteger();
        action.treatAsMidEffAction();
        action.setCallbackAction(this.getSourceAction());
        Game.getCurrentGame().getActionQueue().addAction(action);
        if ((Integer)action.getDataTable().get() == 1) {
            Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenOption(ability, LanguageParser.getString("UI_GAME_SIDEBAR_CHOICE_COST_ENCORE")));
            costListEncore.payAll();
            ability.setHasUsedEncore();
        }
    }

    private void chooseEffectModes(ModalAbility ability) {
        if (ability.getModeChoiceMinPicks() == null) {
            return;
        }
        ability.onModesChosenPre();
        GameAction action = PlayerControl.isChoosingPlayer(ability.getSourceCardIndex().getCurrentOwnerSafe()) ? new ActionManualChoiceMode(ability) : new ActionPlayerChoiceMode(ability);
        action.treatAsMidEffAction();
        action.setCallbackAction(this.getSourceAction());
        Game.getCurrentGame().getActionQueue().addAction(action);
        ability.setChosenModes((Integer)action.getDataTable().get());
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenModes(ability, ability.getChosenModes(), ability.getModalChoiceRepeatTracker()));
    }
}

