/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.control;

import open.batoru.core.Deck;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.core.gameplay.actions.ActionReturnToDeck;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.data.CardConst;
import open.batoru.data.ability.events.EventBanish;

public final class ControlTemporaryCardRules {
    public static boolean applyLocationOverrideOnLeaveField(CardIndex cardIndex, GameAction<?> sourceAction) {
        if (cardIndex != null && cardIndex.getIndexedInstance() != null && sourceAction != null && GameConst.CardLocation.isSIGNI(cardIndex.getLocation())) {
            if (sourceAction.isChildAction()) {
                sourceAction = sourceAction.getParentAction();
            }
            boolean isCraft = cardIndex.getIndexedInstance().isState(8);
            boolean isResona = cardIndex.getIndexedInstance().matchesTypeByRef(sourceAction.getSourceAbility(), CardConst.CardType.RESONA);
            if (!isCraft && !isResona || isResona && !isCraft && sourceAction instanceof ActionReturnToDeck || isCraft && sourceAction instanceof ActionExclude) {
                return false;
            }
            TransientCardGameAction action = isResona && !isCraft ? new ActionReturnToDeck(cardIndex, Deck.DeckPosition.TOP) : new ActionExclude(cardIndex);
            EventBanish event = new EventBanish(cardIndex, sourceAction.getSourceCardIndex(), sourceAction.getSourceAbility(), sourceAction.getSourceCost());
            OverrideAction override = new OverrideAction(event.getId(), OverrideAction.OverrideScope.CALLER, 4, (list, sourceAbilityRC) -> list.addAction(action));
            OverrideResult overrideResult = new OverrideResult(cardIndex.getCurrentOwnerSafe(), sourceAction);
            overrideResult.addOverrideAction(override, event);
            overrideResult.blockedOverrideFallbackAction = action;
            sourceAction.setAsBlocked(overrideResult, true);
            return true;
        }
        return false;
    }

    private ControlTemporaryCardRules() {
    }
}

