/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.control;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.paint.Color;
import open.batoru.Settings;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CutInResponse;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionAttackPre;
import open.batoru.core.gameplay.actions.ActionEffectActivateAction;
import open.batoru.core.gameplay.actions.ActionEffectEndCutInResponse;
import open.batoru.core.gameplay.actions.ActionManualGrow;
import open.batoru.core.gameplay.actions.ActionManualPutOnFieldResona;
import open.batoru.core.gameplay.actions.ActionPhaseAdvanceEnd;
import open.batoru.core.gameplay.actions.ActionPutOnFieldARTS;
import open.batoru.core.gameplay.actions.ActionPutOnFieldKeyPre;
import open.batoru.core.gameplay.actions.ActionPutOnFieldPiece;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSpell;
import open.batoru.core.gameplay.actions.ActionRetire;
import open.batoru.core.gameplay.control.ControlPutOnFieldSIGNI;
import open.batoru.core.gameplay.control.UtilAbilityAvailableControl;
import open.batoru.core.gameplay.phases.AttackPhasePreDef;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.SpellAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.EnerColor;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.game.overlay.window.OverlayWindowChoice;
import open.batoru.game.overlay.window.OverlayWindowEffectActivateAction;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class PlayerControl
implements Disposable {
    private Picker<?> currentPicker;
    private boolean isPlayerLocked;

    public void onCardClicked(Card3D source) {
        if (this.currentPicker != null) {
            this.currentPicker.pick(source);
            return;
        }
        if (this.isPlayerLocked) {
            return;
        }
        CardIndex cardIndex = source.getCardIndex();
        if (cardIndex.getIndexedInstance() == null) {
            return;
        }
        GameConst.CardLocation location = cardIndex.getLocation();
        if (!CardIndex.isOwnCard(cardIndex) && !Game.getCurrentGame().isNeutralPerspectiveGame() && Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() == GameConst.GamePhase.MAIN && PlayerControl.getCurrentCutInResponse() == null && location == GameConst.CardLocation.TRASH) {
            this.showAvailableActionAbilities(cardIndex.getZoneByLocation(), 1);
            return;
        }
        if (CardIndex.isOwnCard(cardIndex) && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            Phase currentPhase = Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase();
            switch (currentPhase.getId()) {
                case MAIN: {
                    if (PlayerControl.getCurrentCutInResponse() == null && !Game.getCurrentGame().getGameRules().isOwnTurn() || PlayerControl.getCurrentCutInResponse() != null && CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex()) || Game.getCurrentGame().getActionQueue().isBusy() || !Game.getCurrentGame().getGameRules().getEffectProcessor().isComplete()) {
                        return;
                    }
                    if (GameConst.CardLocation.isOnField(location)) {
                        this.showAvailableActionAbilities(source.getOwnerZone().getTopCard().getCardIndex(), 1);
                        break;
                    }
                    if (location == GameConst.CardLocation.TRASH || location == GameConst.CardLocation.ENER) {
                        this.showAvailableActionAbilities(cardIndex.getZoneByLocation(), 1);
                        break;
                    }
                    if (location == GameConst.CardLocation.DECK_LRIG) {
                        this.showAvailableLRIGDeckAbilities(1);
                        break;
                    }
                    if (location != GameConst.CardLocation.HAND) break;
                    if (!Game.getCurrentGame().getGameRules().isOwnTurn()) {
                        return;
                    }
                    PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
                    CardIndex cardIndexLRIG = field.getLRIGZone().getTopCard().getCardIndex();
                    if (cardIndex.getCardReference().getType() == CardConst.CardType.SIGNI) {
                        Optional<OverlayWindowEffectActivateAction> window = this.showAvailableActionAbilities(cardIndex, 1);
                        if (window.isEmpty()) {
                            ControlPutOnFieldSIGNI.attempt(source);
                            break;
                        }
                        window.get().getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SIGNI_EFF_CANCEL"));
                        window.get().getConfirmButton().setOnAction(e -> {
                            OverlayWindow.removeFromFieldOverlay((OverlayWindow)window.get());
                            ControlPutOnFieldSIGNI.attempt(source);
                        });
                        break;
                    }
                    if (cardIndex.getCardReference().getType() != CardConst.CardType.SPELL) break;
                    if (cardIndex.getIndexedInstance().getLRIGType().getPrimaryValue() != CardConst.CardLRIGType.NO_LRIG_LIMIT && !cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexLRIG.getIndexedInstance().getLRIGType())) {
                        OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SIGNI_LRIG"));
                        return;
                    }
                    Optional<SpellAbility> abilitySpell = SpellAbility.findSpellAbility(cardIndex);
                    if (abilitySpell.isEmpty() || abilitySpell.get().getConditionState(cardIndex) == AbilityCondition.ConditionState.BAD || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_SPELL).check(Game.getCurrentGame().getPlayerRole(), cardIndex, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
                        OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SPELL_USE"));
                        return;
                    }
                    if (!abilitySpell.get().canPayCost()) {
                        OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_SPELL_COST"));
                        return;
                    }
                    if (Settings.INSTANCE.shouldAutoConfirmSpellUsage()) {
                        this.onManualUseSpell(source);
                        break;
                    }
                    OverlayWindowChoice window = new OverlayWindowChoice(LanguageParser.getString("UI_GAME_WINDOW_SPELL_TITLE"), abilitySpell.get(), null);
                    window.setAlias("spell");
                    window.getButtonsList().getFirst().setOnAction(e -> {
                        OverlayWindow.removeFromFieldOverlay(window);
                        this.onManualUseSpell(source);
                    });
                    window.getButtonsList().getLast().setOnAction(e -> OverlayWindow.removeFromFieldOverlay(window));
                    OverlayWindow.addToFieldOverlay(window);
                    break;
                }
                case ATTACK_PRE: 
                case ATTACK_DEF: {
                    AttackPhasePreDef phaseARTS = (AttackPhasePreDef)currentPhase;
                    if (PlayerControl.getCurrentCutInResponse() == null && phaseARTS.getRoleUser() != Game.getCurrentGame().getPlayerRole() || PlayerControl.getCurrentCutInResponse() != null && CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex()) || Game.getCurrentGame().getActionQueue().isBusy() || !Game.getCurrentGame().getGameRules().getEffectProcessor().isComplete()) {
                        return;
                    }
                    if (GameConst.CardLocation.isOnField(location) || location == GameConst.CardLocation.HAND) {
                        this.showAvailableActionAbilities(source.getOwnerZone().getTopCard().getCardIndex(), 2);
                        break;
                    }
                    if (location == GameConst.CardLocation.TRASH || location == GameConst.CardLocation.TRASH_LRIG || location == GameConst.CardLocation.ENER) {
                        this.showAvailableActionAbilities(cardIndex.getZoneByLocation(), 2);
                        break;
                    }
                    if (location != GameConst.CardLocation.DECK_LRIG) break;
                    this.showAvailableLRIGDeckAbilities(2);
                    break;
                }
                case ATTACK_SIGNI: 
                case ATTACK_LRIG: {
                    if (!Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().getActionQueue().isBusy() || !(source.getOwnerZone() instanceof FieldZone) || !source.getCardIndex().isFaceUp()) {
                        return;
                    }
                    if (source != source.getOwnerZone().getTopCard()) {
                        cardIndex = source.getOwnerZone().getTopCard().getCardIndex();
                    }
                    if ((currentPhase.getId() != GameConst.GamePhase.ATTACK_SIGNI || !GameConst.CardLocation.isSIGNI(cardIndex.getLocation())) && (currentPhase.getId() != GameConst.GamePhase.ATTACK_LRIG || !GameConst.CardLocation.isLRIG(cardIndex.getLocation()))) break;
                    if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ATTACK).check(cardIndex) == RuleCheck.RuleCheckState.BLOCK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_ATTACK).check(Game.getCurrentGame().getPlayerRole(), cardIndex, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
                        OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_ATTACK"));
                        return;
                    }
                    List<AbilityCostList> dataCostListsAttack = ((AbilityCost)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(cardIndex)).getSourceCostList().getSourceDataCostLists();
                    if (!AbilityCostList.canPayDataCostLists(dataCostListsAttack)) {
                        OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_ATTACK_COST"));
                        return;
                    }
                    if ((cardIndex.getIndexedInstance().getAttackModifierFlags().getValue() & 0x10) == 0) {
                        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
                        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                            CardIndex cardIndexZone;
                            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
                            if (!FieldZone.isOccupied(zoneSIGNI) || ((cardIndexZone = zoneSIGNI.getTopCard().getCardIndex()).getIndexedInstance().getAttackModifierFlags().getValue() & 0x10) == 0 || cardIndexZone.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ATTACK).check(cardIndexZone) != RuleCheck.RuleCheckState.OK || !((AbilityCost)cardIndexZone.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(cardIndexZone)).getSourceCostList().getSourceDataCostLists().isEmpty()) continue;
                            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_ATTACK_FORCED_OTHER"), Color.RED);
                            return;
                        }
                    }
                    this.isPlayerLocked = true;
                    try {
                        int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
                        Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionAttackPre");
                        GameSendActionAttempt attempt = new GameSendActionAttempt("ATK", nextOrder, String.valueOf(cardIndex.getId()));
                        Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                            this.isPlayerLocked = false;
                            if (!pp.getDataArgument(0).equals("!4")) {
                                Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionAttackPre(source.getOwnerZone().getTopCard().getCardIndex(), dataCostListsAttack));
                            } else {
                                this.showInvalidTimingAlert("Attack");
                            }
                        });
                        attempt.send();
                        break;
                    }
                    catch (UnknownHostException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        }
    }

    public void onZoneClicked(FieldZone source) {
        if (this.currentPicker != null) {
            this.currentPicker.pick(source);
        }
    }

    public void onEnerColorClicked(EnerColor source) {
        if (this.currentPicker != null) {
            this.currentPicker.pick((Object)source);
        }
    }

    private void onManualUseSpell(Card3D source) {
        this.isPlayerLocked = true;
        source.getOwnerZone().swapWithKnownAlternativeIfAvailable(source);
        try {
            int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
            Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionPutOnFieldSpell");
            GameSendActionAttempt attempt = new GameSendActionAttempt("SPELL", nextOrder, String.valueOf(source.getCardIndex().getId()));
            Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                this.isPlayerLocked = false;
                if (!pp.getDataArgument(0).equals("!4")) {
                    Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionPutOnFieldSpell(source.getCardIndex()));
                } else {
                    this.showInvalidTimingAlert("Use spell");
                }
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private Optional<OverlayWindowEffectActivateAction> showAvailableActionAbilities(CardIndex cardIndex, int useTiming) {
        if (!cardIndex.isFaceUp()) {
            return Optional.empty();
        }
        if (PlayerControl.getCurrentCutInResponse() != null) {
            if (CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex())) {
                return Optional.empty();
            }
            useTiming = 4;
        }
        return this.showAvailableActionAbilities(UtilAbilityAvailableControl.getAvailableActionAbilities(useTiming, cardIndex), useTiming);
    }

    private void showAvailableActionAbilities(Zone zone, int useTiming) {
        if (PlayerControl.getCurrentCutInResponse() != null) {
            if (CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex())) {
                return;
            }
            useTiming = 4;
        }
        this.showAvailableActionAbilities(UtilAbilityAvailableControl.getAvailableActionAbilities(useTiming, zone), useTiming);
    }

    private Optional<OverlayWindowEffectActivateAction> showAvailableActionAbilities(List<Ability> cacheActionAbilities, int useTiming) {
        if (!cacheActionAbilities.isEmpty()) {
            OverlayWindowEffectActivateAction window = new OverlayWindowEffectActivateAction(cacheActionAbilities);
            window.setAlias("action");
            OverlayWindow.addToFieldOverlay(window);
            window.getConfirmButton().setOnAction(e -> OverlayWindow.removeFromFieldOverlay(window));
            window.setOnAbilityChosen(arrayId -> {
                if (this.isTimingInvalid(useTiming)) {
                    OverlayWindow.removeFromFieldOverlay(window);
                    return;
                }
                Ability ability = (Ability)cacheActionAbilities.get(arrayId);
                if (Settings.INSTANCE.shouldAutoConfirmActionActivation() || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.WARN) {
                    this.onManualActivateAction(window, ability);
                } else {
                    OverlayWindow.hideWindow(window);
                    OverlayWindowChoice windowConfirm = new OverlayWindowChoice(LanguageParser.getString("UI_GAME_WINDOW_ACTION_TITLE"), ability, null);
                    windowConfirm.setAlias("action_confirm");
                    windowConfirm.getButtonsList().getFirst().setOnAction(e -> {
                        OverlayWindow.removeFromFieldOverlay(windowConfirm);
                        this.onManualActivateAction(window, ability);
                    });
                    windowConfirm.getButtonsList().getLast().setOnAction(e -> {
                        OverlayWindow.removeFromFieldOverlay(windowConfirm);
                        window.setLock(false);
                        OverlayWindow.showWindow(window);
                    });
                    OverlayWindow.addToFieldOverlay(windowConfirm);
                }
            });
            return Optional.of(window);
        }
        return Optional.empty();
    }

    private void onManualActivateAction(OverlayWindowEffectActivateAction window, Ability ability) {
        window.setLock(true);
        window.getConfirmButton().setDisable(true);
        this.isPlayerLocked = true;
        try {
            int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
            Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionEffectActivateAction");
            GameSendActionAttempt attempt = new GameSendActionAttempt("ACT", nextOrder, ability.getSourceCardId() + "|" + ability.getAbilityId());
            Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                OverlayWindow.removeFromFieldOverlay(window);
                this.isPlayerLocked = false;
                if (!pp.getDataArgument(0).equals("!4")) {
                    if ((ability.getFlags().getValue() & 0x10000) == 0) {
                        Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionEffectActivateAction(ability.getSourceCardIndex(), ability.getAbilityId()));
                    } else {
                        Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionPutOnFieldSpell(ability.getSourceCardIndex(), Game.getCurrentGame().getPlayerRole()));
                    }
                } else {
                    this.showInvalidTimingAlert("Activate action");
                }
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void showAvailableLRIGDeckAbilities(int useTiming) {
        List<Ability> cacheLRIGDeckAbilities;
        if (PlayerControl.getCurrentCutInResponse() != null) {
            if (CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex())) {
                return;
            }
            useTiming = 4;
        }
        if (!(cacheLRIGDeckAbilities = UtilAbilityAvailableControl.getAvailableLRIGDeckAbilities(useTiming)).isEmpty()) {
            OverlayWindowEffectActivateAction window = new OverlayWindowEffectActivateAction(cacheLRIGDeckAbilities);
            window.setAlias("action_lrig");
            OverlayWindow.addToFieldOverlay(window);
            window.getConfirmButton().setOnAction(e -> OverlayWindow.removeFromFieldOverlay(window));
            int refUseTiming = useTiming;
            window.setOnAbilityChosen(arrayId -> {
                boolean isAssistLRIG;
                if (this.isTimingInvalid(refUseTiming)) {
                    OverlayWindow.removeFromFieldOverlay(window);
                    return;
                }
                Ability ability = (Ability)cacheLRIGDeckAbilities.get(arrayId);
                CardIndex cardIndex = ability.getSourceCardIndex();
                boolean bl = isAssistLRIG = cardIndex.getCardReference().getType() == CardConst.CardType.LRIG_ASSIST;
                if (isAssistLRIG || Settings.INSTANCE.shouldAutoConfirmUseFromLRIGDeck() || ability.getConditionState(cardIndex) == AbilityCondition.ConditionState.WARN) {
                    if (!isAssistLRIG || cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.MUST_IGNORE_GROW_LRIG_TYPE).check(cardIndex) == RuleCheck.RuleCheckState.BLOCK) {
                        this.onManualUseCardFromLRIGDeck(window, ability);
                    } else {
                        AnimationBorderIcon aniBorder;
                        OverlayWindow.hideWindow(window);
                        OverlayWindowCard windowChoiceLRIG = new OverlayWindowCard(LanguageParser.getString("UI_GAME_WINDOW_GROW_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_GROW_DESC_CHOICE"), 0, 1);
                        windowChoiceLRIG.setAlias("grow");
                        windowChoiceLRIG.setConfirmButtonText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CONFIRM"), LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CANCEL"));
                        windowChoiceLRIG.setShowPickedCount(false);
                        windowChoiceLRIG.setAutoConfirm(true);
                        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
                        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
                        ArrayList<Card3D> listValidTargets = new ArrayList<Card3D>();
                        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft()) && cardIndex.getIndexedInstance().getLevel().getValue() == field.getLRIGAssistZoneLeft().getTopCard().getCardIndex().getIndexedInstance().getLevel().getValue() + 1) {
                            aniBorder = new AnimationBorderIcon(field.getLRIGAssistZoneLeft(), TargetFilter.TargetHint.GENERIC);
                            aniBorder.play();
                            listAniBorder.add(aniBorder);
                            listValidTargets.add(field.getLRIGAssistZoneLeft().getTopCard());
                        }
                        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight()) && cardIndex.getIndexedInstance().getLevel().getValue() == field.getLRIGAssistZoneRight().getTopCard().getCardIndex().getIndexedInstance().getLevel().getValue() + 1) {
                            aniBorder = new AnimationBorderIcon(field.getLRIGAssistZoneRight(), TargetFilter.TargetHint.GENERIC);
                            aniBorder.play();
                            listAniBorder.add(aniBorder);
                            listValidTargets.add(field.getLRIGAssistZoneRight().getTopCard());
                        }
                        CardPicker picker = new CardPicker(0, 1, listAniBorder);
                        picker.setOnPickValidate(listValidTargets::contains);
                        picker.setOnPickHandled((card3D, wasAdded) -> windowChoiceLRIG.updatePickedCount(picker.getPickedCount(), picker));
                        this.setCurrentPicker(picker);
                        windowChoiceLRIG.getConfirmButton().setOnAction(e -> {
                            AnimationBorderIcon.stopAll(listAniBorder);
                            OverlayWindow.removeFromFieldOverlay(windowChoiceLRIG);
                            if (picker.getPickedCount() == 0) {
                                window.setLock(false);
                                OverlayWindow.showWindow(window);
                            } else {
                                Card3D card3D = (Card3D)picker.getPickedList().getFirst();
                                card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                                this.onManualUseCardFromLRIGDeck(window, ability, card3D);
                            }
                            this.setCurrentPicker(null);
                        });
                        OverlayWindow.addToFieldOverlay(windowChoiceLRIG);
                    }
                } else {
                    OverlayWindow.hideWindow(window);
                    OverlayWindowChoice windowConfirm = new OverlayWindowChoice(LanguageParser.getString("UI_GAME_WINDOW_LRIG_TITLE"), ability, null);
                    windowConfirm.setAlias("action_lrig_confirm");
                    windowConfirm.getButtonsList().getFirst().setOnAction(e -> {
                        OverlayWindow.removeFromFieldOverlay(windowConfirm);
                        this.onManualUseCardFromLRIGDeck(window, ability);
                    });
                    windowConfirm.getButtonsList().getLast().setOnAction(e -> {
                        OverlayWindow.removeFromFieldOverlay(windowConfirm);
                        window.setLock(false);
                        OverlayWindow.showWindow(window);
                    });
                    OverlayWindow.addToFieldOverlay(windowConfirm);
                }
            });
        }
    }

    private void onManualUseCardFromLRIGDeck(OverlayWindowEffectActivateAction window, Ability ability) {
        this.onManualUseCardFromLRIGDeck(window, ability, null);
    }

    private void onManualUseCardFromLRIGDeck(OverlayWindowEffectActivateAction window, Ability ability, Card3D chosenCardExtra) {
        window.setLock(true);
        window.getConfirmButton().setDisable(true);
        this.isPlayerLocked = true;
        try {
            int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
            Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionPutOnFieldFromLRIGDeck");
            Object data = String.valueOf(ability.getSourceCardId());
            if (chosenCardExtra != null) {
                data = (String)data + "|" + chosenCardExtra.getCardIndex().getId();
            }
            GameSendActionAttempt attempt = new GameSendActionAttempt("ACTLRIG", nextOrder, (String)data);
            Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                OverlayWindow.removeFromFieldOverlay(window);
                if (!pp.getDataArgument(0).equals("!4")) {
                    CardConst.CardType cardType = ability.getSourceCardIndex().getCardReference().getType();
                    GameAction action = null;
                    switch (cardType) {
                        case SPELL: {
                            action = new ActionPutOnFieldSpell(ability.getSourceCardIndex(), Game.getCurrentGame().getPlayerRole());
                            break;
                        }
                        case ARTS: {
                            action = new ActionPutOnFieldARTS(ability.getSourceCardIndex());
                            break;
                        }
                        case KEY: {
                            action = new ActionPutOnFieldKeyPre(ability.getSourceCardIndex());
                            break;
                        }
                        case PIECE: {
                            action = new ActionPutOnFieldPiece(ability.getSourceCardIndex());
                            break;
                        }
                        case RESONA: {
                            action = new ActionManualPutOnFieldResona(ability.getSourceCardIndex());
                            break;
                        }
                        case LRIG_ASSIST: {
                            CardIndex cardIndexCurrentAssistLRIG = null;
                            if (chosenCardExtra == null) {
                                PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
                                if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
                                    CardIndex cardIndexLRIGAssistLeft = field.getLRIGAssistZoneLeft().getTopCard().getCardIndex();
                                    if (ability.getSourceCardIndex().getIndexedInstance().getLRIGType().matches(cardIndexLRIGAssistLeft.getIndexedInstance().getLRIGType())) {
                                        cardIndexCurrentAssistLRIG = cardIndexLRIGAssistLeft;
                                    }
                                }
                                if (cardIndexCurrentAssistLRIG == null && FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
                                    CardIndex cardIndexLRIGAssistRight = field.getLRIGAssistZoneRight().getTopCard().getCardIndex();
                                    if (ability.getSourceCardIndex().getIndexedInstance().getLRIGType().matches(cardIndexLRIGAssistRight.getIndexedInstance().getLRIGType())) {
                                        cardIndexCurrentAssistLRIG = cardIndexLRIGAssistRight;
                                    }
                                }
                                if (cardIndexCurrentAssistLRIG == null) {
                                    break;
                                }
                            } else {
                                cardIndexCurrentAssistLRIG = chosenCardExtra.getCardIndex();
                            }
                            action = new ActionManualGrow(cardIndexCurrentAssistLRIG, ability.getSourceCardIndex(), chosenCardExtra != null);
                        }
                    }
                    if (action != null) {
                        Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, action);
                    }
                } else {
                    this.showInvalidTimingAlert("Use card from LRIG deck");
                }
                this.isPlayerLocked = false;
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private boolean isTimingInvalid(int useTiming) {
        return PlayerControl.getCurrentCutInResponse() == null && useTiming == 1 && !Game.getCurrentGame().getGameRules().isOwnTurn() || PlayerControl.getCurrentCutInResponse() != null && CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex()) || Game.getCurrentGame().getActionQueue().isBusy() || !Game.getCurrentGame().getGameRules().getEffectProcessor().isComplete() || useTiming == 1 && Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() != GameConst.GamePhase.MAIN || useTiming == 2 && Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() != GameConst.GamePhase.ATTACK_PRE && Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() != GameConst.GamePhase.ATTACK_DEF;
    }

    public void onManualPhaseNext() {
        if (this.isPlayerLocked || this.currentPicker != null || UI.getTabGame().getFieldSceneOverlay().getDisconnectedScreen() != null || UI.getTabGame().getFieldSceneOverlay().getWinScreen() != null) {
            return;
        }
        if (PlayerControl.getCurrentCutInResponse() != null) {
            if (!CardIndex.isOwnCard(PlayerControl.getCurrentCutInResponse().getSourceCardIndex()) || Game.getCurrentGame().getFakeReceiver() != null) {
                this.isPlayerLocked = true;
                try {
                    int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
                    Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionEffectEndCutInResponse");
                    GameSendActionAttempt attempt = new GameSendActionAttempt("ENDCUT", nextOrder, "");
                    Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                        if (!this.isPlayerLocked) {
                            return;
                        }
                        if (!pp.getDataArgument(0).equals("!4")) {
                            Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionEffectEndCutInResponse());
                        } else {
                            this.showInvalidTimingAlert("End cut-in response");
                        }
                    });
                    attempt.send();
                }
                catch (UnknownHostException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            return;
        }
        if (Game.getCurrentGame().getActionQueue().isBusy()) {
            return;
        }
        Phase currentPhase = Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase();
        if (currentPhase.getId() != GameConst.GamePhase.ATTACK_PRE && currentPhase.getId() != GameConst.GamePhase.ATTACK_DEF) {
            if (!Game.getCurrentGame().getGameRules().isOwnTurn()) {
                return;
            }
            if (currentPhase.getId() == GameConst.GamePhase.ATTACK_SIGNI) {
                PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
                for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                    CardIndex cardIndex;
                    ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
                    if (!FieldZone.isOccupied(zoneSIGNI) || ((cardIndex = zoneSIGNI.getTopCard().getCardIndex()).getIndexedInstance().getAttackModifierFlags().getValue() & 0x10) == 0 || cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ATTACK).check(cardIndex) != RuleCheck.RuleCheckState.OK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_ATTACK).check(Game.getCurrentGame().getPlayerRole(), cardIndex, new Object[0]) != RuleCheck.RuleCheckState.OK || !((AbilityCost)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(cardIndex)).getSourceCostList().getSourceDataCostLists().isEmpty()) continue;
                    OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_ATTACK_FORCED"), Color.RED);
                    return;
                }
            }
        } else if (((AttackPhasePreDef)currentPhase).getRoleUser() != Game.getCurrentGame().getPlayerRole()) {
            return;
        }
        this.isPlayerLocked = true;
        try {
            int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
            Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionPhaseAdvanceEnd");
            GameSendActionAttempt attempt = new GameSendActionAttempt("PASS", nextOrder, "");
            Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                if (!this.isPlayerLocked) {
                    return;
                }
                this.isPlayerLocked = false;
                if (!pp.getDataArgument(0).equals("!4")) {
                    Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionPhaseAdvanceEnd());
                } else {
                    this.showInvalidTimingAlert("Advance phase");
                }
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void onManualRetire() {
        if (this.isPlayerLocked || this.currentPicker != null || Game.getCurrentGame().getActionQueue().isBusy() || PlayerControl.getCurrentCutInResponse() != null || !Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().getGameRules().wasRetireUsed() || Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().getId() != GameConst.GamePhase.MAIN) {
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!FieldZone.isOccupied(zoneSIGNI) || zoneSIGNI.getTopCard().getCardIndex().getCardReference().getType() == CardConst.CardType.RESONA) continue;
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(zoneSIGNI, TargetFilter.TargetHint.TRASH);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        }
        if (listAniBorder.isEmpty()) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_RETIRE_ZONE"));
            return;
        }
        OverlayWindowCard window = new OverlayWindowCard(LanguageParser.getString("UI_GAME_WINDOW_RETIRE_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_RETIRE_DESC"), 0, 3);
        window.setConfirmButtonText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CONFIRM"), LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CANCEL"));
        CardPicker picker = new CardPicker(0, 3);
        picker.setOnPickValidate(card3D -> GameConst.CardLocation.isSIGNI(card3D.getCardIndex().getLocation()) && card3D.getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE && CardIndex.isOwnCard(card3D.getCardIndex()) && card3D.getOwnerZone().getTopCard() == card3D && card3D.getCardIndex().getCardReference().getType() != CardConst.CardType.RESONA);
        picker.setOnPickHandled((card3D, wasAdded) -> window.updatePickedCount(picker.getPickedCount()));
        this.setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            if (picker.getPickedCount() == 0) {
                AnimationBorderIcon.stopAll(listAniBorder);
                this.setCurrentPicker(null);
                OverlayWindow.removeFromFieldOverlay(window);
                return;
            }
            this.currentPicker.setLock(true);
            window.getConfirmButton().setDisable(true);
            StringJoiner packetData = new StringJoiner("|");
            for (Card3D card3D : picker.getPickedList()) {
                packetData.add(String.valueOf(card3D.getCardIndex().getId()));
            }
            this.isPlayerLocked = true;
            try {
                int nextOrder = Game.getCurrentGame().getActionQueue().getLastOrder() + 1;
                Game.getCurrentGame().getActionQueue().prepareNextActionClassName(nextOrder, "ActionRetire");
                GameSendActionAttempt attempt = new GameSendActionAttempt("RET", nextOrder, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofIdlePlayerAction(nextOrder), pp -> {
                    AnimationBorderIcon.stopAll(listAniBorder);
                    this.isPlayerLocked = false;
                    if (picker.getPickedCount() > 0) {
                        CardIndex[] listCardIndexes = new CardIndex[picker.getPickedCount()];
                        for (int i = 0; i < picker.getPickedCount(); ++i) {
                            Card3D card3D = (Card3D)picker.getPickedList().get(i);
                            card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                            listCardIndexes[i] = card3D.getCardIndex();
                        }
                        if (!pp.getDataArgument(0).equals("!4")) {
                            if (!Game.getCurrentGame().getGameRules().wasRetireUsed()) {
                                Game.getCurrentGame().getGameRules().setRetireAsUsed();
                                Game.getCurrentGame().getActionQueue().addServerAction(nextOrder, new ActionRetire(listCardIndexes));
                            }
                        } else {
                            this.showInvalidTimingAlert("Retire");
                        }
                    }
                    this.setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                System.err.println(ex.getMessage());
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }

    public void setCurrentPicker(Picker<?> picker) {
        if (picker != null && this.currentPicker != null) {
            return;
        }
        if (picker == null && this.currentPicker != null) {
            this.currentPicker.dispose();
        }
        this.currentPicker = picker;
        if (this.currentPicker != null && Game.getCurrentGame().getFakeReceiver() != null) {
            Game.getCurrentGame().getFakeReceiver().processPicker(this.currentPicker);
        }
    }

    public Picker<?> getCurrentPicker() {
        return this.currentPicker;
    }

    public void setPlayerLock(boolean lock) {
        this.isPlayerLocked = lock;
    }

    public void showInvalidTimingAlert(String actionText) {
        Alert alert = new Alert(Alert.AlertType.WARNING, LanguageParser.getString("UI_ALERT_TIMING"), new ButtonType[0]);
        alert.setHeaderText(LanguageParser.getString("UI_ALERT_TIMING_HEADER") + " - " + actionText);
        alert.showAndWait();
    }

    @Override
    public void dispose() {
        this.setCurrentPicker(null);
    }

    private static CutInResponse getCurrentCutInResponse() {
        return Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse();
    }

    public static boolean isChoosingPlayer(Game.GamePlayerRole rolePlayer) {
        return Game.getCurrentGame().getPlayerRole() == rolePlayer && !Game.getCurrentGame().isNeutralPerspectiveGame();
    }
}

