/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionGrow;
import open.batoru.core.gameplay.control.UtilCardPlayableControl;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.ARTSAbility;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.PieceAbility;
import open.batoru.data.ability.SpellAbility;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game.ZoneLRIGAssist;
import open.batoru.game._3d.Card3D;
import open.batoru.ui.UI;

public final class UtilAbilityAvailableControl {
    public static List<Ability> getAvailableActionAbilities(int flagUseTiming, CardIndex cardIndex) {
        ArrayList<Ability> cacheActionAbilities = new ArrayList<Ability>();
        if (cardIndex.getLocation() == GameConst.CardLocation.LRIG) {
            List<Ability> listPlayerAbilities = Game.getCurrentGame().getOwnPlayerData().getPlayerAbilities();
            for (Ability ability : listPlayerAbilities) {
                if (!(ability instanceof ActionAbility) || ability.isDisabled() || ability.isMuted() || ability.isUseLimited() || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(cardIndex.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_ABILITY).check(new PlayerRuleCheckData(cardIndex.getIndexedInstance().getCurrentOwner(), null, ability, new Object[0])) != RuleCheck.RuleCheckState.OK || (ability.getActiveUseTiming().getValue() & flagUseTiming) == 0 || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD || !AbilityCostList.canPayDataCostListsPrivately(ability.getCostLists())) continue;
                cacheActionAbilities.add(ability);
            }
        }
        for (Ability ability : cardIndex.getIndexedInstance().getAbilityList()) {
            if (!(ability instanceof ActionAbility) || ability.isDisabled() || ability.isUseLimited() || ability.isMuted() || ability.isBonded() && !ability.getSourceCardIndex().getIndexedInstance().hasActiveBond() || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(cardIndex.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_ABILITY).check(cardIndex.getIndexedInstance().getCurrentOwner(), cardIndex, ability, new Object[0]) != RuleCheck.RuleCheckState.OK || (ability.getActiveUseTiming().getValue() & flagUseTiming) == 0 || flagUseTiming == 4 && Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse().getCutInCardType() != ability.getCutInExpectedCardType() || (!ability.getActiveLocations().isEmpty() || !cardIndex.isInDefaultExpectedLocation()) && !ability.getActiveLocations().contains((Object)cardIndex.getLocation()) || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD || !AbilityCostList.canPayDataCostListsPrivately(ability.getCostLists())) continue;
            cacheActionAbilities.add(ability);
        }
        return cacheActionAbilities;
    }

    public static List<Ability> getAvailableActionAbilities(int flagUseTiming, Zone zone) {
        ArrayList<Ability> cacheActionAbilities = new ArrayList<Ability>();
        for (int i = 0; i < zone.getTotalCards(); ++i) {
            CardIndex cardIndex = zone.getZoneCardList().get(i).getCardIndex();
            for (Ability ability : cardIndex.getIndexedInstance().getAbilityList()) {
                boolean canBePaid;
                boolean isAltManualAct;
                boolean bl = isAltManualAct = (ability.getFlags().getValue() & 0x10000) != 0;
                if (!(ability instanceof ActionAbility) && !isAltManualAct || ability.isDisabled() || ability.isUseLimited() || ability.isMuted() || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD) continue;
                if (!isAltManualAct) {
                    if (ability.getAbilityOwner() != Game.getCurrentGame().getPlayerRole() || ability.isBonded() && !ability.getSourceCardIndex().getIndexedInstance().hasActiveBond() || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(cardIndex.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_ABILITY).check(cardIndex.getIndexedInstance().getCurrentOwner(), cardIndex, ability, new Object[0]) != RuleCheck.RuleCheckState.OK || (ability.getActiveUseTiming().getValue() & flagUseTiming) == 0 || flagUseTiming == 4 && Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse().getCutInCardType() != ability.getCutInExpectedCardType() || (!ability.getActiveLocations().isEmpty() || !cardIndex.isInDefaultExpectedLocation()) && !ability.getActiveLocations().contains((Object)cardIndex.getLocation()) || !AbilityCostList.canPayDataCostListsPrivately(ability.getCostLists())) continue;
                    cacheActionAbilities.add(ability);
                    continue;
                }
                if (!(ability instanceof SpellAbility)) continue;
                SpellAbility spellAbility = (SpellAbility)ability;
                if (flagUseTiming != 1 || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(cardIndex.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_SPELL).check(cardIndex.getIndexedInstance().getCurrentOwner(), cardIndex, ability, new Object[0]) != RuleCheck.RuleCheckState.OK) continue;
                if (ability.getAbilityOwner() != Game.getCurrentGame().getPlayerRole()) {
                    spellAbility.getCostLists().forEach(costList -> costList.setPayerRole(Game.getCurrentGame().getPlayerRole()));
                    canBePaid = spellAbility.canPayCost();
                    spellAbility.getCostLists().forEach(costList -> costList.setPayerRole(ability.getAbilityOwner()));
                } else {
                    canBePaid = spellAbility.canPayCost();
                }
                if (!canBePaid) continue;
                cacheActionAbilities.add(ability);
            }
        }
        return cacheActionAbilities;
    }

    public static List<Ability> getAvailableLRIGDeckAbilities(int flagUseTiming) {
        ArrayList<Ability> cacheAbilities = new ArrayList<Ability>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        CardIndex cardIndexCurrentLRIG = field.getLRIGZone().getTopCard().getCardIndex();
        for (Card3D card3D : field.getDeckZone(Deck.DeckType.LRIG).getZoneCardList()) {
            CardIndex cardIndex = card3D.getCardIndex();
            CardConst.CardType cardType = cardIndex.getCardReference().getType();
            switch (cardType) {
                case SPELL: {
                    CheckZoneAbility ability;
                    Optional<CheckZoneAbility> found;
                    if (flagUseTiming != 1 || !cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexCurrentLRIG.getIndexedInstance().getLRIGType()) || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_SPELL).check(Game.getCurrentGame().getPlayerRole(), cardIndex, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || !(found = SpellAbility.findSpellAbility(cardIndex)).isPresent() || (ability = (SpellAbility)found.get()).isDisabled() || ability.isMuted() || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD || !ability.canPayCost()) break;
                    cacheAbilities.add(ability);
                    break;
                }
                case ARTS: {
                    Optional<CheckZoneAbility> found;
                    if (!cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexCurrentLRIG.getIndexedInstance().getLRIGType()) || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_ARTS).check(Game.getCurrentGame().getPlayerRole(), cardIndex, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || !(found = ARTSAbility.findARTSAbility(cardIndex)).isPresent()) break;
                    CheckZoneAbility ability = (ARTSAbility)found.get();
                    ability.updateDynamicCost();
                    if (ability.isDisabled() || ability.isMuted() || (ability.getActiveUseTiming().getValue() & flagUseTiming) == 0 || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD || !ability.canPayCost()) break;
                    cacheAbilities.add(ability);
                    break;
                }
                case KEY: {
                    if (!cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexCurrentLRIG.getIndexedInstance().getLRIGType()) || (cardIndex.getIndexedInstance().getUseTimingFlags().getValue() & flagUseTiming) == 0 || flagUseTiming == 4 || !AbilityCostList.canPayDataCostListsPrivately(cardIndex.getIndexedInstance().getCost())) break;
                    cacheAbilities.add(cardIndex.getIndexedInstance().getAbilityList().getFirst());
                    break;
                }
                case PIECE: {
                    CheckZoneAbility ability;
                    Optional<CheckZoneAbility> found;
                    if (!cardIndex.getIndexedInstance().getLRIGType().matches(cardIndexCurrentLRIG.getIndexedInstance().getLRIGType()) || cardIndex.getCardReference().getLRIGTeam() != null && cardIndex.getCardReference().getLRIGTeam() != CardConst.CardLRIGTeam.DREAM_TEAM && !cardIndex.getIndexedInstance().isLRIGTeam(cardIndex.getCardReference().getLRIGTeam()) || !(found = PieceAbility.findPieceAbility(cardIndex)).isPresent() || !((PieceAbility)(ability = found.get())).canUseWithoutAssists() && (!FieldZone.isOccupied(field.getLRIGAssistZoneLeft()) || !FieldZone.isOccupied(field.getLRIGAssistZoneRight()))) break;
                    ability.updateDynamicCost();
                    if (ability.isDisabled() || ability.isMuted() || (ability.getActiveUseTiming().getValue() & flagUseTiming) == 0 || flagUseTiming == 4 && Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse().getCutInCardType() != ability.getCutInExpectedCardType() || ability.getConditionState(ability.getSourceCardIndex()) == AbilityCondition.ConditionState.BAD || !ability.canPayCost()) break;
                    cacheAbilities.add(ability);
                    break;
                }
                case RESONA: {
                    if ((cardIndex.getIndexedInstance().getUseTimingFlags().getValue() & flagUseTiming) == 0 || flagUseTiming == 4 || UtilCardPlayableControl.isPlayable(Game.getCurrentGame().getPlayerRole(), cardIndex, null) != UtilCardPlayableControl.PlayableResult.OK) break;
                    cacheAbilities.add(cardIndex.getIndexedInstance().getAbilityList().getLast());
                    break;
                }
                case LRIG_ASSIST: {
                    if (cardIndex.getIndexedInstance().getLevel().getValue() > field.getLRIGZone().getTopCard().getCardIndex().getIndexedInstance().getLevel().getValue() || (cardIndex.getIndexedInstance().getUseTimingFlags().getValue() & flagUseTiming) == 0 || flagUseTiming == 4 || !AbilityCostList.canPayDataCostListsPrivately(cardIndex.getIndexedInstance().getCost()) || !UtilAbilityAvailableControl.canGrowAsAssistLRIG(cardIndex, field.getLRIGAssistZoneLeft()) && !UtilAbilityAvailableControl.canGrowAsAssistLRIG(cardIndex, field.getLRIGAssistZoneRight())) break;
                    cacheAbilities.add(cardIndex.getIndexedInstance().getAbilityList().getFirst());
                }
            }
        }
        return cacheAbilities;
    }

    private static boolean canGrowAsAssistLRIG(CardIndex cardIndex, ZoneLRIGAssist zoneLRIGAssist) {
        return FieldZone.isOccupied(zoneLRIGAssist) && ActionGrow.canGrowInto(zoneLRIGAssist.getTopCard().getCardIndex(), cardIndex);
    }

    private UtilAbilityAvailableControl() {
    }
}

