/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.DataTable;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class AttackPhaseLRIG
extends Phase {
    private final List<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();

    public AttackPhaseLRIG(GameConst.GamePhase id) {
        super(id);
    }

    @Override
    void onStart() {
        Log.printMessage("start: atk/lrig");
        if (Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().isNeutralPerspectiveGame()) {
            FX.run(this::resetAvailableAttackers);
        }
    }

    @Override
    void onEnd() {
        if (Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().isNeutralPerspectiveGame()) {
            FX.run(this::hideAvailableAttackers);
        }
    }

    @Override
    public void onIdle() {
        this.resetAvailableAttackers();
        if (Game.getCurrentGame().getGameRules().isOwnTurn() && this.listAniBorder.isEmpty() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            UI.getTabGame().getFieldSceneOverlay().getGameControls().setPhaseButtonHighlight(true);
            if (Settings.INSTANCE.shouldAutoSkipLRIGAttackPhase() && !Game.getCurrentGame().getGameRules().isGuardStep()) {
                Game.getCurrentGame().getPlayerControl().onManualPhaseNext();
            }
        }
    }

    @Override
    public void onBusy() {
        if (Game.getCurrentGame().getGameRules().isOwnTurn() || Game.getCurrentGame().isNeutralPerspectiveGame()) {
            this.hideAvailableAttackers();
        }
    }

    private void resetAvailableAttackers() {
        if (!Game.getCurrentGame().getGameRules().isOwnTurn() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
            return;
        }
        this.hideAvailableAttackers();
        this.processPlayerField(!Game.getCurrentGame().isNeutralPerspectiveGame() ? Game.getCurrentGame().getPlayerRole() : Game.getCurrentGame().getGameRules().getTurnPlayer());
    }

    private void processPlayerField(Game.GamePlayerRole rolePlayer) {
        DataTable<CardIndex> data = CardAbilities.getLRIGs(rolePlayer);
        for (int i = 0; i < data.size(); ++i) {
            CardIndex cardIndex = data.get(i);
            if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ATTACK).check(cardIndex) == RuleCheck.RuleCheckState.BLOCK || !AbilityCostList.canPayDataCostLists(((AbilityCost)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(cardIndex)).getSourceCostList().getSourceDataCostLists())) continue;
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(cardIndex.getZoneByLocation(), TargetFilter.TargetHint.GENERIC);
            aniBorder.play();
            this.listAniBorder.add(aniBorder);
        }
    }

    private void hideAvailableAttackers() {
        AnimationBorderIcon.stopAll(this.listAniBorder);
        this.listAniBorder.clear();
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setPhaseButtonHighlight(false);
    }
}

