/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionDiscard;
import open.batoru.core.gameplay.actions.ActionManualDiscard;
import open.batoru.core.gameplay.actions.ActionPhaseAdvanceEnd;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.game.ZoneCheck;
import open.batoru.ui.UI;

public class EndPhase
extends Phase {
    public EndPhase(GameConst.GamePhase id) {
        super(id);
    }

    @Override
    void onStart() {
        Log.printMessage("start: end");
        Game.GamePlayerRole roleTurnPlayer = Game.getCurrentGame().getGameRules().getTurnPlayer();
        int current = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(roleTurnPlayer).getHand().getTotalCards();
        int max = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(roleTurnPlayer).getRuleValue(PlayerRuleCheckRegistry.PlayerRuleValueType.MAX_HAND_SIZE).getValue();
        int numToDiscard = current - max;
        if (numToDiscard > 0) {
            if (PlayerControl.isChoosingPlayer(Game.getCurrentGame().getGameRules().getTurnPlayer())) {
                Game.getCurrentGame().getActionQueue().addAction(new ActionManualDiscard(numToDiscard, numToDiscard, AbilityConst.ChoiceLogic.DEFAULT, null, null));
            } else {
                Game.getCurrentGame().getActionQueue().addAction(new ActionDiscard());
            }
        }
    }

    private void trashCheckZoneCards(Game.GamePlayerRole rolePlayer) {
        ZoneCheck zoneCheck = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).getCheckZone();
        int numToTrash = zoneCheck.getTotalCards();
        ActionTrash prevAction = null;
        for (int i = 0; i < numToTrash; ++i) {
            ActionTrash action = new ActionTrash(zoneCheck.getZoneCardList().get(i).getCardIndex());
            action.setAtOnce(prevAction, i, numToTrash);
            prevAction = action;
            Game.getCurrentGame().getActionQueue().addAction(action);
        }
    }

    @Override
    void onEnd() {
        Game.GamePlayerRole roleTurnPlayer = Game.getCurrentGame().getGameRules().getTurnPlayer();
        this.trashCheckZoneCards(roleTurnPlayer);
        this.trashCheckZoneCards(Game.GamePlayerRole.getOpponentRole(roleTurnPlayer));
        Log.printMessage("-----");
    }

    @Override
    public void onIdle() {
        Game.getCurrentGame().getActionQueue().addAction(new ActionPhaseAdvanceEnd());
    }
}

