/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.phases;

import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.control.UtilAbilityAvailableControl;
import open.batoru.core.gameplay.phases.Phase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game.ZoneDeck;
import open.batoru.game.ZoneEner;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class MainPhase
extends Phase {
    private final List<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();

    public MainPhase(GameConst.GamePhase id) {
        super(id);
    }

    @Override
    void onStart() {
        Log.printMessage("start: main");
    }

    @Override
    void onEnd() {
        if (Game.getCurrentGame().getGameRules().isOwnTurn()) {
            FX.run(this::hideAvailableActionAbilities);
        }
    }

    @Override
    public void onIdle() {
        if (Game.getCurrentGame().getGameRules().isOwnTurn() && Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() == null || Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() != null && !CardIndex.isOwnCard(Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse().getSourceCardIndex())) {
            this.resetAvailableActionAbilities(Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() == null ? 1 : 4);
            if (Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() != null && !CardIndex.isOwnCard(Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse().getSourceCardIndex())) {
                if (this.listAniBorder.isEmpty() && (Game.getCurrentGame().getGameRules().getEffectProcessor().isComplete() || Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse().isWaitingForOpponentResponse())) {
                    Game.getCurrentGame().getPlayerControl().onManualPhaseNext();
                    return;
                }
                if (!Game.getCurrentGame().isNeutralPerspectiveGame()) {
                    UI.getTabGame().getFieldSceneOverlay().getGameControls().setPhaseButtonHighlight(true);
                }
            }
        } else if (Game.getCurrentGame().isNeutralPerspectiveGame()) {
            this.resetAvailableActionAbilities(Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() == null ? 1 : 4);
        }
    }

    @Override
    public void onBusy() {
        this.hideAvailableActionAbilities();
    }

    private void resetAvailableActionAbilities(int flagUseTiming) {
        this.hideAvailableActionAbilities();
        Game.GamePlayerRole rolePlayer = !Game.getCurrentGame().isNeutralPerspectiveGame() ? Game.getCurrentGame().getPlayerRole() : Game.getCurrentGame().getGameRules().getTurnPlayer();
        this.processPlayerField(flagUseTiming, UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer));
        if (flagUseTiming == 1) {
            this.processAltManualActAbilities(UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Game.GamePlayerRole.getOpponentRole(rolePlayer)));
        }
    }

    private void hideAvailableActionAbilities() {
        AnimationBorderIcon.stopAll(this.listAniBorder);
        this.listAniBorder.clear();
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setPhaseButtonHighlight(false);
    }

    private void processPlayerField(int flagUseTiming, PlayerField field) {
        ZoneEner zoneEner;
        ZoneDeck zoneTrashLRIG;
        ZoneDeck zoneTrash;
        Card3D card3DKey;
        CardIndex cardIndex = field.getLRIGZone().getTopCard().getCardIndex();
        if (!UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, cardIndex).isEmpty()) {
            this.addIconBorder(field.getLRIGZone());
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft()) && !UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, cardIndex = field.getLRIGAssistZoneLeft().getTopCard().getCardIndex()).isEmpty()) {
            this.addIconBorder(field.getLRIGAssistZoneLeft());
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight()) && !UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, cardIndex = field.getLRIGAssistZoneRight().getTopCard().getCardIndex()).isEmpty()) {
            this.addIconBorder(field.getLRIGAssistZoneRight());
        }
        if ((card3DKey = field.getKeyZone().getTopCard()) != null) {
            cardIndex = card3DKey.getCardIndex();
            if (FieldZone.isOccupied(field.getKeyZone()) && !UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, cardIndex).isEmpty()) {
                this.addIconBorder(field.getKeyZone());
            }
        }
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!FieldZone.isOccupied(zoneSIGNI) || UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, cardIndex = zoneSIGNI.getTopCard().getCardIndex()).isEmpty()) continue;
            this.addIconBorder(zoneSIGNI);
        }
        if (!Game.getCurrentGame().isNeutralPerspectiveGame()) {
            for (Card3D card3D : field.getHand().getZoneCardList()) {
                if (UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, card3D.getCardIndex()).isEmpty()) continue;
                this.addIconBorder(card3D);
            }
            ZoneDeck zoneLRIGDeck = field.getDeckZone(Deck.DeckType.LRIG);
            if (!UtilAbilityAvailableControl.getAvailableLRIGDeckAbilities(flagUseTiming).isEmpty()) {
                this.addIconBorder(zoneLRIGDeck);
            }
        }
        if (!UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, zoneTrash = field.getTrashZone(Deck.DeckType.MAIN)).isEmpty()) {
            this.addIconBorder(zoneTrash);
        }
        if (!UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, zoneTrashLRIG = field.getTrashZone(Deck.DeckType.LRIG)).isEmpty()) {
            this.addIconBorder(zoneTrashLRIG);
        }
        if (!UtilAbilityAvailableControl.getAvailableActionAbilities(flagUseTiming, zoneEner = field.getEnerZone()).isEmpty()) {
            this.addIconBorder(zoneEner);
        }
    }

    private void processAltManualActAbilities(PlayerField field) {
        ZoneDeck zoneTrash = field.getTrashZone(Deck.DeckType.MAIN);
        if (!UtilAbilityAvailableControl.getAvailableActionAbilities(1, zoneTrash).isEmpty()) {
            this.addIconBorder(zoneTrash);
        }
    }

    private void addIconBorder(Zone zone) {
        AnimationBorderIcon aniBorder = new AnimationBorderIcon(zone, TargetFilter.TargetHint.ACTIVATE);
        aniBorder.play();
        this.listAniBorder.add(aniBorder);
    }

    private void addIconBorder(Card3D card3D) {
        AnimationBorderIcon aniBorder = new AnimationBorderIcon(card3D, TargetFilter.TargetHint.ACTIVATE);
        aniBorder.play();
        this.listAniBorder.add(aniBorder);
    }
}

