/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.pickers;

import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.PickHandler;
import open.batoru.core.gameplay.pickers.PickValidator;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.networking.PacketParser;

public class CardPicker
extends Picker<Card3D> {
    private PickValidator<Card3D> validator;
    private PickHandler<Card3D> handler;
    private ConditionHandler<CardIndex> condition;
    private final List<AnimationBorderIcon> listAniBorder;

    public CardPicker(int minPicks, int maxPicks) {
        this(minPicks, maxPicks, null);
    }

    public CardPicker(int minPicks, int maxPicks, List<AnimationBorderIcon> listAniBorder) {
        super(minPicks, maxPicks);
        this.listAniBorder = listAniBorder;
    }

    public void setValidateCondition(ConditionHandler<CardIndex> condition) {
        this.condition = condition;
    }

    public void setOnPickValidate(PickValidator<Card3D> validator) {
        this.validator = validator;
    }

    public void setOnPickHandled(PickHandler<Card3D> handler) {
        this.handler = handler;
    }

    public PickValidator<Card3D> getValidator() {
        return this.validator;
    }

    public ConditionHandler<CardIndex> getCondition() {
        return this.condition;
    }

    public List<CardIndex> getPickedCardIndexList() {
        return this.getPickedList().stream().map(Card3D::getCardIndex).toList();
    }

    @Override
    public void pick(Object pickedObject) {
        if (!(pickedObject instanceof Card3D)) {
            return;
        }
        Card3D card3D = (Card3D)pickedObject;
        if (!this.isLocked() && (this.validator == null || this.validator.isPickValid(card3D))) {
            if (!this.getPickedList().contains(card3D)) {
                if (this.getPickedList().size() < this.getMaxPicks()) {
                    AnimationBorderIcon aniBorder;
                    card3D.getVisibleMesh().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.SELECTED));
                    if (this.listAniBorder != null && (aniBorder = AnimationBorderIcon.findBorderByCard3D(this.listAniBorder, card3D)) != null) {
                        aniBorder.colorize(Color.GREY);
                    }
                    this.getPickedList().add(card3D);
                }
            } else {
                AnimationBorderIcon aniBorder;
                if (this.listAniBorder != null && (aniBorder = AnimationBorderIcon.findBorderByCard3D(this.listAniBorder, card3D)) != null) {
                    aniBorder.colorize(Color.WHITE);
                }
                card3D.getVisibleMesh().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                this.getPickedList().remove(card3D);
            }
            this.updatePickerStatus();
            if (this.handler != null) {
                this.handler.onPicked(card3D, this.getPickedList().contains(card3D));
            }
        }
    }

    @Override
    public void forceFakePick(PacketParser pp) {
        if (pp.getDataArgument(0).isEmpty()) {
            return;
        }
        for (int i = 0; i < pp.getDataArgsNum(); ++i) {
            CardIndex.getCardFromPacketData(pp.getDataArgument(i)).ifPresent(this::pick);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.validator = null;
        this.handler = null;
        this.condition = null;
    }
}

