/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.pickers;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ModifiableString;
import open.batoru.game.FieldZoneEnerGroup;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game._3d.EnerColor;
import open.batoru.networking.PacketParser;

public class EnerColorPicker
extends Picker<EnerColor> {
    private PickHandler handler;
    private ModifiableString remainingCost;
    private final List<FieldZoneEnerGroup> listEnerGroups;
    private ConditionHandler<CardIndex> condition;
    private PacketParser lastFakePickData;

    public EnerColorPicker(String costString, List<FieldZoneEnerGroup> listEnerGroups) {
        super(costString.length(), costString.length());
        this.remainingCost = new ModifiableString(costString);
        this.listEnerGroups = listEnerGroups;
    }

    public void setCostString(String costString) {
        this.resetPicks();
        this.remainingCost = new ModifiableString(costString);
    }

    public int getRemainingCostStringLength() {
        return this.remainingCost.getValue().length();
    }

    private void resetPicks() {
        ArrayList pickedColors = new ArrayList(this.getPickedList());
        for (EnerColor enerColor : pickedColors) {
            this.pick((Object)enerColor);
        }
    }

    public void setValidateCondition(ConditionHandler<CardIndex> condition) {
        this.condition = condition;
    }

    public ConditionHandler<CardIndex> getCondition() {
        return this.condition;
    }

    public void setOnPickHandled(PickHandler handler) {
        this.handler = handler;
    }

    public List<CardIndex> getPickedCardIndexList() {
        return this.getPickedList().stream().map(enerColor -> enerColor.getSourceEnerGroup().getSourceCard3D().getCardIndex()).toList();
    }

    @Override
    public void pick(Object pickedObject) {
        if (!(pickedObject instanceof EnerColor)) {
            return;
        }
        EnerColor enerColor = (EnerColor)((Object)pickedObject);
        if (!this.isLocked()) {
            enerColor.getSourceEnerGroup().toggleSelect(enerColor);
            int countPayEner = enerColor.getSourceEnerGroup().getSourceCard3D().getCardIndex().getIndexedInstance().getRCRegistry().getRuleValue(CardRuleCheckRegistry.CardRuleValueType.PAY_ENER_COUNT).getValue();
            String colorValue = String.valueOf(enerColor.getColor().getShortLabel()).repeat(countPayEner);
            if (!this.getPickedList().contains((Object)enerColor)) {
                this.remainingCost.removeValue(colorValue);
                for (int i = 0; i < countPayEner; ++i) {
                    this.getPickedList().add(enerColor);
                }
            } else {
                this.remainingCost.addValue(colorValue);
                for (int i = 0; i < countPayEner; ++i) {
                    this.getPickedList().remove((Object)enerColor);
                }
            }
            this.updateEnerGroupLockStatus(enerColor);
            this.updatePickerStatus();
            if (this.handler != null) {
                this.handler.onPicked(enerColor, this.getPickedList().contains((Object)enerColor));
            }
        }
    }

    private void updateEnerGroupLockStatus(EnerColor source) {
        for (FieldZoneEnerGroup enerGroup : this.listEnerGroups) {
            for (EnerColor enerColor : enerGroup.getEnerColorsList()) {
                if (enerColor == source) continue;
                if (enerColor.getSourceEnerGroup() == source.getSourceEnerGroup()) {
                    if (this.getPickedList().contains((Object)source)) {
                        enerColor.setLock(true);
                        continue;
                    }
                    if (this.isFullyPaid(enerColor.getColor())) continue;
                    enerColor.setLock(false);
                    continue;
                }
                if (enerColor.getColor() == source.getColor()) {
                    if (this.isFullyPaid(source.getColor())) {
                        if (enerGroup.getSelectedEnerColor() == enerColor) continue;
                        enerColor.setLock(true);
                        continue;
                    }
                    if (this.getPickedList().contains((Object)enerColor) || enerGroup.getSelectedEnerColor() != null) continue;
                    enerColor.setLock(false);
                    continue;
                }
                if (this.isFullyPaid(enerColor.getColor())) {
                    if (enerGroup.getSelectedEnerColor() == enerColor) continue;
                    enerColor.setLock(true);
                    continue;
                }
                if (this.getPickedList().contains((Object)enerColor) || enerGroup.getSelectedEnerColor() != null) continue;
                enerColor.setLock(false);
            }
        }
    }

    private boolean isFullyPaid(CardConst.CardColor color) {
        return !this.remainingCost.getValue().contains(String.valueOf(color.getShortLabel()));
    }

    @Override
    public void forceFakePick(PacketParser pp) {
        this.lastFakePickData = pp;
    }

    public PacketParser getLastFakePickData() {
        return this.lastFakePickData;
    }

    public void confirmForcedFakePick() {
        if (this.lastFakePickData == null || this.lastFakePickData.getDataArgument(0).equals(String.valueOf(0)) || this.lastFakePickData.isDataResponseCode()) {
            return;
        }
        for (int i = 0; i < this.lastFakePickData.getDataArgsNum(); i += 2) {
            Card3D card3D = Game.getCurrentGame().getIndexRegistry().getIndex(Integer.parseInt(this.lastFakePickData.getDataArgument(i))).getSourceCard3D();
            CardConst.CardColor cardColor = CardConst.CardColor.getColorByShortLabel(this.lastFakePickData.getDataArgument(i + 1).charAt(0));
            EnerColor color = this.listEnerGroups.stream().filter(enerGroup -> {
                Card3DSubstitute card3DSubstitute;
                Card3D patt0$temp;
                return enerGroup.getSourceCard3D() == card3D || (patt0$temp = enerGroup.getSourceCard3D()) instanceof Card3DSubstitute && (card3DSubstitute = (Card3DSubstitute)patt0$temp).getSource() == card3D;
            }).findFirst().flatMap(enerGroup -> enerGroup.getEnerColorsList().stream().filter(enerColor -> enerColor.getColor() == cardColor).findFirst()).orElse(null);
            this.pick((Object)color);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.handler = null;
        this.remainingCost = null;
        this.lastFakePickData = null;
    }

    @FunctionalInterface
    public static interface PickHandler {
        public void onPicked(EnerColor var1, boolean var2);
    }
}

