/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.pickers;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.PickHandler;
import open.batoru.core.gameplay.pickers.PickValidator;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.networking.PacketParser;

public class ZonePicker
extends Picker<FieldZone> {
    private PickValidator<FieldZone> validator;
    private PickHandler<FieldZone> handler;
    private ConditionHandler<FieldZone> condition;

    public ZonePicker(int minPicks, int maxPicks) {
        this(minPicks, maxPicks, null);
    }

    public ZonePicker(int minPicks, int maxPicks, ConditionHandler<FieldZone> condition) {
        super(minPicks, maxPicks);
        this.condition = condition;
    }

    public void setOnPickValidate(PickValidator<FieldZone> validator) {
        this.validator = validator;
    }

    public void setOnPickHandled(PickHandler<FieldZone> handler) {
        this.handler = handler;
    }

    public ConditionHandler<FieldZone> getCondition() {
        return this.condition;
    }

    @Override
    public void pick(Object pickedObject) {
        FieldZone fieldZone;
        if (pickedObject instanceof FieldZone) {
            FieldZone fieldZonePicked;
            fieldZone = fieldZonePicked = (FieldZone)pickedObject;
        } else if (pickedObject instanceof Card3D) {
            Card3D card3D = (Card3D)pickedObject;
            Zone zone = card3D.getOwnerZone();
            if (!(zone instanceof FieldZone)) {
                return;
            }
            FieldZone fieldZonePicked = (FieldZone)zone;
            fieldZone = fieldZonePicked;
        } else {
            return;
        }
        if (!this.isLocked() && (this.validator == null || this.validator.isPickValid(fieldZone))) {
            if (!this.getPickedList().contains(fieldZone)) {
                if (this.getPickedList().size() < this.getMaxPicks()) {
                    fieldZone.getZoneMesh().getMaterial().setDiffuseColor(Color.GREY);
                    this.getPickedList().add(fieldZone);
                }
            } else {
                fieldZone.getZoneMesh().getMaterial().setDiffuseColor(fieldZone.getDefaultColor());
                this.getPickedList().remove(fieldZone);
            }
            this.updatePickerStatus();
            if (this.handler != null) {
                this.handler.onPicked(fieldZone, this.getPickedList().contains(fieldZone));
            }
        }
    }

    @Override
    public void forceFakePick(PacketParser pp) {
        Game.GamePlayerRole rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(pp.getDataArgument(0)));
        if (!pp.getDataArgument(1).equals("!1")) {
            for (int i = 1; i < pp.getDataArgsNum(); ++i) {
                GameConst.CardLocation location = GameConst.CardLocation.getLocationByShortLabel(pp.getDataArgument(i));
                this.pick(FieldData.getZoneByLocation(rolePlayer, location));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.validator = null;
        this.handler = null;
        this.condition = null;
    }
}

