/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks.card;

import java.util.EnumMap;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.rulechecks.ActionOverrideRuleCheck;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.CostRuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.StateRuleCheck;
import open.batoru.core.gameplay.rulechecks.card.RuleCheckCanAttack;
import open.batoru.core.gameplay.rulechecks.card.RuleCheckCanAttackSIGNIZone;
import open.batoru.core.gameplay.rulechecks.card.RuleCheckCanPayColor;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ability.Ability;

public class CardRuleCheckRegistry
implements Disposable {
    private final EnumMap<CardRuleCheckType, CardRuleCheck<?>> ruleChecks = new EnumMap(CardRuleCheckType.class);
    private final EnumMap<CardRuleValueType, ModifiableInteger> ruleValues = new EnumMap(CardRuleValueType.class);

    public CardRuleCheckRegistry() {
        this.ruleChecks.put(CardRuleCheckType.CAN_PAY_COLOR, new RuleCheckCanPayColor());
        this.ruleChecks.put(CardRuleCheckType.CAN_GUARD, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_BANISHED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_DOWNED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_UPPED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_NEWLY_PUT_ON_FIELD, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_MOVED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_ATTACK, new RuleCheckCanAttack());
        this.ruleChecks.put(CardRuleCheckType.CAN_LAND_ATTACK, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_DEAL_DAMAGE, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_TARGETED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_BE_AFFECTED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_POWER_BE_CHANGED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_ABILITY_BE_ATTACHED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_ABILITY_BE_DISABLED, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.CAN_GROW, new StateRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.MUST_BE_TARGETED, new StateRuleCheck(data -> RuleCheck.RuleCheckState.BLOCK));
        this.ruleChecks.put(CardRuleCheckType.MUST_BE_BLOCKED, new StateRuleCheck(data -> RuleCheck.RuleCheckState.BLOCK));
        this.ruleChecks.put(CardRuleCheckType.MUST_ATTACK_SIGNI_ZONE, new RuleCheckCanAttackSIGNIZone());
        this.ruleChecks.put(CardRuleCheckType.MUST_IGNORE_GROW_LRIG_TYPE, new StateRuleCheck(data -> RuleCheck.RuleCheckState.BLOCK));
        this.ruleChecks.put(CardRuleCheckType.COST_TO_ATTACK, new CostRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.COST_TO_LAND_ATTACK, new CostRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.COST_TO_USE_LB, new CostRuleCheck());
        this.ruleChecks.put(CardRuleCheckType.ACTION_OVERRIDE, new ActionOverrideRuleCheck());
        this.ruleValues.put(CardRuleValueType.MAX_ATTACHMENTS, new ModifiableInteger(1));
        this.ruleValues.put(CardRuleValueType.ATTACK_DAMAGE_INSTANCES, new ModifiableInteger(1));
        this.ruleValues.put(CardRuleValueType.PAY_ENER_COUNT, new ModifiableInteger(1));
    }

    public <T extends CardRuleCheck<?>> T getRuleCheck(CardRuleCheckType ruleCheckType) {
        return (T)this.ruleChecks.get((Object)ruleCheckType);
    }

    public ModifiableInteger getRuleValue(CardRuleValueType ruleValueType) {
        return this.ruleValues.get((Object)ruleValueType);
    }

    @Override
    public void dispose() {
        this.ruleChecks.values().forEach(Disposable::dispose);
        this.ruleChecks.clear();
        this.ruleValues.clear();
    }

    public static enum CardRuleCheckType {
        CAN_PAY_COLOR,
        CAN_GUARD,
        CAN_BE_BANISHED,
        CAN_BE_DOWNED,
        CAN_BE_UPPED,
        CAN_BE_NEWLY_PUT_ON_FIELD,
        CAN_BE_MOVED,
        CAN_ATTACK,
        CAN_LAND_ATTACK,
        CAN_DEAL_DAMAGE,
        CAN_BE_TARGETED,
        CAN_BE_AFFECTED,
        CAN_POWER_BE_CHANGED,
        CAN_ABILITY_BE_ATTACHED,
        CAN_ABILITY_BE_DISABLED,
        CAN_GROW,
        MUST_BE_TARGETED,
        MUST_BE_BLOCKED,
        MUST_ATTACK_SIGNI_ZONE,
        MUST_IGNORE_GROW_LRIG_TYPE,
        COST_TO_ATTACK,
        COST_TO_LAND_ATTACK,
        COST_TO_USE_LB,
        ACTION_OVERRIDE;

    }

    public static enum CardRuleValueType {
        MAX_ATTACHMENTS,
        ATTACK_DAMAGE_INSTANCES,
        PAY_ENER_COUNT;

    }

    public static interface CardRuleCheck<T>
    extends Disposable {
        public T check(CardRuleCheckData var1);

        default public T check(CardIndex cardIndex) {
            return this.check(new CardRuleCheckData(cardIndex, null, null, new Object[0]));
        }

        default public T check(CardIndex cardIndex, CardIndex source, Ability ability, Object ... data) {
            return this.check(new CardRuleCheckData(cardIndex, source, ability, data));
        }

        default public T check(CardIndex cardIndex, Ability sourceAbility, Object ... data) {
            return this.check(new CardRuleCheckData(cardIndex, sourceAbility != null ? sourceAbility.getSourceCardIndex() : null, sourceAbility, data));
        }

        default public T check(CardIndex cardIndex, GameAction<?> action, Object ... data) {
            return this.check(new CardRuleCheckData(cardIndex, action.getSourceCardIndex(), action.getSourceAbility(), data));
        }
    }
}

