/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks.card;

import java.util.EnumMap;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheckData;
import open.batoru.core.gameplay.rulechecks.SIGNIZoneRuleCheck;

public class RuleCheckCanAttackSIGNIZone
extends SIGNIZoneRuleCheck<SIGNIZoneAttackPositionGroup> {
    private static final RuleCheck.RuleCheckHandler<SIGNIZoneAttackPositionGroup, RuleCheckData> DEFAULT_HANDLER = data -> {
        CardIndex cardIndex = ((CardRuleCheckData)data).getCardIndex();
        GameConst.SIGNIZonePosition zonePosition = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(cardIndex.getLocation());
        SIGNIZoneAttackPositionGroup result = new SIGNIZoneAttackPositionGroup(SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.DENY);
        if (zonePosition != null) {
            result.setState(GameConst.SIGNIZonePosition.getOppositeSIGNIPosition(zonePosition), SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW);
        }
        return result;
    };

    public RuleCheckCanAttackSIGNIZone() {
        super(DEFAULT_HANDLER);
    }

    @Override
    protected void mergeState(SIGNIZoneAttackPositionGroup result, SIGNIZoneAttackPositionGroup group, GameConst.SIGNIZonePosition zonePosition, SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState state) {
        result.setState(zonePosition, state, group.getAttackState(zonePosition));
    }

    public static class SIGNIZoneAttackPositionGroup
    extends SIGNIZoneRuleCheck.SIGNIZonePositionGroup {
        private final EnumMap<GameConst.SIGNIZonePosition, AttackZoneState> mapAtk = new EnumMap(GameConst.SIGNIZonePosition.class);

        public SIGNIZoneAttackPositionGroup(SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState defaultState) {
            super(defaultState);
        }

        public void setState(GameConst.SIGNIZonePosition zonePosition, SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState state, AttackZoneState stateAtk) {
            super.setState(zonePosition, state);
            this.setAttackState(zonePosition, stateAtk);
        }

        public void setAttackState(GameConst.SIGNIZonePosition zonePosition, AttackZoneState stateAtk) {
            if (stateAtk == null) {
                return;
            }
            this.mapAtk.put(zonePosition, stateAtk);
        }

        public AttackZoneState getAttackState(GameConst.SIGNIZonePosition zonePosition) {
            return this.mapAtk.getOrDefault((Object)zonePosition, AttackZoneState.DEFAULT);
        }

        public static enum AttackZoneState {
            DEFAULT,
            ZONE;

        }
    }
}

