/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.rulechecks.player;

import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheckData;
import open.batoru.core.gameplay.rulechecks.SIGNIZoneRuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneSIGNI;
import open.batoru.ui.UI;

public final class RuleCheckCanPlaceSIGNIOnZone
extends SIGNIZoneRuleCheck<SIGNIZoneRuleCheck.SIGNIZonePositionGroup> {
    public RuleCheckCanPlaceSIGNIOnZone() {
        super((RuleCheckData data) -> new SIGNIZoneRuleCheck.SIGNIZonePositionGroup(SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW));
    }

    @Override
    public SIGNIZoneRuleCheck.SIGNIZonePositionGroup check(PlayerRuleCheckData data) {
        int result = 0;
        for (int i = this.getRuleChecksNum() - 1; i >= 1; --i) {
            SIGNIZoneRuleCheck.SIGNIZonePositionGroup group = (SIGNIZoneRuleCheck.SIGNIZonePositionGroup)this.getRuleCheck(i).getResult(data);
            for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                if (group.getState(zonePosition) != SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.DENY) continue;
                result ^= 1 << zonePosition.getId();
            }
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(data.getPlayerRole());
        if (this.getRuleChecksNum() > 2 && field.getSIGNICount(false) == 0) {
            result ^= 0xFFFFFFFF;
        }
        int deleted = result;
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!zoneSIGNI.getNode().isVisible()) {
                deleted |= 1 << zonePosition.getId();
                continue;
            }
            if (this.getRuleChecksNum() > 2 || ((AbilityCost)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(data.getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_PLACE_SIGNI_ON_ZONE).check(data.getPlayerRole(), data.getSourceCardIndex(), data.getSourceAbility(), new Object[]{data.getSourceCardIndex(), zonePosition})).getSourceCostList().getDataArray().isEmpty()) continue;
            result &= 1 << zonePosition.getId();
            deleted &= 1 << zonePosition.getId();
        }
        result = ~(deleted | result) != 0 || deleted == 7 ? deleted | result : deleted ^ result;
        SIGNIZoneRuleCheck.SIGNIZonePositionGroup group = new SIGNIZoneRuleCheck.SIGNIZonePositionGroup(SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            group.setState(zonePosition, (result & 1 << zonePosition.getId()) != 0 ? SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.DENY : SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW);
        }
        return group;
    }

    public static boolean matchesResult(RuleCheckCanPlaceSIGNIOnZone ruleCheck, Game.GamePlayerRole rolePlayer, GameConst.SIGNIZonePosition zonePosition) {
        return ruleCheck.check(new PlayerRuleCheckData(rolePlayer, null, null, new Object[]{zonePosition})).getState(zonePosition) == SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW;
    }
}

