/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataCost;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardDataLRIGType;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.CardDataType;
import open.batoru.data.ModifiableDouble;
import open.batoru.data.ModifiableFlag;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableString;
import open.batoru.data.SpecialRestrict;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.CardAbilities;
import open.batoru.parsers.LanguageParser;
import open.batoru.parsers.RestrictedCardsParser;

public abstract class Card {
    private final CardDataImageSet imageSets = new CardDataImageSet();
    private RestrictedCardsParser.RestrictType banlistRestrictType = RestrictedCardsParser.RestrictType.NONE;
    private List<Card> banlistSimultaneousList;
    private SpecialRestrict handleSpecialRestrict;
    private String releaseDate;
    private CardConst.CardFace cardFace = CardConst.CardFace.FRONT;
    private String doubleFacedCardPairImageSetHint;
    private Card doubleFacedCardPairObject;
    private String nameOriginal = "";
    private String name = "";
    private String altNames = "";
    private String description = "";
    private List<String> linkedImageSets;
    private CardConst.CardType type;
    private final CardDataLRIGType dataLRIGType = new CardDataLRIGType();
    private CardConst.CardLRIGTeam team;
    private final CardDataSIGNIClass dataSIGNIClass = new CardDataSIGNIClass();
    private final CardDataColor dataColor = new CardDataColor();
    private final CardDataCost dataCost = new CardDataCost();
    private List<AbilityCostList> dataCostLists;
    private int level;
    private double limit;
    private double power;
    private int coins;
    private int flagsUseTiming = 0;
    private int flagsCard = 0;
    private EnumSet<CardConst.PlayFormat> playFormats = EnumSet.noneOf(CardConst.PlayFormat.class);
    private static String cacheLangFallbackName;
    private static String cacheLangFallbackDescription;

    public final void onCardRegistered() {
        if (!Settings.INSTANCE.getGameLanguage().equals("jp")) {
            if (!this.nameOriginal.isEmpty() && this.name.isEmpty() && cacheLangFallbackName != null) {
                this.name = cacheLangFallbackName;
            }
            if (this.description.isEmpty() && cacheLangFallbackDescription != null) {
                this.description = cacheLangFallbackDescription;
            }
            if (Settings.INSTANCE.getGameLanguage().equals("en") && !this.playFormats.contains((Object)CardConst.PlayFormat.ENGLISH)) {
                this.description = this.description.replace("<Ancient Weapon", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_ANCIENT_WEAPON")).replace("<Apparition", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_APPARITION")).replace("<Arm", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_ARM")).replace("<Beautiful Technique", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_BEAUTY")).replace("<Devil", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_DEVIL")).replace("<Earth Beast", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_EARTH_BEAST")).replace("<Electric Machine", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_ELECTRIC_MACHINE")).replace("<Gem", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_GEM")).replace("<Misfortune Insect", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_INSECT")).replace("<Playground Equipment", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_PLAYGROUND")).replace("<Venom Fang", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_VENOM_FANG")).replace("<Riding Machine", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_RIDING_MACHINE")).replace("<Space", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_SPACE")).replace("<Trick", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_TRICK")).replace("<Valor", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_VALOR")).replace("<Water Beast", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_WATER_BEAST")).replace("<Origin", "<" + LanguageParser.getString("CARD_SIGNI_CLASS_ORIGIN")).replace("banish", "vanish").replace("Banish", "Vanish").replace("Mikomiko Bodyguard", "Mikomiko Defense Squad");
            }
            cacheLangFallbackName = null;
            cacheLangFallbackDescription = null;
        }
    }

    public IndexedInstance newIndexedInstance(int sourceCardId) {
        return new IndexedInstance(sourceCardId);
    }

    public final void setDoubleFacedCardPairImageSetHint(String imageSet) {
        if (imageSet == null) {
            return;
        }
        this.doubleFacedCardPairImageSetHint = imageSet;
        this.setLinkedImageSets(imageSet);
    }

    public final void setDoubleFacedCardPairObject(Card cardObject) {
        this.doubleFacedCardPairObject = cardObject;
    }

    public final void setCardFace(CardConst.CardFace cardFace) {
        this.cardFace = cardFace;
    }

    public final void setImageSets(String ... imageSets) {
        this.imageSets.set(this, imageSets);
    }

    public final void setLinkedImageSets(String ... imageSets) {
        if (this.linkedImageSets == null) {
            this.linkedImageSets = new ArrayList<String>();
        }
        this.linkedImageSets.addAll(List.of(imageSets));
    }

    public final List<String> getLinkedImageSets() {
        return this.linkedImageSets != null ? Collections.unmodifiableList(this.linkedImageSets) : null;
    }

    public final void setBanlistRestriction(RestrictedCardsParser.RestrictType restrictType) {
        this.banlistRestrictType = restrictType;
    }

    public final void addBanlistSimultaneousCard(Card cardObject) {
        if (this.banlistSimultaneousList == null) {
            this.banlistSimultaneousList = new ArrayList<Card>();
        }
        this.banlistSimultaneousList.add(cardObject);
    }

    public final RestrictedCardsParser.RestrictType getBanlistRestriction() {
        return this.banlistRestrictType;
    }

    public final List<Card> getBanlistSimultaneousList() {
        return this.banlistSimultaneousList;
    }

    public final int getBanlistSimultaneousNum() {
        return this.banlistSimultaneousList == null ? 0 : this.banlistSimultaneousList.size();
    }

    public final void setSpecialRestriction(SpecialRestrict handleSpecialRestrict) {
        this.handleSpecialRestrict = handleSpecialRestrict;
    }

    public final SpecialRestrict getSpecialRestriction() {
        return this.handleSpecialRestrict;
    }

    public final void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public final String getReleaseDate() {
        return this.releaseDate;
    }

    public final void setOriginalName(String name) {
        this.nameOriginal = name;
        if (LanguageParser.isStringUndefined("LANG_CARD_FALLBACK") || "jp".equals(LanguageParser.getString("LANG_CARD_FALLBACK"))) {
            cacheLangFallbackName = this.nameOriginal;
        }
    }

    @Deprecated
    public final void setName(String name) {
        this.setName("en", name);
    }

    public final void setName(String lang, String name) {
        if (lang.equals(Settings.INSTANCE.getGameLanguage())) {
            this.name = name;
        } else {
            this.altNames = this.altNames + name;
            if (lang.equals(LanguageParser.getString("LANG_CARD_FALLBACK"))) {
                cacheLangFallbackName = name;
            }
        }
    }

    public final void setAltNames(String altNames) {
        this.altNames = this.altNames + altNames;
    }

    @Deprecated
    public final void setDescription(String description) {
        this.setDescription("en", description);
    }

    public final void setDescription(String lang, String description) {
        if (lang.equals(Settings.INSTANCE.getGameLanguage())) {
            this.description = description;
        } else if (lang.equals("jp") || lang.equals(LanguageParser.getString("LANG_CARD_FALLBACK"))) {
            cacheLangFallbackDescription = description;
        }
    }

    public final void setType(CardConst.CardType type) {
        this.type = type;
        if (type == CardConst.CardType.KEY) {
            this.flagsUseTiming = 1;
        } else if (type == CardConst.CardType.TOKEN) {
            this.banlistRestrictType = RestrictedCardsParser.RestrictType.TOKEN;
        }
    }

    public final void setLRIGType(CardConst.CardLRIGType ... cardLRIGTypes) {
        this.dataLRIGType.set(cardLRIGTypes);
    }

    public final void setLRIGTeam(CardConst.CardLRIGTeam team) {
        this.team = team;
    }

    public final void setSIGNIClass(CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        this.dataSIGNIClass.set(CardConst.CardSIGNIClassGeneration.SPIRIT, cardSIGNIClasses);
    }

    public final void setSIGNIClass(CardConst.CardSIGNIClassGeneration generation, CardConst.CardSIGNIClass ... cardSIGNIClasses) {
        this.dataSIGNIClass.set(generation, cardSIGNIClasses);
    }

    public final void setColor(CardConst.CardColor ... cardColors) {
        this.dataColor.set(cardColors);
    }

    public final void setCost(String ... costStrings) {
        this.dataCost.set(costStrings);
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public final void setLimit(double limit) {
        this.limit = limit;
    }

    public final void setPower(double power) {
        this.power = power;
    }

    public final void setCoins(int coins) {
        this.coins = coins;
    }

    public final void setUseTiming(int flagsUseTiming) {
        this.flagsUseTiming = flagsUseTiming;
    }

    public final void setCardFlags(int flagsCard) {
        this.flagsCard = flagsCard;
        if ((flagsCard & 8) != 0) {
            this.banlistRestrictType = RestrictedCardsParser.RestrictType.TOKEN;
        }
    }

    public final void setPlayFormat(CardConst.PlayFormat ... formats) {
        this.playFormats = EnumSet.copyOf(List.of(formats));
    }

    public final CardDataImageSet getImageSets() {
        return this.imageSets;
    }

    public final String getDoubleFacedCardPairImageSetHint() {
        return this.doubleFacedCardPairImageSetHint;
    }

    public final Card getDoubleFacedCardPairObject() {
        return this.doubleFacedCardPairObject;
    }

    public final CardConst.CardFace getCardFace() {
        return this.cardFace;
    }

    public final String getOriginalName() {
        return this.nameOriginal;
    }

    public final String getName() {
        return !this.name.isEmpty() ? this.name : this.nameOriginal;
    }

    @Deprecated
    public final String getTranslatedName() {
        return this.name;
    }

    public final String getAltNames() {
        return this.altNames;
    }

    public final String getDescription() {
        return this.description;
    }

    public final CardConst.CardType getType() {
        return this.type;
    }

    public final CardDataLRIGType getLRIGType() {
        return this.dataLRIGType;
    }

    public final CardConst.CardLRIGTeam getLRIGTeam() {
        return this.team;
    }

    public final CardDataSIGNIClass getSIGNIClass() {
        return this.dataSIGNIClass;
    }

    public final CardDataColor getColor() {
        return this.dataColor;
    }

    public final CardDataCost getCost() {
        return this.dataCost;
    }

    public final List<AbilityCostList> getCostAsDataCostLists() {
        if (this.dataCostLists == null) {
            this.dataCostLists = this.dataCost.exportAsCostListsDataArray();
        }
        return this.dataCostLists;
    }

    public final int getLevel() {
        return this.level;
    }

    public final Double getLimit() {
        return this.limit;
    }

    public final Double getPower() {
        return this.power;
    }

    public final int getCoins() {
        return this.coins;
    }

    public final int getUseTiming() {
        return this.flagsUseTiming;
    }

    public final int getCardFlags() {
        return this.flagsCard;
    }

    public boolean hasLifeBurst() {
        return (this.flagsCard & 1) != 0;
    }

    public boolean canGuard() {
        return (this.flagsCard & 2) != 0;
    }

    public boolean isCraft() {
        return (this.flagsCard & 8) != 0;
    }

    public boolean isAllowedInPlayFormat(CardConst.PlayFormat playFormat) {
        return playFormat == CardConst.PlayFormat.ALLSTAR || this.playFormats.contains((Object)playFormat) || playFormat == CardConst.PlayFormat.KEY_CLASSIC && this.playFormats.contains((Object)CardConst.PlayFormat.KEY) && (!this.playFormats.contains((Object)CardConst.PlayFormat.DIVA) || this.type == CardConst.CardType.LRIG && this.level == 0 || this.playFormats.contains((Object)CardConst.PlayFormat.KEY_CLASSIC));
    }

    public class IndexedInstance
    extends CardAbilities {
        private static int lastInstanceId;
        private int instanceId;
        private OnInstanceIdUpdatedHandler handlerInstanceId;
        private final CardDataType idCardType;
        private final CardDataLRIGType idLRIGType;
        private final CardDataSIGNIClass idSIGNIClass;
        private final CardDataColor idColor;
        private final List<AbilityCostList> idCost;
        private final ModifiableString idName;
        private final ModifiableInteger idLevel;
        private final ModifiableDouble idLimit;
        private final ModifiableDouble idPower;
        private final ModifiableFlag idFlagsUseTiming;
        private final ModifiableFlag idFlagsCardState;
        private final ModifiableFlag idFlagsAttackModifier;
        private String imageSetOriginal;

        public IndexedInstance(int cardId) {
            super(cardId);
            this.idCardType = new CardDataType(Card.this.type);
            this.idLRIGType = new CardDataLRIGType(Card.this.dataLRIGType);
            this.idSIGNIClass = new CardDataSIGNIClass(Card.this.dataSIGNIClass);
            this.idColor = new CardDataColor(Card.this.dataColor);
            this.idCost = Card.this.dataCost.exportAsCostListsDataArray();
            this.idName = new ModifiableString(Card.this.nameOriginal);
            this.idLevel = new ModifiableInteger(Card.this.level, 0, 5);
            this.idLimit = new ModifiableDouble(Card.this.limit);
            this.idPower = new ModifiableDouble(Card.this.power);
            this.idFlagsUseTiming = new ModifiableFlag(Card.this.flagsUseTiming);
            this.idFlagsCardState = new ModifiableFlag(Card.this.flagsCard & 0xFFFFFFFD);
            this.idFlagsAttackModifier = new ModifiableFlag(0);
        }

        public final void resetStats() {
            this.resetStats(false);
        }

        public final void resetStats(boolean isSafe) {
            if (this.isState(4096)) {
                return;
            }
            Game.getCurrentGame().getChronoScheduler().eraseChronoRecords(this.getCardIndex(), isSafe);
            this.idLRIGType.resetValue();
            this.idSIGNIClass.resetValue();
            this.idColor.resetValue();
            this.idLevel.resetValue();
            this.idLimit.resetValue();
            this.idPower.resetValue();
            this.idFlagsUseTiming.resetValue();
            int flagsToRetain = this.idFlagsCardState.getValue() & 0x1A08;
            this.idFlagsCardState.resetValue();
            if (flagsToRetain != 0) {
                this.idFlagsCardState.addValue(flagsToRetain);
            }
            this.idFlagsAttackModifier.resetValue();
            this.getCardIndex().setUnderType(GameConst.CardUnderType.NONE);
            if ((flagsToRetain & 0x800) == 0) {
                this.resetAbilityFlags();
            }
            this.updateInstanceId();
        }

        public final void setOnInstanceIdUpdated(OnInstanceIdUpdatedHandler handlerInstanceId) {
            this.handlerInstanceId = handlerInstanceId;
        }

        public final void resetAbilityFlags() {
            ArrayList<Ability> abilities = new ArrayList<Ability>(this.getAbilityList());
            for (Ability ability : abilities) {
                ability.resetFlags();
            }
        }

        public final int getInstanceId() {
            return this.instanceId;
        }

        public final void updateInstanceId() {
            if (this.handlerInstanceId != null) {
                this.handlerInstanceId.handle(this.instanceId);
                this.handlerInstanceId = null;
            }
            this.instanceId = ++lastInstanceId;
        }

        public final CardDataType getCardType() {
            return this.idCardType;
        }

        public final CardDataLRIGType getLRIGType() {
            return this.idLRIGType;
        }

        public final CardDataSIGNIClass getSIGNIClass() {
            return this.idSIGNIClass;
        }

        public final CardDataColor getColor() {
            return this.idColor;
        }

        public final List<AbilityCostList> getCost() {
            return this.idCost;
        }

        public final ModifiableString getName() {
            return this.idName;
        }

        public final ModifiableInteger getLevel() {
            return this.idLevel;
        }

        public final ModifiableDouble getLimit() {
            return this.idLimit;
        }

        public final ModifiableDouble getPower() {
            return this.idPower;
        }

        public final ModifiableFlag getUseTimingFlags() {
            return this.idFlagsUseTiming;
        }

        public final ModifiableFlag getCardStateFlags() {
            return this.idFlagsCardState;
        }

        public final ModifiableFlag getAttackModifierFlags() {
            return this.idFlagsAttackModifier;
        }

        public final Game.GamePlayerRole getCurrentOwner() {
            return !this.isState(512) ? CardIndex.getOriginalOwner(this.getCardId()) : Game.GamePlayerRole.getOpponentRole(CardIndex.getOriginalOwner(this.getCardId()));
        }

        public final void setOriginalImageSet(String imageSet) {
            this.imageSetOriginal = imageSet;
        }

        public final String getOriginalImageSet() {
            return this.imageSetOriginal;
        }

        public final boolean isState(int flagCardState) {
            return (this.idFlagsCardState.getValue() & flagCardState) != 0;
        }

        public final boolean hasAttackModifier(int flagAttackModifier) {
            return (this.idFlagsAttackModifier.getValue() & flagAttackModifier) != 0;
        }

        public final boolean isCrossed() {
            return this.isState(393216);
        }

        @Override
        public void dispose() {
            this.handlerInstanceId = null;
            this.idCost.forEach(AbilityCostList::dispose);
            this.idCost.clear();
            super.dispose();
        }

        @FunctionalInterface
        public static interface OnInstanceIdUpdatedHandler {
            public void handle(Integer var1);
        }
    }
}

