/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import open.batoru.data.Card;
import open.batoru.data.CardLoader;

public class CardDataImageSet {
    private final List<String> data = new ArrayList<String>();

    public void set(Card cardObject, String ... imageSets) {
        for (String imageSet : imageSets) {
            MaskType maskType;
            switch (imageSet.charAt(0)) {
                case '!': {
                    MaskType maskType2 = MaskType.IGNORE;
                    break;
                }
                case '=': {
                    MaskType maskType2 = MaskType.VERTICAL;
                    break;
                }
                case '<': {
                    MaskType maskType2 = MaskType.PORTRAIT_OFFSET_LEFT;
                    break;
                }
                case '>': {
                    MaskType maskType2 = MaskType.PORTRAIT_OFFSET_RIGHT;
                    break;
                }
                case '\\': {
                    MaskType maskType2 = MaskType.PORTRAIT_OFFSET_CENTER_RIGHT;
                    break;
                }
                case '&': {
                    MaskType maskType2 = MaskType.DOUBLE_FACED_UR;
                    break;
                }
                default: {
                    MaskType maskType2 = maskType = MaskType.NORMAL;
                }
            }
            if (maskType != MaskType.NORMAL && maskType != MaskType.DOUBLE_FACED_UR) {
                imageSet = imageSet.substring(1);
            }
            this.data.add(imageSet);
            CardLoader.addImageSet(imageSet, cardObject, maskType);
        }
    }

    public String getPrimaryImageSet() {
        return !this.data.isEmpty() ? this.data.getFirst() : "";
    }

    public String getImageSetByPrefixBias(String imageSetPrefix) {
        if (!this.data.isEmpty() && !this.getPrimaryImageSet().startsWith(imageSetPrefix)) {
            for (String imageSet : this.data) {
                if (!imageSet.startsWith(imageSetPrefix)) continue;
                return imageSet;
            }
        }
        return this.getPrimaryImageSet();
    }

    public int getImageSetIndex(String imageSet) {
        return this.data.indexOf(imageSet);
    }

    public List<String> getDataArray() {
        return Collections.unmodifiableList(this.data);
    }

    public String getImageSetByArrayId(int index) {
        return index >= 0 && index < this.data.size() ? this.data.get(index) : "";
    }

    public int getImageSetsNum() {
        return this.data.size();
    }

    public static String getDoubleFacedPairImageSet(Card cardObject, String imageSet) {
        if (cardObject.getDoubleFacedCardPairObject() == null) {
            return "";
        }
        return cardObject.getDoubleFacedCardPairObject().getImageSets().getImageSetByArrayId(cardObject.getImageSets().getImageSetIndex(imageSet));
    }

    public static String compressImageSetData(String data) {
        return data.replace("00", "*").replace("-0", "/").replace("WD", "d").replace("WX", "x").replace("SP", "s").replace("PR", "p").replace("CP0", "c").replace(",0", "^");
    }

    public static String decompressImageSetData(String data) {
        return data.replace("*", "00").replace("/", "-0").replace("d", "WD").replace("x", "WX").replace("s", "SP").replace("p", "PR").replace("c", "CP0").replace("^", ",0");
    }

    public static enum MaskType {
        NORMAL,
        IGNORE,
        VERTICAL,
        PORTRAIT_OFFSET_LEFT,
        PORTRAIT_OFFSET_RIGHT,
        PORTRAIT_OFFSET_CENTER_RIGHT,
        DOUBLE_FACED_UR;

    }

    public static class Mask {
        public static final char IGNORE = '!';
        public static final char VERTICAL = '=';
        public static final char PORTRAIT_OFFSET_LEFT = '<';
        public static final char PORTRAIT_OFFSET_RIGHT = '>';
        public static final char PORTRAIT_OFFSET_CENTER_RIGHT = '\\';
        public static final char DOUBLE_FACED_UR = '&';
    }
}

