/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import open.batoru.UtilRandom;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.cards.Token_Hastalyk;
import open.batoru.data.cards.Token_LRIGBarrier;
import open.batoru.data.cards.Token_LimitUpper;
import open.batoru.data.cards.Token_MikomikoBodyguard;
import open.batoru.data.cards.Token_SIGNIBarrier;

public final class CardLoader {
    private static final List<Card> dataCardObjects = new ArrayList<Card>();
    private static final Map<String, Card> dataImageSets = new HashMap<String, Card>();
    private static final Map<String, CardDataImageSet.MaskType> dataImageSetsMask = new HashMap<String, CardDataImageSet.MaskType>();
    private static final Map<Card, String> dataDoubleFacedImageSetHints = new HashMap<Card, String>();
    private static final Map<Card, List<String>> dataLinkedImageSets = new HashMap<Card, List<String>>();

    public static void load() {
        URLClassLoader classLoader;
        if (!dataCardObjects.isEmpty()) {
            return;
        }
        File pathCards = new File("./cards/");
        File[] listSourceFiles = pathCards.listFiles((dir, name) -> name.endsWith(".java"));
        if (listSourceFiles == null) {
            System.err.println("Error: No card files found.");
            return;
        }
        try {
            File pathCompiled = new File("./cards/compiled/");
            if (!pathCompiled.exists() && !pathCompiled.mkdir()) {
                System.err.println("Error: Couldn't create compiled directory.");
                return;
            }
            classLoader = new URLClassLoader(new URL[]{pathCompiled.toURI().toURL()});
        }
        catch (SecurityException | MalformedURLException ex) {
            System.err.println(ex.getMessage());
            return;
        }
        ArrayList<File> listUncompiledCardFiles = new ArrayList<File>();
        for (File file : listSourceFiles) {
            File fileCompiled = new File(file.getAbsolutePath().replace("cards" + File.separatorChar, "cards/compiled/open/batoru/data/cards/").replace("java", "class"));
            if (!fileCompiled.exists()) {
                System.out.println("To be compiled: " + file.getName());
                listUncompiledCardFiles.add(file);
                continue;
            }
            CardLoader.loadCardClassFromFile(classLoader, fileCompiled);
        }
        if (!listUncompiledCardFiles.isEmpty()) {
            System.out.println("Compiling new cards. Please, wait...");
            System.setProperty("java.home", !System.getProperty("os.name").toLowerCase().contains("mac") ? "./jdk/" : "./jdk/Contents/Home/");
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, StandardCharsets.UTF_8);){
                ArrayList<String> listOptions = new ArrayList<String>();
                listOptions.add("-cp");
                listOptions.add(System.getProperty("java.class.path"));
                listOptions.add("-d");
                listOptions.add("./cards/compiled/");
                Iterable<? extends JavaFileObject> compilationUnit = fileManager.getJavaFileObjectsFromFiles(listUncompiledCardFiles);
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, listOptions, null, compilationUnit);
                if (task.call().booleanValue()) {
                    for (File file : listUncompiledCardFiles) {
                        CardLoader.loadCardClassFromFile(classLoader, file);
                    }
                    System.out.println(listUncompiledCardFiles.size() + " new cards compiled.");
                } else {
                    for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                        System.err.println("*** Error on line " + diagnostic.getLineNumber() + " in " + String.valueOf(((JavaFileObject)diagnostic.getSource()).toUri()) + ":");
                        System.err.println("* " + diagnostic.getMessage(null));
                    }
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        System.out.println(dataCardObjects.size() + " cards loaded successfully!");
        CardLoader.linkDoubleFacedCardPairs();
        CardLoader.linkImageSets();
        CardLoader.registerTokens();
    }

    private static void loadCardClassFromFile(URLClassLoader classLoader, File file) {
        try {
            Class<?> classCard = classLoader.loadClass("open.batoru.data.cards." + file.getName().substring(0, file.getName().lastIndexOf(46)));
            Object classObject = classCard.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (classObject instanceof Card) {
                Card card = (Card)classObject;
                CardLoader.registerCard(card);
            } else {
                System.err.println("Error: File " + file.getName() + " is not a valid Card class!");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private static void registerTokens() {
        CardLoader.registerCard(new Token_Hastalyk());
        CardLoader.registerCard(new Token_MikomikoBodyguard());
        CardLoader.registerCard(new Token_SIGNIBarrier());
        CardLoader.registerCard(new Token_LRIGBarrier());
        CardLoader.registerCard(new Token_LimitUpper());
    }

    private static void registerCard(Card cardObject) {
        dataCardObjects.add(cardObject);
        cardObject.onCardRegistered();
        if (cardObject.getDoubleFacedCardPairImageSetHint() != null) {
            dataDoubleFacedImageSetHints.put(cardObject, cardObject.getDoubleFacedCardPairImageSetHint());
        }
        if (cardObject.getLinkedImageSets() != null) {
            dataLinkedImageSets.put(cardObject, List.copyOf(cardObject.getLinkedImageSets()));
        }
    }

    private static void linkDoubleFacedCardPairs() {
        int countLinkedPairs = 0;
        for (Map.Entry<Card, String> entry : dataDoubleFacedImageSetHints.entrySet()) {
            Card cardObject = entry.getKey();
            String imageSet = entry.getValue();
            Card cardObject2 = CardLoader.getCardByImageSet(imageSet);
            if (cardObject2 == null) {
                System.err.println("Warning: Missing card pair for double-faced card: " + String.valueOf(cardObject));
                return;
            }
            cardObject.setDoubleFacedCardPairObject(cardObject2);
            cardObject2.setDoubleFacedCardPairObject(cardObject);
            cardObject2.setCardFace(CardConst.CardFace.BACK);
            ++countLinkedPairs;
            cardObject2.setDoubleFacedCardPairImageSetHint(null);
        }
        if (countLinkedPairs > 0) {
            System.out.println("Linked " + countLinkedPairs + " double-faced card pairs.");
        }
    }

    private static void linkImageSets() {
        for (Map.Entry<Card, List<String>> entry : dataLinkedImageSets.entrySet()) {
            Card cardObject = entry.getKey();
            List<String> linkedImageSets = entry.getValue();
            for (String imageSet : linkedImageSets) {
                Card cardObject2 = CardLoader.getCardByImageSet(imageSet);
                if (cardObject2 == null) continue;
                cardObject2.setLinkedImageSets(cardObject.getImageSets().getPrimaryImageSet());
            }
        }
    }

    public static List<Card> getDataCardObjects() {
        return Collections.unmodifiableList(dataCardObjects);
    }

    public static void addImageSet(String imageSet, Card card, CardDataImageSet.MaskType maskType) {
        if (maskType != CardDataImageSet.MaskType.DOUBLE_FACED_UR) {
            if (!imageSet.isEmpty()) {
                if (!new File("images/cards/" + imageSet + ".jpg").exists()) {
                    System.err.println("Warning: Missing ImageSet file \"" + imageSet + "\" for card: " + String.valueOf(card));
                }
            } else {
                System.err.println("Warning: No ImageSets listed for card: " + String.valueOf(card));
                return;
            }
        }
        if (dataImageSets.containsKey(imageSet) && dataImageSets.get(imageSet) != card) {
            System.err.println("Warning: Duplicate ImageSet listed for card: " + String.valueOf(card) + " (original: " + String.valueOf(dataImageSets.get(imageSet)) + ")");
        }
        dataImageSets.put(imageSet, card);
        if (maskType != CardDataImageSet.MaskType.NORMAL) {
            dataImageSetsMask.put(imageSet, maskType);
        }
    }

    public static Card getCardByImageSet(String imageSet) {
        return dataImageSets.get(imageSet);
    }

    public static CardDataImageSet.MaskType getImageSetMaskType(String imageSet) {
        return dataImageSetsMask.getOrDefault(imageSet, CardDataImageSet.MaskType.NORMAL);
    }

    public static int getTotalCards() {
        return dataCardObjects.size();
    }

    @Deprecated
    public static String getRandomCardImageSet() {
        return dataCardObjects.get(UtilRandom.get_z(dataCardObjects.size())).getImageSets().getPrimaryImageSet();
    }

    private CardLoader() {
    }
}

