/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class CircularList<E> {
    private final List<ListElement<E>> elements = new ArrayList<ListElement<E>>();

    public List<E> listWithOriginalOrder() {
        ArrayList<ListElement<ListElement>> list = new ArrayList<ListElement<ListElement>>(this.elements);
        list.sort(Comparator.comparingInt(ListElement::getOriginalIndex));
        return list.stream().map(ListElement::getValue).toList();
    }

    public void add(E value) {
        int originalIndex = this.elements.size();
        ListElement<E> newElement = new ListElement<E>(value, originalIndex);
        this.elements.add(newElement);
    }

    public void moveForward(E value) {
        int currentIndex = this.indexOfValue(value);
        ListElement<E> elem = this.elements.remove(currentIndex);
        int newIndex = (currentIndex + 1) % (this.elements.size() + 1);
        this.elements.add(newIndex, elem);
        this.recalcAllDiffs();
    }

    public void moveBackward(E value) {
        int currentIndex = this.indexOfValue(value);
        ListElement<E> elem = this.elements.remove(currentIndex);
        int newIndex = (currentIndex - 1 + (this.elements.size() + 1)) % (this.elements.size() + 1);
        this.elements.add(newIndex, elem);
        this.recalcAllDiffs();
    }

    public void moveToTop(E value) {
        int currentIndex;
        while ((currentIndex = this.indexOfValue(value)) != 0) {
            this.moveBackward(value);
        }
    }

    public void clear() {
        this.elements.clear();
    }

    public int size() {
        return this.elements.size();
    }

    public E getValueAt(int currentIndex) {
        this.checkIndex(currentIndex);
        return this.elements.get(currentIndex).getValue();
    }

    public int getDiffOf(E value) {
        int index = this.indexOfValue(value);
        return this.elements.get(index).getDiff();
    }

    public String toString() {
        return this.elements.toString();
    }

    private int indexOfValue(E value) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!Objects.equals(this.elements.get(i).getValue(), value)) continue;
            return i;
        }
        throw new IllegalArgumentException("Value not found in list: " + String.valueOf(value));
    }

    private void swap(int i, int j) {
        ListElement<E> elemI = this.elements.get(i);
        ListElement<E> elemJ = this.elements.get(j);
        this.elements.set(i, elemJ);
        this.elements.set(j, elemI);
        this.recalcDiff(i);
        this.recalcDiff(j);
    }

    private void recalcAllDiffs() {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.recalcDiff(i);
        }
    }

    private void recalcDiff(int currentIndex) {
        ListElement<E> le = this.elements.get(currentIndex);
        le.setDiff(currentIndex - le.getOriginalIndex());
    }

    private void checkIndex(int currentIndex) {
        if (currentIndex < 0 || currentIndex >= this.elements.size()) {
            throw new IndexOutOfBoundsException("Index " + currentIndex + " out of bounds for size " + this.elements.size());
        }
    }

    private static class ListElement<E> {
        private final E value;
        private final int originalIndex;
        private int diff;

        public ListElement(E value, int originalIndex) {
            this.value = value;
            this.originalIndex = originalIndex;
            this.diff = 0;
        }

        public E getValue() {
            return this.value;
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }

        public int getDiff() {
            return this.diff;
        }

        public void setDiff(int diff) {
            this.diff = diff;
        }

        public String toString() {
            return String.format("[value=%s, originalIndex=%d, diff=%d]", this.value, this.originalIndex, this.diff);
        }
    }
}

