/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DataTable<T> {
    private final List<T> dataTable = new ArrayList<T>();

    public DataTable() {
    }

    public DataTable(T data) {
        this.dataTable.add(data);
    }

    public DataTable(List<T> listCards) {
        if (listCards != null) {
            this.dataTable.addAll(listCards);
        } else {
            this.dataTable.add(null);
        }
    }

    public void addAll(DataTable<T> dataTable) {
        if (dataTable == null) {
            return;
        }
        for (int i = 0; i < dataTable.size(); ++i) {
            this.add(dataTable.get(i));
        }
    }

    public void add(T data) {
        if (data == null && !this.dataTable.isEmpty()) {
            return;
        }
        this.dataTable.removeIf(Objects::isNull);
        this.dataTable.add(data);
    }

    public boolean isEmpty() {
        return this.dataTable.isEmpty();
    }

    public int size() {
        return this.dataTable.size();
    }

    public void clear() {
        this.dataTable.clear();
    }

    public boolean contains(T data) {
        return this.dataTable.contains(data);
    }

    public Stream<T> stream() {
        return this.dataTable.stream();
    }

    public DataTable<T> andRemoveIf(Predicate<? super T> predicate) {
        this.dataTable.removeIf(predicate);
        return this;
    }

    public void removeDuplicates() {
        ArrayList<T> unique = new ArrayList<T>();
        for (T item : this.dataTable) {
            if (unique.contains(item)) continue;
            unique.add(item);
        }
        this.dataTable.clear();
        this.dataTable.addAll(unique);
    }

    public T get() {
        return this.get(0);
    }

    public T get(int arrayId) {
        return this.dataTable.get(arrayId);
    }
}

