/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ValueByReference;
import open.batoru.data.ability.Ability;

public abstract class ModifiableVariable<T, V, M extends ModifiableVariable<T, V, M>> {
    private final V defaultValue;
    private final List<ModifiableValueReference<V>> baseValues = new ArrayList<ModifiableValueReference<V>>();
    private final List<ModifiableValueReference<T>> addedValues = new ArrayList<ModifiableValueReference<T>>();
    private final List<ExternalValue<T>> externalValues = new ArrayList<ExternalValue<T>>();
    private final List<OnValueChangedHandler<V>> listValueListeners = new ArrayList<OnValueChangedHandler<V>>();
    private final List<AddedValueModifierHandler<T, M>> listAddedValueModifiers = new ArrayList<AddedValueModifierHandler<T, M>>();
    private final List<ValueByReference<V>> listValueByRef = new ArrayList<ValueByReference<V>>();
    private final List<Ability> listValueByRefSourceAbilityRef = new ArrayList<Ability>();
    private Ability sourceAbility;
    private CardIndex sourceCardIndex;

    public ModifiableVariable(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ModifiableValueReference<V> setBaseValue(V newValue) {
        if (newValue == null) {
            return null;
        }
        V oldValue = this.getValue();
        ModifiableValueReference<V> valueReference = new ModifiableValueReference<V>(newValue);
        this.baseValues.add(valueReference);
        this.notifyOnValueChanged(oldValue);
        return valueReference;
    }

    public void removeBaseValue(ModifiableValueReference<V> valueReference) {
        if (valueReference == null) {
            return;
        }
        V oldValue = this.getValue();
        if (this.baseValues.remove(valueReference)) {
            this.notifyOnValueChanged(oldValue);
        }
    }

    public boolean containsBaseValue(ModifiableValueReference<V> value) {
        return this.baseValues.contains(value);
    }

    public ModifiableValueReference<T> addValue(T newValue) {
        if (newValue == null) {
            return null;
        }
        V oldValue = this.getValue();
        for (AddedValueModifierHandler<T, M> handler : this.listAddedValueModifiers) {
            newValue = handler.handle(this.self(), newValue);
        }
        ModifiableValueReference<T> valueReference = new ModifiableValueReference<T>(newValue);
        this.addedValues.add(valueReference);
        this.notifyOnValueChanged(oldValue);
        return valueReference;
    }

    public void removeValue(ModifiableValueReference<T> valueReference) {
        if (valueReference == null) {
            return;
        }
        V oldValue = this.getValue();
        if (this.addedValues.remove(valueReference)) {
            this.notifyOnValueChanged(oldValue);
        }
    }

    public boolean containsAddedValue(ModifiableValueReference<T> value) {
        return this.addedValues.contains(value);
    }

    public T testAddedValue(T newValue) {
        if (newValue == null) {
            return null;
        }
        for (AddedValueModifierHandler<T, M> handler : this.listAddedValueModifiers) {
            newValue = handler.handle(this.self(), newValue);
        }
        return newValue;
    }

    public void resetValue() {
        V oldValue = this.getValue();
        this.baseValues.clear();
        this.addedValues.clear();
        this.notifyOnValueChanged(oldValue);
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public V getBaseValue() {
        return this.baseValues.isEmpty() ? this.getDefaultValue() : this.baseValues.getLast().value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifiableValueReference<T>> getAddedValuesSnapshot() {
        List<ExternalValue<T>> externalValues;
        List<ModifiableValueReference<T>> addedValues;
        ModifiableVariable modifiableVariable = this;
        synchronized (modifiableVariable) {
            addedValues = List.copyOf(this.addedValues);
            externalValues = List.copyOf(this.externalValues);
        }
        ArrayList<ModifiableValueReference<T>> snapshot = new ArrayList<ModifiableValueReference<T>>(addedValues.size() + externalValues.size());
        snapshot.addAll(addedValues);
        for (ExternalValue<T> externalValue : externalValues) {
            snapshot.add(new ModifiableValueReference<T>(externalValue.getValue()));
        }
        return Collections.unmodifiableList(snapshot);
    }

    public abstract V getValue();

    private void notifyOnValueChanged(V oldValue) {
        if (oldValue == null || this.listValueListeners.isEmpty()) {
            return;
        }
        V newValue = this.getValue();
        for (OnValueChangedHandler<V> handler : this.listValueListeners) {
            handler.handle(oldValue, newValue);
        }
    }

    public final void setSourceAbility(Ability ability) {
        this.sourceAbility = ability;
    }

    public final Ability getSourceAbility() {
        return this.sourceAbility;
    }

    public final void setSourceCardIndex(CardIndex cardIndex) {
        this.sourceCardIndex = cardIndex;
    }

    public final CardIndex getSourceCardIndex() {
        return this.sourceCardIndex;
    }

    public void addValueListener(OnValueChangedHandler<V> handler) {
        this.listValueListeners.add(handler);
    }

    public void removeValueListener(OnValueChangedHandler<V> handler) {
        this.listValueListeners.remove(handler);
    }

    public void addAddedValueModifier(AddedValueModifierHandler<T, M> handler) {
        this.listAddedValueModifiers.add(handler);
    }

    public void removeAddedValueModifier(AddedValueModifierHandler<T, M> handler) {
        this.listAddedValueModifiers.remove(handler);
    }

    public void addExternalValue(ExternalValue<T> externalValue) {
        this.externalValues.add(externalValue);
    }

    public void removeExternalValue(ExternalValue<T> externalValue) {
        this.externalValues.remove(externalValue);
    }

    public boolean hasExternalValue() {
        return !this.externalValues.isEmpty();
    }

    public void adoptByReferenceValues(ModifiableVariable<T, V, M> modDonor) {
        for (int i = 0; i < modDonor.getDataByReferenceValues().size(); ++i) {
            this.addByReferenceValue(modDonor.getDataByReferenceValues().get(i), modDonor.getValueByReferenceSourceAbilityRef(i));
        }
    }

    public void addByReferenceValue(ValueByReference<V> handler, Ability sourceAbilityRC) {
        this.listValueByRef.add(handler);
        this.listValueByRefSourceAbilityRef.add(sourceAbilityRC);
    }

    public void removeByReferenceValue(ValueByReference<V> handler) {
        int arrayId = this.listValueByRef.indexOf(handler);
        if (arrayId != -1) {
            this.listValueByRef.remove(arrayId);
            this.listValueByRefSourceAbilityRef.remove(arrayId);
        }
    }

    public List<ValueByReference<V>> getDataByReferenceValues() {
        return this.listValueByRef;
    }

    public Ability getValueByReferenceSourceAbilityRef(int arrayId) {
        return arrayId >= 0 && arrayId < this.listValueByRefSourceAbilityRef.size() ? this.listValueByRefSourceAbilityRef.get(arrayId) : null;
    }

    private M self() {
        return (M)this;
    }

    public record ModifiableValueReference<T>(T value) {
    }

    @FunctionalInterface
    public static interface AddedValueModifierHandler<T, M extends ModifiableVariable<T, ?, M>> {
        public T handle(M var1, T var2);
    }

    @FunctionalInterface
    public static interface ExternalValue<T> {
        public T getValue();
    }

    @FunctionalInterface
    public static interface OnValueChangedHandler<V> {
        public void handle(V var1, V var2);
    }
}

