/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.ArrayList;
import java.util.List;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.catalog.description.EnerCostDescriptionModifier;
import open.batoru.core.Deck;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEffectActivateResolve;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableFlag;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConditionNoSource;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.AbilityEffect;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.AbilityEffectWithSource;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.game._3d.Card3D;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public abstract class Ability
implements Disposable {
    private int abilityId;
    private String abilityName;
    private final List<String> listNestedAbilityDescriptions = new ArrayList<String>();
    private int abilityNestedDescriptionOffset;
    private EnerCostDescriptionModifier enerCostDescriptionModifier;
    private int numModifiedEnerCosts;
    private final List<AbilityHandler> listHandlersOnAbilityEnabled = new ArrayList<AbilityHandler>();
    private final List<AbilityHandler> listHandlersOnAbilityDisabled = new ArrayList<AbilityHandler>();
    private DynamicAbilityDescriptionHandler handlerDynamicDescription;
    private OnAbilityInitHandler handlerOnAbilityInit;
    private int sourceCardId;
    private CardIndex sourceCardIndex;
    private AbilityCondition condition = AbilityConditionWithSource.ALWAYS_TRUE;
    private final List<AbilityCostList> costs = new ArrayList<AbilityCostList>();
    private AbilityEffect effect;
    private GameConst.GameEventId activeEvent;
    private final List<GameConst.CardLocation> listActiveLocations = new ArrayList<GameConst.CardLocation>();
    private ModifiableFlag flagsUseTiming = new ModifiableFlag(0);
    private CardConst.CardType cutInExpectedCardType;
    private int flagsUnderType;
    private int recollectCount;
    private ActionPayCost lastCostCallbackAction;
    private ActionEffectActivateResolve lastEffectCallbackAction;
    private AbilityConst.UseLimit useLimitType;
    private ModifiableInteger useLimit;
    private List<ChronoRecordScheduler.ChronoRecord> useLimitChronoRecords;
    private StockAbility sourceStockAbility;
    private Ability sourceAttachAbility;
    private Game.GamePlayerRole sourceAttachPlayerRole;
    private String cachedAbilityDescription;
    private String cachedSourceCardName;
    private String cachedSourceCardImageSet;
    private final ModifiableFlag flags = new ModifiableFlag(0);
    private int flagsDefault;

    public final void setSourceCardId(int sourceCardId) {
        this.sourceCardId = sourceCardId;
        if (this.sourceCardIndex != null) {
            this.sourceCardIndex = null;
        }
    }

    public final int getSourceCardId() {
        return this.sourceCardId;
    }

    public final CardIndex getSourceCardIndex() {
        if (this.sourceCardIndex == null) {
            this.sourceCardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(this.sourceCardId);
        }
        return this.sourceCardIndex;
    }

    public final void setAbilityId(int abilityId) {
        this.abilityId = abilityId;
    }

    public final int getAbilityId() {
        return this.abilityId;
    }

    public final void setSourceStockAbility(StockAbility sourceStockAbility) {
        this.sourceStockAbility = sourceStockAbility;
    }

    public final StockAbility getSourceStockAbility() {
        return this.sourceStockAbility;
    }

    public final void setSourceAttachAbility(Ability sourceAttachAbility) {
        this.sourceAttachAbility = sourceAttachAbility;
    }

    public final Ability getSourceAttachAbility() {
        return this.sourceAttachAbility;
    }

    public final void setSourceAttachPlayerRole(Game.GamePlayerRole rolePlayer) {
        this.sourceAttachPlayerRole = rolePlayer;
    }

    public final Game.GamePlayerRole getSourceAttachPlayerRole() {
        return this.sourceAttachPlayerRole;
    }

    public final Game.GamePlayerRole getAbilityOwner() {
        return this.sourceAttachPlayerRole == null ? this.getSourceCardIndex().getCurrentOwnerSafe() : this.sourceAttachPlayerRole;
    }

    public void resetFlags() {
        int flagsToRetain = 0;
        if (this.getSourceCardIndex().getIndexedInstance() != null && this.getSourceCardIndex().getIndexedInstance().isState(2048)) {
            int value = this.flags.getValue();
            if ((value & 0x2000) != 0) {
                this.flags.removeValue(8192);
                return;
            }
            if ((value & 0x4000) != 0) {
                this.flags.removeValue(16384);
                flagsToRetain |= value & 0x60;
            } else if ((value & 0x8000) != 0) {
                this.enable();
                this.flags.removeValue(32768);
            }
        }
        this.flags.resetValue();
        this.flags.setBaseValue(this.flagsDefault);
        if (flagsToRetain > 0) {
            this.flags.addValue(flagsToRetain);
        }
        this.removeUseLimitChronoRecords();
    }

    public final String getNestedAbilityDescription(int nestedOffset) {
        return this.listNestedAbilityDescriptions.get(nestedOffset != -1 ? nestedOffset : 0);
    }

    public final void addNestedAbilityDescription(String description) {
        this.listNestedAbilityDescriptions.add(this.listNestedAbilityDescriptions.size(), description);
    }

    public final void appendNestedAbilityDescription(int i, String description) {
        this.listNestedAbilityDescriptions.set(i, this.listNestedAbilityDescriptions.get(i) + description);
    }

    public final int getTotalNestedAbilityDescriptions() {
        return this.listNestedAbilityDescriptions.size();
    }

    public final void setNestedDescriptionOffset(int offset) {
        this.abilityNestedDescriptionOffset = offset;
    }

    public final int getNestedDescriptionOffset() {
        return this.abilityNestedDescriptionOffset;
    }

    public final void setDynamicAbilityDescription(DynamicAbilityDescriptionHandler handlerDynamicDescription) {
        this.handlerDynamicDescription = handlerDynamicDescription;
    }

    public final DynamicAbilityDescriptionHandler getDynamicAbilityDescriptionHandler() {
        return this.handlerDynamicDescription;
    }

    public final void addEnerCostDescriptionModifier() {
        if (this.enerCostDescriptionModifier == null) {
            this.enerCostDescriptionModifier = new EnerCostDescriptionModifier(this);
        }
        ++this.numModifiedEnerCosts;
    }

    public final void removeEnerCostDescriptionModifier() {
        if (this.enerCostDescriptionModifier != null && --this.numModifiedEnerCosts == 0) {
            this.enerCostDescriptionModifier = null;
        }
    }

    public EnerCostDescriptionModifier getEnerCostDescriptionModifier() {
        return this.enerCostDescriptionModifier;
    }

    public final void precacheAbilityInfo() {
        this.cachedAbilityDescription = this.sourceAttachAbility == null || this.abilityNestedDescriptionOffset == -1 ? DescriptionParser.getDefaultFullAbilityDescription(this) : DescriptionParser.getAbilityDescription(this);
        this.cachedSourceCardName = this.getSourceCardIndex().getCardReference().getName();
        this.cachedSourceCardImageSet = this.getSourceCardIndex().getImageSet();
    }

    public final String getCachedAbilityDescription() {
        return this.cachedAbilityDescription;
    }

    public final String getCachedSourceCardName() {
        return this.cachedSourceCardName;
    }

    public final String getCachedSourceCardImageSet() {
        return this.cachedSourceCardImageSet;
    }

    public final void setName(String abilityName) {
        this.abilityName = abilityName;
    }

    public final void setCondition(AbilityConditionWithSource condition) {
        this.condition = condition;
    }

    public final void setCondition(AbilityConditionNoSource condition) {
        this.condition = condition;
    }

    public final void setCost(List<AbilityCostList> dataCostLists) {
        this.costs.clear();
        for (AbilityCostList costList : dataCostLists) {
            costList.setSourceAbility(this);
            this.costs.add(costList);
        }
    }

    public final void setCost(AbilityCostList costList) {
        if (costList == null) {
            throw new IllegalArgumentException();
        }
        costList.setSourceAbility(this);
        this.costs.clear();
        this.costs.add(costList);
    }

    public final void setCost(AbilityCost ... costs) {
        if (costs.length == 0) {
            return;
        }
        AbilityCostList costList = new AbilityCostList(costs);
        costList.setSourceAbility(this);
        this.costs.add(costList);
    }

    public final void setEffect(AbilityEffectWithSource effect) {
        this.effect = effect;
    }

    public final void setEffect(AbilityEffectNoSource effect) {
        this.effect = effect;
        this.flags.addValue(1);
    }

    public final void setActiveEvent(GameConst.GameEventId event) {
        this.activeEvent = event;
        if (event == GameConst.GameEventId.EXCEED) {
            this.setActiveUnderFlags(GameConst.CardUnderType.UNDER_GENERIC);
        } else if (this.isActiveBySelfSourceOnly() && event == GameConst.GameEventId.DISCARD) {
            this.setActiveLocation(GameConst.CardLocation.HAND);
        }
    }

    public final void setActiveLocation(GameConst.CardLocation ... locations) {
        this.listActiveLocations.addAll(List.of(locations));
    }

    public final void setActiveUseTiming(int flagsUseTiming) {
        this.flagsUseTiming = new ModifiableFlag(flagsUseTiming);
    }

    public final void setActiveUnderFlags(GameConst.CardUnderType underType) {
        this.setActiveUnderFlags(underType.getFlags());
    }

    public final void setActiveUnderFlags(GameConst.CardUnderCategory underCategory) {
        this.setActiveUnderFlags(underCategory.getFlags());
    }

    public final void setActiveUnderFlags(int flagsUnderType) {
        this.flagsUnderType = flagsUnderType;
    }

    public final void setUseLimit(AbilityConst.UseLimit useLimitType, int useLimit) {
        this.useLimitType = useLimitType;
        this.useLimit = new ModifiableInteger(useLimit);
    }

    public final int getUseLimit() {
        return this.useLimit != null ? (Integer)this.useLimit.getDefaultValue() : 0;
    }

    public final String getName() {
        return this.abilityName;
    }

    private AbilityCondition getCondition() {
        return this.condition;
    }

    public final AbilityCondition.ConditionState getConditionState(CardIndex cardIndex) {
        TargetFilter.setDefaultSources(this.getSourceCardIndex(), this);
        return this.getCondition().getState(cardIndex);
    }

    public final List<AbilityCostList> getCostLists() {
        return this.costs;
    }

    public final AbilityCost getCost() {
        return this.getCost(0);
    }

    public final AbilityCost getCost(int costId) {
        return this.getCost(costId, 0);
    }

    public final AbilityCost getCost(int costId, int costListId) {
        return !this.costs.isEmpty() ? this.costs.get(costId).getDataArray().get(costListId) : null;
    }

    public final DataTable<AbilityCost.Payable> getCostPaidData() {
        return this.getCostPaidData(0);
    }

    public final DataTable<AbilityCost.Payable> getCostPaidData(int costId) {
        return this.getCostPaidData(costId, 0);
    }

    public final DataTable<AbilityCost.Payable> getCostPaidData(int costId, int costListId) {
        return this.getCost(costId) != null ? this.getCost(costId, costListId).getPaidCostData() : null;
    }

    public final void setOnAbilityInit(OnAbilityInitHandler handlerOnAbilityInit) {
        this.handlerOnAbilityInit = handlerOnAbilityInit;
    }

    public void onAbilityInit() {
        this.flagsDefault = this.flags.getValue();
        if (this.handlerOnAbilityInit != null) {
            this.handlerOnAbilityInit.handle();
        }
        this.precacheAbilityInfo();
    }

    public final void onAbilityAddedToBucket() {
        if (this.useLimitType == null || this.useLimit.getValue() <= 0) {
            return;
        }
        if (this.getSourceCardIndex().getIndexedInstance() != null && this.getSourceCardIndex().getIndexedInstance().isState(2048)) {
            this.flags.addValue(8192);
        }
        ModifiableVariable.ModifiableValueReference<Integer> valueLimit = this.useLimit.addValue(-1);
        if (this.useLimitType == AbilityConst.UseLimit.TURN) {
            if (this.useLimit.getValue() == 0) {
                ModifiableVariable.ModifiableValueReference<Integer> valueFlag = this.flags.addValue(16);
                ChronoRecordScheduler.ChronoRecord recordFlag = new ChronoRecordScheduler.ChronoRecord(ChronoDuration.turnEnd());
                recordFlag.setOnChronoRecordExpired(() -> this.flags.removeValue(valueFlag));
                this.addUseLimitChronoRecord(recordFlag);
            }
            ChronoRecordScheduler.ChronoRecord recordUseLimit = new ChronoRecordScheduler.ChronoRecord(ChronoDuration.turnEnd());
            recordUseLimit.setOnChronoRecordExpired(() -> this.useLimit.removeValue(valueLimit));
            this.addUseLimitChronoRecord(recordUseLimit);
        } else if (this.useLimitType == AbilityConst.UseLimit.GAME && this.useLimit.getValue() == 0) {
            this.flags.addValue(16);
        }
    }

    public void onAbilityEnd(boolean wasResolved) {
    }

    private void addUseLimitChronoRecord(ChronoRecordScheduler.ChronoRecord record) {
        if (this.useLimitChronoRecords == null) {
            this.useLimitChronoRecords = new ArrayList<ChronoRecordScheduler.ChronoRecord>();
        }
        this.useLimitChronoRecords.add(record);
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
    }

    private void removeUseLimitChronoRecords() {
        if (this.useLimitChronoRecords == null) {
            return;
        }
        this.useLimitChronoRecords.forEach(ChronoRecordScheduler.ChronoRecord::forceExpire);
        this.useLimitChronoRecords = null;
    }

    public final void resolveEffect(CardIndex cardIndex) {
        this.effect.resolve(cardIndex);
    }

    public final GameConst.GameEventId getActiveEvent() {
        return this.activeEvent;
    }

    public final List<GameConst.CardLocation> getActiveLocations() {
        return this.listActiveLocations;
    }

    public final ModifiableFlag getActiveUseTiming() {
        return this.flagsUseTiming;
    }

    public final int getActiveUnderFlags() {
        return this.flagsUnderType;
    }

    public final void setCutInExpectedCardType(CardConst.CardType cardType) {
        this.cutInExpectedCardType = cardType;
    }

    public final CardConst.CardType getCutInExpectedCardType() {
        return this.cutInExpectedCardType == null ? CardConst.CardType.SPELL : this.cutInExpectedCardType;
    }

    public final void setRecollect(int count) {
        this.flags.addValue(4096);
        this.recollectCount = count;
    }

    public final boolean hasRecollect() {
        return (this.flags.getValue() & 0x1000) != 0;
    }

    public final boolean isRecollectFulfilled() {
        if (this.recollectCount == 0) {
            return false;
        }
        ArrayList<Card3D> list = new ArrayList<Card3D>(UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getAbilityOwner()).getTrashZone(Deck.DeckType.LRIG).getZoneCardList());
        return list.stream().filter(card3D -> card3D.getCardIndex().getCardReference().getType() == CardConst.CardType.ARTS).count() >= (long)this.recollectCount;
    }

    public final ModifiableFlag getFlags() {
        return this.flags;
    }

    public final boolean isUseLimited() {
        return (this.flags.getValue() & 0x10) != 0;
    }

    public final boolean isActiveLocationIgnored() {
        return (this.flags.getValue() & 4) != 0;
    }

    public final boolean areActiveUnderFlagsIgnored() {
        return (this.flags.getValue() & 8) != 0;
    }

    public void mute() {
        this.flags.addValue(32);
    }

    public final void mute(ChronoDuration chronoDuration) {
        this.mute();
        if (chronoDuration != ChronoDuration.permanent()) {
            ChronoRecordScheduler.ChronoRecord recordFlag = new ChronoRecordScheduler.ChronoRecord(this.getSourceCardIndex(), chronoDuration);
            recordFlag.setOnChronoRecordExpired(this::unmute);
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(recordFlag);
        }
    }

    public final void transientMute() {
        this.flags.addValue(16384);
        this.mute();
    }

    public void unmute() {
        this.flags.removeValue(32);
    }

    public final boolean isMuted() {
        return (this.flags.getValue() & 0x20) != 0;
    }

    protected final void internalDisable() {
        this.flags.addValue(64);
    }

    protected final boolean internalEnable() {
        if (!this.isRegistered()) {
            return false;
        }
        if (this.getSourceCardIndex().getIndexedInstance().isState(2048) && (this.flags.getValue() & 0x8000) == 0) {
            this.flags.addValue(32768);
            return true;
        }
        this.flags.removeValue(64);
        return true;
    }

    public void disable() {
        if (!this.isDisabled() && this.isRegistered()) {
            this.callOnAbilityDisabledHandler(this.getSourceCardIndex());
        }
        this.internalDisable();
    }

    public final void disable(ChronoDuration chronoDuration) {
        this.disable();
        if (chronoDuration != ChronoDuration.permanent()) {
            ChronoRecordScheduler.ChronoRecord recordFlag = new ChronoRecordScheduler.ChronoRecord(this.getSourceCardIndex(), chronoDuration);
            recordFlag.setOnChronoRecordExpired(this::enable);
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(recordFlag);
        }
    }

    public final void transientDisable() {
        this.flags.addValue(16384);
        this.disable();
    }

    public void enable() {
        boolean wasDisabled = this.isDisabled();
        if (this.internalEnable() && wasDisabled && !this.isDisabled()) {
            this.callOnAbilityEnabledHandler(this.getSourceCardIndex());
        }
    }

    public final boolean isAlwaysActive() {
        return (this.flags.getValue() & 2) != 0;
    }

    public final boolean isDisabled() {
        return (this.flags.getValue() & 0x40) != 0;
    }

    public final void cancel() {
        this.flags.addValue(128);
    }

    public final boolean isCancelled() {
        return (this.flags.getValue() & 0x80) != 0;
    }

    public final boolean isActiveOncePerEffect() {
        return (this.flags.getValue() & 0x100) != 0;
    }

    public final void setLastCostCallbackAction(ActionPayCost callbackAction) {
        this.lastCostCallbackAction = callbackAction;
    }

    public final ActionPayCost getLastCostCallbackAction() {
        return this.lastCostCallbackAction;
    }

    public final void setLastEffectCallbackAction(ActionEffectActivateResolve callbackAction) {
        this.lastEffectCallbackAction = callbackAction;
    }

    public final ActionEffectActivateResolve getLastEffectCallbackAction() {
        return this.lastEffectCallbackAction;
    }

    public final boolean isBonded() {
        return (this.flags.getValue() & 0x800) != 0;
    }

    public final boolean isCopied() {
        return (this.flags.getValue() & 0x20000) != 0;
    }

    public final boolean isActiveBySelfSourceOnly() {
        return (this.flags.getValue() & 1) != 0;
    }

    public boolean isActiveDuringEvent(GameEvent event) {
        return this.activeEvent == event.getId();
    }

    public void setOnAbilityEnabled(AbilityHandler handleAbilityEnabled) {
        this.listHandlersOnAbilityEnabled.add(handleAbilityEnabled);
    }

    public void callOnAbilityEnabledHandler(CardIndex cardIndex) {
        if (!this.listHandlersOnAbilityEnabled.isEmpty()) {
            FX.run(() -> this.listHandlersOnAbilityEnabled.forEach(handler -> handler.handle(cardIndex)));
        }
    }

    public void setOnAbilityDisabled(AbilityHandler handleAbilityDisabled) {
        this.listHandlersOnAbilityDisabled.add(handleAbilityDisabled);
    }

    public void callOnAbilityDisabledHandler(CardIndex cardIndex) {
        if (!this.listHandlersOnAbilityDisabled.isEmpty()) {
            FX.run(() -> this.listHandlersOnAbilityDisabled.forEach(handler -> handler.handle(cardIndex)));
        }
    }

    public boolean isRegistered() {
        return this.getSourceAttachPlayerRole() != null || this.getSourceCardIndex().getIndexedInstance().getAbilityList().contains(this);
    }

    public boolean isInActiveLocation() {
        return (this.isActiveLocationIgnored() || this.getActiveLocations().isEmpty() && this.checkIsInDefaultExpectedLocation() || this.checkIsInSpecifiedActiveLocation()) && (this.areActiveUnderFlagsIgnored() || this.getActiveUnderFlags() == GameConst.CardUnderType.NONE.getFlags() && this.getSourceCardIndex().getUnderType() == GameConst.CardUnderType.NONE || (this.getActiveUnderFlags() & this.getSourceCardIndex().getUnderType().getFlags()) != 0);
    }

    private boolean checkIsInDefaultExpectedLocation() {
        if (this.getSourceCardIndex().isInDefaultExpectedLocation(this.getSourceCardIndex().getLocation())) {
            return true;
        }
        if (this.getSourceCardIndex().getIndexedInstance() == null || !this.getSourceCardIndex().getIndexedInstance().isState(2048)) {
            return false;
        }
        return this.getSourceCardIndex().isInDefaultExpectedLocation(this.getSourceCardIndex().getPreTransientLocation());
    }

    private boolean checkIsInSpecifiedActiveLocation() {
        GameConst.CardLocation location = this.getSourceCardIndex().getLocation();
        if (this.getActiveLocations().contains((Object)location)) {
            return true;
        }
        if ((location == GameConst.CardLocation.LOOKED || location == GameConst.CardLocation.REVEALED) && this.getActiveLocations().contains((Object)this.getSourceCardIndex().getOldLocation())) {
            return true;
        }
        if (this.getSourceCardIndex().getIndexedInstance() == null || !this.getSourceCardIndex().getIndexedInstance().isState(2048)) {
            return false;
        }
        return this.getActiveLocations().contains((Object)this.getSourceCardIndex().getPreTransientLocation());
    }

    @Override
    public void dispose() {
        this.listNestedAbilityDescriptions.clear();
        this.enerCostDescriptionModifier = null;
        this.listHandlersOnAbilityEnabled.clear();
        this.listHandlersOnAbilityDisabled.clear();
        this.handlerDynamicDescription = null;
        this.handlerOnAbilityInit = null;
        this.condition = null;
        this.effect = null;
        this.costs.forEach(AbilityCostList::dispose);
        this.costs.clear();
        this.sourceCardIndex = null;
        this.useLimitChronoRecords = null;
        if (this.sourceStockAbility != null) {
            this.sourceStockAbility.dispose();
            this.sourceStockAbility = null;
        }
        this.sourceAttachAbility = null;
    }

    public static Ability getRootSourceAttachAbility(Ability ability) {
        if (ability == null) {
            return null;
        }
        Ability sourceAttachAbility = ability.getSourceAttachAbility();
        if (sourceAttachAbility == null) {
            return ability;
        }
        while (sourceAttachAbility.getSourceAttachAbility() != null) {
            sourceAttachAbility = sourceAttachAbility.getSourceAttachAbility();
        }
        return sourceAttachAbility;
    }

    public static class AbilityFlag {
        public static final int NONE = 0;
        public static final int SELF_SOURCE_ONLY = 1;
        public static final int IGNORE_DISABLE = 2;
        public static final int IGNORE_LOCATION = 4;
        public static final int IGNORE_UNDER_FLAGS = 8;
        public static final int USE_LIMITED = 16;
        public static final int MUTED = 32;
        public static final int DISABLED = 64;
        public static final int CANCELLED = 128;
        public static final int ACTIVE_ONCE_PER_EFFECT = 256;
        public static final int RESOLVE_TWICE = 512;
        public static final int RESOLVE_BEFORE_RULE_PROC = 1024;
        public static final int BONDED = 2048;
        public static final int HAS_RECOLLECT = 4096;
        public static final int WAS_ACTIVATED_WHILE_TRANSIENT = 8192;
        public static final int RETAIN_DISABLED_WHILE_TRANSIENT = 16384;
        public static final int FORCE_ENABLE_AFTER_TRANSIENT = 32768;
        public static final int CAN_USE_AS_MANUAL_ACTION = 65536;
        public static final int COPIED = 131072;
    }

    @FunctionalInterface
    public static interface DynamicAbilityDescriptionHandler {
        public String getDescription();
    }

    @FunctionalInterface
    public static interface OnAbilityInitHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface AbilityHandler {
        public void handle(CardIndex var1);
    }
}

