/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventActivateAction;
import open.batoru.data.ability.events.GameEvent;

public class ActionAbility
extends Ability {
    public ActionAbility(AbilityCost cost, AbilityEffectNoSource effect) {
        this(new AbilityCostList(cost), effect);
    }

    public ActionAbility(AbilityCostList costList, AbilityEffectNoSource effect) {
        if (costList == null || effect == null) {
            throw new IllegalArgumentException();
        }
        this.setCost(costList);
        this.setEffect(effect);
        this.setActiveEvent(GameConst.GameEventId.ABILITY_ACTION);
        this.setActiveUseTiming(1);
    }

    @Override
    public boolean isActiveDuringEvent(GameEvent event) {
        return super.isActiveDuringEvent(event) && ((EventActivateAction)event).getActionAbilityId() == this.getAbilityId();
    }
}

